/*******************************************************************************
 * Copyright (c) 2006-2007 IONA Technologies.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.xef;

import java.util.Collection;

/**
 * The SchemaProvider provides all schemas available for new elements to be added. So in the case
 * of policies, the implementation should provide all the schemas of all the policies that can be
 * added to the service(s) currently being edited.
 */
public interface ISchemaProvider {
	/**
	 * Return all available schemas.
	 * @param filter Specify a filter if you do not want all the schemas to be listed. Specify
	 * <tt>null</tt> to run without a filter.
	 * @return A collection of namespaces (Strings).
	 */
    Collection<String> listSchemaNamespaces(String filter);
    
    /**
     * Returns a list of XML snippets that are known. These must only be based on schemas which are
     * also known
	 * @param filter Specify a filter if you do not want all the schemas to be listed. Specify
	 * <tt>null</tt> to run without a filter.
     * @return A collection of snippet names.
     */
    Collection<String> listSnippets(String filter);
    
    /**
     * Obtain the XML Schema for a particular namespace.
     * @param qname The namespace.
     * @return The Schema XML.
     */
    String getSchema(String namespace);
    
    /**
     * Obtain a specific XML snippet.
     * @param name The name of the snippet to look up.
     * @return The snippet XML.
     */
    String getSnippet(String name);
    
    /**
     * Refreshes the schema provider, in case it uses caching.
     */
    void refresh();
}
