/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.emf.refactoring;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stp.soas.internal.deploy.emf.refactoring.IReferenceNameChangeExtension;
import org.eclipse.stp.soas.internal.deploy.emf.refactoring.ResourceNameChangeAdapter;

public class ProjectRelativeNameChangeExtension
implements IReferenceNameChangeExtension {
    private EStructuralFeature mFeature;

    public ProjectRelativeNameChangeExtension(EStructuralFeature feature) {
        this.mFeature = feature;
    }

    public EStructuralFeature getFeature() {
        return this.mFeature;
    }

    public IResource getReferencedResource(EObject object, Object referenceValue) {
        if (object.eResource() == null || referenceValue == null) {
            return null;
        }
        IResource source = ResourceNameChangeAdapter.getWorkspaceResource(object.eResource().getURI());
        if (source == null) {
            return null;
        }
        IFile retVal = source.getProject().getFile((String)referenceValue);
        if (!retVal.exists()) {
            try {
                IProject[] projects = source.getProject().getReferencedProjects();
                int index = 0;
                int count = projects.length;
                while (index < count && !retVal.exists()) {
                    retVal = projects[index].getFile((String)referenceValue);
                    ++index;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (!retVal.exists()) {
                retVal = null;
            }
        }
        return retVal;
    }

    public void updateReference(EObject object, IResourceDelta delta) {
        IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedToPath());
        if (newFile == null) {
            return;
        }
        if (this.mFeature.isMany()) {
            List list = (List)object.eGet(this.mFeature);
            int index = list.indexOf(delta.getResource().getProjectRelativePath().toString());
            if (index < 0) {
                return;
            }
            list.set(index, newFile.getProjectRelativePath().toString());
        } else {
            object.eSet(this.mFeature, (Object)newFile.getProjectRelativePath().toString());
        }
    }
}

