/*******************************************************************************
 * Copyright (c) 2003-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.ui.dialogs;

import org.eclipse.swt.widgets.Shell;

/**
 * Represents a container for a dialog page.  Use the concrete Dialog class for
 * displaying IDialogPage's.  (This interface is intended for use by
 * IDialogPage's, giving them access to functionality on their container.)
 * 
 * @author rcernich
 */
public interface IDialogPageContainer {

	/**
	 * @return the shell owning this dialog
	 */
	public Shell getShell();

	/**
	 * Force the container to update the state of the buttons on the dialog.
	 */
	public void updateButtons();

	/**
	 * Force the container to update the message displayed in the title area of
	 * the dialog.
	 */
	public void updateMessage();

	/**
	 * Force the container to update the title bar text of the dialog.
	 */
	public void updateTitleBar();
	
	/**
	 * Force the dialog to close as if the user had pressed the OK button.
	 */
	public void closeOK();
	
	/**
	 * Force the dialog to close as if the user had pressed the cancel button.
	 */
	public void closeCancel();

}
