/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.models.deployfile.util;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployFilePackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployServer;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.stp.soas.deploy.models.deployfile.provider.DeployFileItemProviderAdapterFactory;

/**
 * @author rcernich
 * 
 * Created on Feb 23, 2004
 */
public class Utilities {

	public static final String CMD_LABEL_ADD_TARGET = "Add Target";
	public static final String CMD_DESC_ADD_TARGET = "Adds a new target to the package";

	public static final String CMD_LABEL_SET_TARGET = "Set Target";
	public static final String CMD_DESC_SET_TARGET = "Changes the target server";

	private static List sItemAdapterFactories = null;

	private static ComposedAdapterFactory sItemAdapterFactory = null;

	public static List getItemAdapterFactoriesList() {
		if (sItemAdapterFactories == null) {
			sItemAdapterFactories = new Vector(2);
			sItemAdapterFactories.add(new ResourceItemProviderAdapterFactory());
			sItemAdapterFactories
					.add(new DeployFileItemProviderAdapterFactory());
		}
		return sItemAdapterFactories;
	}

	public static ComposedAdapterFactory getItemAdapterFactory() {
		if (sItemAdapterFactory == null) {
			sItemAdapterFactory = new ComposedAdapterFactory(
					getItemAdapterFactoriesList());
		}
		return sItemAdapterFactory;
	}

	public static void fixServerReferences(Root root) {
		EList servers = root.getServer();
		for (Iterator svrIt = servers.iterator(); svrIt.hasNext();) {
			DeployServer server = (DeployServer) svrIt.next();
			EList configs = server.getTargetingConfiguration();
			for (Iterator cfgIt = configs.iterator(); cfgIt.hasNext();) {
				DeployConfiguration config = (DeployConfiguration) cfgIt.next();
				if (config.getSourcePackage() == null || !root.equals(config.getSourcePackage().getRoot())) {
					cfgIt.remove();
				}
			}
			if (server.getTargetingConfiguration().size() == 0) {
				svrIt.remove();
			}
		}
	}

	public static Command createAddTargetCommand(EditingDomain domain,
			DeployPackage pkg, String target) {
		List commandList = new Vector(3);
		DeployServer server = DeployFilePackage.eINSTANCE
				.getDeployFileFactory().createDeployServer(target);
		DeployConfiguration config = DeployFilePackage.eINSTANCE
				.getDeployFileFactory().createDeployConfiguration();
		Command addServer = AddCommand.create(domain, pkg.getRoot(),
				DeployFilePackage.eINSTANCE.getRoot_Server(), server);
		Command addConfig = AddCommand.create(domain, pkg,
				DeployFilePackage.eINSTANCE
						.getDeployPackage_TargetConfiguration(), config);
		Command setTarget = SetCommand.create(domain, config,
				DeployFilePackage.eINSTANCE
						.getDeployConfiguration_TargetServer(), server);

		commandList.add(addServer);
		commandList.add(addConfig);
		commandList.add(setTarget);

		return new CompoundCommand(CMD_LABEL_ADD_TARGET, CMD_DESC_ADD_TARGET,
				commandList);
	}

	public static Command createAddDeployConfigurationCommand(
			EditingDomain domain, DeployPackage pkg, DeployServer target) {
		List commandList = new Vector(3);
		DeployConfiguration config = DeployFilePackage.eINSTANCE
				.getDeployFileFactory().createDeployConfiguration();
		commandList.add(AddCommand.create(domain, pkg,
				DeployFilePackage.eINSTANCE
						.getDeployPackage_TargetConfiguration(), config));
		commandList.add(SetCommand.create(domain, config,
				DeployFilePackage.eINSTANCE
						.getDeployConfiguration_TargetServer(), target));
		if (target.getRoot() == null && pkg.getRoot() != null) {
			commandList.add(AddCommand.create(domain, pkg.getRoot(),
					DeployFilePackage.eINSTANCE.getRoot_Server(), target));
		}

		return new CompoundCommand(CMD_LABEL_ADD_TARGET, CMD_DESC_ADD_TARGET,
				commandList);
	}

	public static Command createSetNewTargetCommand(EditingDomain domain,
			DeployConfiguration config, String target) {
		List commandList = new Vector(2);
		DeployServer server = DeployFilePackage.eINSTANCE
				.getDeployFileFactory().createDeployServer(target);
		Command addServer = AddCommand.create(domain, config.getSourcePackage()
				.getRoot(), DeployFilePackage.eINSTANCE.getRoot_Server(),
				server);
		Command setTarget = SetCommand.create(domain, config,
				DeployFilePackage.eINSTANCE
						.getDeployConfiguration_TargetServer(), server);

		commandList.add(addServer);
		commandList.add(setTarget);

		return new CompoundCommand(CMD_LABEL_ADD_TARGET, CMD_DESC_ADD_TARGET,
				commandList);
	}

}