/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;


/**
 * @author rcernich
 * 
 * Created on Apr 8, 2004
 */
public class ServerType implements IServerType {

	private String mServerDef;
	private IVersion mVersion;

	public ServerType(String serverDef, IVersion version) {
		super();
		if (DeploymentExtensionManager.getInstance().getServerDefinition(
				serverDef) == null) {
			throw new IllegalArgumentException(
					DeployCorePlugin
							.getDefault()
							.getResourceString(
									"ServerType.exception.serverDefinitionDoesNotExist", //$NON-NLS-1$
									new Object[] { serverDef}));
		}
		mServerDef = serverDef;
		mVersion = version;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.IServerType#getServerDefinition()
	 */
	public IServerDefinition getServerDefinition() {
		return DeploymentExtensionManager.getInstance().getServerDefinition(
				mServerDef);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.IServerType#getVersion()
	 */
	public IVersion getVersion() {
		return mVersion;
	}

	public String toString() {
		return DeployCorePlugin.getDefault().getResourceString(
				"ServerType.toString", new Object[] { mServerDef, mVersion}); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		boolean retVal;
		if (this == obj) {
			retVal = true;
		}
		else if (obj instanceof ServerType) {
			ServerType st = (ServerType) obj;
			retVal = mServerDef.equals(st.mServerDef)
					&& mVersion.equals(st.mVersion);
		}
		else {
			retVal = false;
		}
		return retVal;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		// Could do better, but this should work.
		return mServerDef.hashCode();
	}
}