package org.eclipse.stp.soas.internal.deploy.ui.views;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;

/**
 * @author rcernich, brianf
 */
public class ServerLabelProvider extends LabelProvider implements
		ICommonLabelProvider {

	public ServerLabelProvider() {
		super();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.ILabelProvider#getImage(java.lang.Object)
	 */
	public Image getImage(Object element) {
		Image image = null;
		if (element instanceof IServerType) {
			image = PlatformUI.getWorkbench().getSharedImages().getImage(
					ISharedImages.IMG_OBJ_FOLDER);
		}
		else if (element instanceof IServer) {
			return DeployCorePlugin.getDefault().getImage("server.gif");
		}
		else {
			image = null;
		}
		return image;
	}


	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.ILabelProvider#getText(java.lang.Object)
	 */
	public String getText(Object element) {
		String text = null;
		if (element instanceof IServerType) {
			text = ((IServerType) element).getName();
		}
		else if (element instanceof IServer) {			
			text = ((IServer)element).getName();
		}
		else {
			text = super.getText(element);
		}
		return text;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
	 */
	public void dispose() {
		super.dispose();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.navigator.ICommonLabelProvider#init(org.eclipse.ui.navigator.IExtensionStateModel,
	 *      org.eclipse.jface.viewers.ITreeContentProvider)
	 */
	public void init(IExtensionStateModel aStateModel,
			ITreeContentProvider aContentProvider) {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.navigator.IMementoAware#restoreState(org.eclipse.ui.IMemento)
	 */
	public void restoreState(IMemento aMemento) {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.navigator.IMementoAware#saveState(org.eclipse.ui.IMemento)
	 */
	public void saveState(IMemento aMemento) {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.navigator.IDescriptionProvider#getDescription(java.lang.Object)
	 */
	public String getDescription(Object element) {
		String desc;
		/*if (element instanceof ICategory) {
			desc = ((ICategory) element).getName();
		}
		else if (element instanceof IConnectionProfile) {
			IConnectionProfile profile = (IConnectionProfile) element;
			Properties props = profile.getBaseProperties();
			String serverName = props
					.getProperty(ConnectionProfileConstants.PROP_SERVER_NAME);
			Version serverVersion = Version
					.valueOf(props
							.getProperty(ConnectionProfileConstants.PROP_SERVER_VERSION));
			if ((serverName != null && serverName.length() > 0)
					|| serverVersion != Version.NULL_VERSION) {
				desc = MessageFormat.format(ConnectivityUIPlugin.getDefault()
						.getResourceString(
								"CommonLabelProviderBase.label.version"),
						new String[] { profile.getName(), serverName,
								serverVersion.toString()});

			}
			else {
				desc = profile.getName();
			}
		}
		else {
			desc = null;
		}*/
		return "";
	}

	public void init(ICommonContentExtensionSite aConfig) {
	}
}