/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;

import java.io.File;

import org.eclipse.wst.server.core.IServer;


/**
 * This object is passed to packagers to give them context information that
 * they may need or use when creating packages.
 * 
 * @author rcernich
 *
 * Created on Mar 23, 2004
 */
public interface IPackageCreationContext {
	
	public static int OVERWRITE = 1;
	public static int USE_EXISTING = 2;
	public static int CANCEL = 3;
	
	public IServer getTarget();
	
	public File getOutputFolder();
	
	public File getTempFolder();
	
	public int promptForOverwrite(String fileName);
	
}
