/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IActionFilter;


/**
 * @author rcernich
 *
 * Created on Apr 8, 2004
 */
public abstract class PackageBase implements IPackage, IActionFilter {

	private IFile mFile;
	private IPackageExtension mExtension;

	public PackageBase() {
		super();
	}

	public void init(IPackageExtension extension, IFile pkg) {
		mFile = pkg;
		mExtension = extension;
	}

	public IFile getFile() {
		return mFile;
	}

	public String getName() {
		return getFile().getName();
	}

	public IPackageExtension getExtension() {
		return mExtension;
	}
	
    public boolean testAttribute(Object target, String name, String value) {
        if (target instanceof PackageBase) {
            try {
                IFile file = ((PackageBase) target).getFile();
                IProject proj = file.getProject();
                if ("projectNature".equals(name)) {
                    if (proj.getDescription().hasNature(value)) {
                        return true;
                    }
                }
            } catch (CoreException e) {
                return false;
            }
        }
        return false;
    }
}
