/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.stp.soas.deploy.core.DefaultSupportValidator;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.IPackageExtension;
import org.eclipse.stp.soas.deploy.core.ISupportValidator;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;


/**
 * @author rcernich
 * 
 * Created on Mar 24, 2004
 */
public abstract class PackageExtension implements IPackageExtension {

	public static final String ATTR_ID = "id"; //$NON-NLS-1$
	public static final String ATTR_FILE_EXTENSION = "fileExtension"; //$NON-NLS-1$
	public static final String ATTR_SUPPORT_VALIDATOR = "supportValidator"; //$NON-NLS-1$

	private String mID;
	private String mFileExt;
	private ISupportValidator mVerifier;
	private IConfigurationElement mElement;

	public PackageExtension(IConfigurationElement element)
			throws PackageExtensionException {
		super();
		init(element);
	}

	public String getID() {
		return mID;
	}

	public String getFileExtension() {
		return mFileExt;
	}

	public boolean supportsFile(IFile file) {
		if (mVerifier == null) {
			try {
				mVerifier = (ISupportValidator) mElement
						.createExecutableExtension(ATTR_SUPPORT_VALIDATOR);
			}
			catch (CoreException e) {
				mVerifier = new DefaultSupportValidator(mFileExt);
				if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
					System.out
							.println(DeployCorePlugin
									.getDefault()
									.getResourceString(
											"PackageExtension.trace.warning.usingDefaultSupportValidator", //$NON-NLS-1$
											new Object[] { mID}));
					System.out.flush();
				}
			}
		}
		return mVerifier.supportsFile(file);
	}

	protected IConfigurationElement getConfigurationElement() {
		return mElement;
	}

	private void init(IConfigurationElement element)
			throws PackageExtensionException {
		if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
			System.out
					.println(DeployCorePlugin
							.getDefault()
							.getResourceString(
									"PackageExtension.trace.processingPackageExtension", //$NON-NLS-1$
									new Object[] { element.getName(),
											element.getAttribute(ATTR_ID)}));
			System.out.flush();
		}

		mElement = element;

		processAttributes();
	}

	private void processAttributes() throws PackageExtensionException {
		mID = mElement.getAttribute(ATTR_ID);
		mFileExt = mElement.getAttribute(ATTR_FILE_EXTENSION);

		if (mID == null) {
			throw new PackageExtensionException(DeployCorePlugin
					.getDefault().getResourceString(
							"PackageExtension.exception.idNotSpecified")); //$NON-NLS-1$
		}
		else if (mFileExt == null) {
			throw new PackageExtensionException(
					DeployCorePlugin
							.getDefault()
							.getResourceString(
									"PackageExtension.exception.fileExtensionNotSpecified")); //$NON-NLS-1$
		}
	}

}