/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.util.Assert;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.IPackage;
import org.eclipse.stp.soas.deploy.core.IPhysicalPackage;
import org.eclipse.stp.soas.deploy.core.IPhysicalPackageExtension;
import org.eclipse.stp.soas.deploy.core.IServerType;
import org.eclipse.stp.soas.deploy.core.ISupportedServerType;
import org.eclipse.stp.soas.deploy.core.IVersion;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;


/**
 * @author rcernich
 * 
 * Created on Mar 18, 2004
 */
public class PhysicalPackageExtension extends PackageExtension implements
		IPhysicalPackageExtension {

	public static final String ATTR_CLASS = "class"; //$NON-NLS-1$

	private ISupportedServerType mSupportedServer;

	public PhysicalPackageExtension(IConfigurationElement element)
			throws PackageExtensionException {
		super(element);
		init();
	}

	public IPackage adaptFile(IFile file) {
		IPhysicalPackage ipp;
		try {
			ipp = (IPhysicalPackage) getConfigurationElement()
					.createExecutableExtension(ATTR_CLASS);
			ipp.init(this, file);
		}
		catch (CoreException e) {
			if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
				System.err
						.println(DeployCorePlugin
								.getDefault()
								.getResourceString(
										"PhysicalPackageExtension.trace.error.physicalPackageError", //$NON-NLS-1$
										new Object[] {
												getID(),
												getConfigurationElement()
														.getAttribute(
																ATTR_CLASS),
												file.getFullPath().toString()}));
				System.err.flush();
			}
			ipp = null;
		}
		return ipp;
	}

	public ISupportedServerType getSupportedServerType() {
		return mSupportedServer;
	}

	public boolean supportsServer(IServerType type) {
		boolean retVal;
		IVersion typeVersion = type.getVersion();
		if (!type.getServerDefinition().equals(
				mSupportedServer.getServerDefinition())
				|| typeVersion.compareTo(mSupportedServer.getMinVersion()) < 0
				|| (typeVersion.compareTo(mSupportedServer.getMaxVersion()) > 0 && !typeVersion
						.equals(mSupportedServer.getMaxVersion()))) {
			retVal = false;
		}
		else {
			retVal = true;
		}
		return retVal;
	}

	private void init() throws PackageExtensionException {
		Assert.isTrue(DeploymentExtensionManager.EXT_ELEM_PHYSICAL_PACKAGE
				.equals(getConfigurationElement().getName()));

		processSupportedServerElement();
	}

	private void processSupportedServerElement()
			throws PackageExtensionException {
		IConfigurationElement[] supportedServers = getConfigurationElement()
				.getChildren(
						DeploymentExtensionManager.EXT_ELEM_SUPPORTED_SERVER);

		if (supportedServers.length < 1) {
			if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
				System.err
						.println(DeployCorePlugin
								.getDefault()
								.getResourceString(
										"PhysicalPackageExtension.trace.error.supportedServerNotSpecified", //$NON-NLS-1$
										new Object[] { getID()}));
				System.err.flush();
			}
			throw new PackageExtensionException(
					DeployCorePlugin
							.getDefault()
							.getResourceString(
									"PhysicalPackageExtension.exception.supportedServerNotSpecified")); //$NON-NLS-1$
		}
		else if (supportedServers.length > 1) {
			if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
				System.err
						.println(DeployCorePlugin
								.getDefault()
								.getResourceString(
										"PhysicalPackageExtension.trace.error.multipleSupportedServerElements", //$NON-NLS-1$
										new Object[] { getID()}));
				System.err.flush();
			}
			throw new PackageExtensionException(
					DeployCorePlugin
							.getDefault()
							.getResourceString(
									"PhysicalPackageExtension.exception.multipleSupportedServerElements")); //$NON-NLS-1$
		}

		mSupportedServer = new SupportedServerType(supportedServers[0]);
	}

}