/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.ui.editors;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.Utilities;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.stp.soas.internal.deploy.emf.editors.EMFFormEditor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class DeployEditor extends EMFFormEditor {

	public static final String ID_INTRODUCTION = "DeployDefinitionEditor.page.introduction"; //$NON-NLS-1$
	public static final String ID_OVERVIEW = "DeployDefinitionEditor.page.overview"; //$NON-NLS-1$
	public static final String ID_CONFIGURATION = "DeployDefinitionEditor.page.configuration"; //$NON-NLS-1$
	public static final String ID_SUMMARY = "DeployDefinitionEditor.page.summary"; //$NON-NLS-1$

	private DeployFileOutlinePage mOutlinePage;

	public DeployEditor() {
		super();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.ISaveablePart#doSave(org.eclipse.core.runtime.IProgressMonitor)
	 */
	public void doSave(IProgressMonitor monitor) {
		// Remove any phantom servers.
		Utilities.fixServerReferences((Root) getModelRoot());
		super.doSave(monitor);
	}

	protected AdapterFactory createModelAdapterFactory() {
		return Utilities.getItemAdapterFactory();
	}

	public void dispose() {
		super.dispose();
	}

	protected boolean isValidContentType(IEditorInput input) {
		boolean retVal;
		String name = input.getName().toLowerCase();
		if (name.endsWith(".deploy")) { //$NON-NLS-1$
			retVal = true;
		}
		else {
			retVal = false;
		}
		return retVal;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.forms.editor.FormEditor#createToolkit(org.eclipse.swt.widgets.Display)
	 */
	protected FormToolkit createToolkit(Display display) {
		// Create a toolkit that shares colors between editors.
		return new FormToolkit(DeployCorePlugin.getDefault()
				.getFormColors(display));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.forms.editor.FormEditor#addPages()
	 */
	protected void addPages() {
		try {
			addPage(new IntroductionPage(this, ID_INTRODUCTION,
				DeployCorePlugin.getDefault().getResourceString("DeployDefinitionEditor.PGTAB.Introduction")));
			addPage(new OverviewPage(this, ID_OVERVIEW, 
				DeployCorePlugin.getDefault().getResourceString("DeployDefinitionEditor.PGTAB.Overview")));
			addPage(new ConfigurationPage(this, ID_CONFIGURATION,
				DeployCorePlugin.getDefault().getResourceString("DeployDefinitionEditor.PGTAB.Configuration")));
			//addPage(new SummaryPage(this, ID_SUMMARY,
			// SummaryPage.PAGE_TITLE));
		}
		catch (PartInitException e) {
			// XXX Auto-generated catch block
			e.printStackTrace();
		}
	}

	protected IContentOutlinePage getContentOutline() {
		if (mOutlinePage == null) {
			mOutlinePage = new DeployFileOutlinePage(this);
			mOutlinePage.setSelection(getSelection());
		}
		return mOutlinePage;
	}

	protected String getPropertyStorageQualifier() {
		return DeployCorePlugin.getDefault().getBundle().getSymbolicName();
	}

}
