/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.ui.editors;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;

/**
 * @author rcernich
 * 
 * Created on Mar 8, 2004
 */
public class SelectionProviderManagedForm extends ManagedForm {

	/**
	 * @param page
	 * @param form
	 */
	public SelectionProviderManagedForm(FormPage page, ScrolledForm form) {
		super(page.getEditor().getToolkit(), form);
		setContainer(page);
	}

	public FormPage getPage() {
		return (FormPage) getContainer();
	}

	public void dirtyStateChanged() {
		getPage().getEditor().editorDirtyStateChanged();
	}

	public void staleStateChanged() {
		if (getPage().isActive()) {
			refresh();
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.forms.IManagedForm#fireSelectionChanged(org.eclipse.ui.forms.IFormPart,
	 *      org.eclipse.jface.viewers.ISelection)
	 */
	public void fireSelectionChanged(IFormPart part, ISelection selection) {
		// Notify the pages
		super.fireSelectionChanged(part, selection);
		// Notify the editor if possible
		FormEditor editor = getPage().getEditor();
		if (editor instanceof ISelectionProvider) {
			((ISelectionProvider) editor).setSelection(selection);
		}
	}
}