/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.edit.parts;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DiagramAssistantEditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.BpmnPackage;
import org.eclipse.stp.bpmn.NamedBpmnObject;
import org.eclipse.stp.bpmn.diagram.edit.parts.ActivityName2EditPart;
import org.eclipse.stp.bpmn.diagram.edit.policies.Activity2CanonicalEditPolicy;
import org.eclipse.stp.bpmn.diagram.edit.policies.Activity2GraphicalNodeEditPolicy;
import org.eclipse.stp.bpmn.diagram.edit.policies.Activity2ItemSemanticEditPolicy;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.stp.bpmn.figures.WrapLabelWithToolTip;
import org.eclipse.stp.bpmn.figures.activities.ActivityNodeFigure;
import org.eclipse.stp.bpmn.figures.activities.ActivityPainter;
import org.eclipse.stp.bpmn.figures.connectionanchors.IConnectionAnchorFactory;
import org.eclipse.stp.bpmn.figures.connectionanchors.impl.ConnectionAnchorFactory;
import org.eclipse.stp.bpmn.layouts.ActivityLayout;
import org.eclipse.stp.bpmn.policies.BpmnDragDropEditPolicy;
import org.eclipse.stp.bpmn.policies.ConnectionHandleEditPolicyEx;
import org.eclipse.stp.bpmn.policies.ResizableActivityEditPolicy;

public class Activity2EditPart
extends ShapeNodeEditPart {
    private static final int EVENT_FIGURE_SIZE = 30;
    public static final int VISUAL_ID = 2003;
    protected IFigure contentPane;
    protected IFigure primaryShape;

    public Activity2EditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPoliciesGen() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new Activity2ItemSemanticEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new Activity2GraphicalNodeEditPolicy());
        this.installEditPolicy("Canonical", (EditPolicy)new Activity2CanonicalEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
    }

    protected void createDefaultEditPolicies() {
        this.createDefaultEditPoliciesGen();
        this.removeEditPolicy("ConnectionHandlesPolicy");
        this.installEditPolicy("ConnectionHandlesPolicy", (EditPolicy)this.createConnectionHandlerEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new BpmnDragDropEditPolicy((IGraphicalEditPart)this));
    }

    protected DiagramAssistantEditPolicy createConnectionHandlerEditPolicy() {
        return new ConnectionHandleEditPolicyEx();
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        LayoutEditPolicy lep = new LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShapeGen() {
        ActivityFigure figure = new ActivityFigure();
        this.primaryShape = figure;
        return this.primaryShape;
    }

    protected IFigure createNodeShape() {
        ActivityFigure figure = (ActivityFigure)this.createNodeShapeGen();
        Activity2EditPart.setActivityTypeAndLabel(figure, (Activity)this.getPrimaryView().getElement());
        return figure;
    }

    private static boolean setActivityTypeAndLabel(ActivityFigure activityFigure, Activity activity) {
        activityFigure.setActivityType(activity.getActivityType().getName());
        if (activity.getName() == null) {
            WrapLabel wl = activityFigure.getFigureActivityNameFigure();
            if (activity.getActivityType().getValue() == 0) {
                if (!"Task".equals(wl.getText())) {
                    wl.setText("Task");
                    return true;
                }
            } else if (!"".equals(wl.getText())) {
                wl.setText("");
                return true;
            }
        }
        return false;
    }

    public ActivityFigure getPrimaryShape() {
        return (ActivityFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof ActivityName2EditPart) {
            ((ActivityName2EditPart)childEditPart).setLabel(this.getPrimaryShape().getFigureActivityNameFigure());
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        return false;
    }

    protected IConnectionAnchorFactory getConnectionAnchorFactory() {
        return ConnectionAnchorFactory.INSTANCE;
    }

    protected NodeFigure createNodePlate() {
        int size = this.getMapMode().DPtoLP(30);
        return new ActivityNodeFigure(this.getConnectionAnchorFactory(), size, size);
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new ActivityLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape, (Object)ActivityLayout.CENTER);
        figure.add((IFigure)((ActivityFigure)shape).getFigureActivityNameFigure(), (Object)ActivityLayout.BOTTOM);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(this.getMapMode().DPtoLP(5));
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(BpmnVisualIDRegistry.getType(4002));
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        return new ResizableActivityEditPolicy();
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected void handleNotificationEvent(Notification notification) {
        if (notification.getEventType() == 1 && BpmnPackage.eINSTANCE.getActivity_ActivityType().equals(notification.getFeature())) {
            this.getPrimaryShape().setActivityType(((ActivityType)notification.getNewValue()).getName());
        }
        super.handleNotificationEvent(notification);
    }

    protected WrapLabelWithToolTip.IToolTipProvider getToolTipProvider() {
        return ActivityPainter.createToolTipProvider((NamedBpmnObject)this.resolveSemanticElement(), true);
    }

    public class ActivityFigure
    extends org.eclipse.stp.bpmn.figures.activities.ActivityFigure {
        private WrapLabel fActivityNameFigure;
        private boolean myUseLocalCoordinates = false;

        public ActivityFigure() {
            this.setActivityType(ActivityType.TASK_LITERAL.getName());
            this.setForegroundColor(ColorConstants.black);
            int size = Activity2EditPart.this.getMapMode().DPtoLP(30);
            this.setPreferredSize(size, size);
            this.setSize(size, size);
            this.createContents();
        }

        private void createContentsGen() {
            WrapLabel fig_0 = new WrapLabel();
            fig_0.setTextWrap(true);
            this.setFigureActivityNameFigure(fig_0);
            Object layData0 = null;
            this.add((IFigure)fig_0, layData0);
        }

        private void createContents() {
            WrapLabelWithToolTip fig_0 = new WrapLabelWithToolTip(Activity2EditPart.this.getToolTipProvider());
            fig_0.setTextWrap(true);
            this.setFigureActivityNameFigure(fig_0);
        }

        public WrapLabel getFigureActivityNameFigure() {
            return this.fActivityNameFigure;
        }

        private void setFigureActivityNameFigure(WrapLabel fig) {
            this.fActivityNameFigure = fig;
        }

        protected boolean useLocalCoordinates() {
            return this.myUseLocalCoordinates;
        }

        protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
            this.myUseLocalCoordinates = useLocalCoordinates;
        }
    }
}

