/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.generation.impl;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.Artifact;
import org.eclipse.stp.bpmn.ArtifactsContainer;
import org.eclipse.stp.bpmn.Association;
import org.eclipse.stp.bpmn.BpmnDiagram;
import org.eclipse.stp.bpmn.BpmnFactory;
import org.eclipse.stp.bpmn.DataObject;
import org.eclipse.stp.bpmn.Graph;
import org.eclipse.stp.bpmn.Group;
import org.eclipse.stp.bpmn.Identifiable;
import org.eclipse.stp.bpmn.IdentifiableNode;
import org.eclipse.stp.bpmn.Lane;
import org.eclipse.stp.bpmn.MessagingEdge;
import org.eclipse.stp.bpmn.Pool;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.SubProcess;
import org.eclipse.stp.bpmn.TextAnnotation;
import org.eclipse.stp.bpmn.Vertex;
import org.eclipse.stp.bpmn.diagram.edit.parts.BpmnDiagramEditPart;
import org.eclipse.stp.bpmn.diagram.generation.IProcessGenerator;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramFileCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPMNProcessGenerator
implements IProcessGenerator {
    private BpmnDiagram _semanticModel;
    private Diagram _graphicalModel;
    protected TransactionalEditingDomain _editingDomain;

    public BPMNProcessGenerator() {
        this((IPath)new Path("/virtual/modeler.bpmn_diagram"), true);
    }

    public BPMNProcessGenerator(IPath path) {
        this(path, false);
    }

    public BPMNProcessGenerator(final IPath path, final boolean virtual) {
        this._editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        final ResourceSet resourceSet = this._editingDomain.getResourceSet();
        InternalRecordingCommand command = new InternalRecordingCommand(){

            protected void doExecute() {
                IFile diagramFile = null;
                if (!virtual) {
                    diagramFile = BpmnDiagramFileCreator.getInstance().createNewFile(path.removeLastSegments(1), path.lastSegment(), null, null, new IRunnableContext(){

                        public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
                            runnable.run((IProgressMonitor)new NullProgressMonitor());
                        }
                    });
                }
                Resource graphicalResource = resourceSet.createResource(URI.createPlatformResourceURI((String)(virtual ? path.toString() : diagramFile.getFullPath().toString())));
                IPath modelFileRelativePath = path.removeFileExtension().addFileExtension("bpmn");
                IFile modelFile = null;
                if (!virtual) {
                    modelFile = diagramFile.getParent().getFile((IPath)new Path(modelFileRelativePath.lastSegment()));
                }
                Resource semanticResource = resourceSet.createResource(URI.createPlatformResourceURI((String)(virtual ? modelFileRelativePath.toString() : modelFile.getFullPath().toString())));
                BPMNProcessGenerator.this._semanticModel = BpmnFactory.eINSTANCE.createBpmnDiagram();
                semanticResource.getContents().add((Object)BPMNProcessGenerator.this._semanticModel);
                BPMNProcessGenerator.this._graphicalModel = ViewService.getInstance().createDiagram((IAdaptable)new EObjectAdapter((EObject)BPMNProcessGenerator.this._semanticModel), BpmnDiagramEditPart.MODEL_ID, BpmnDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                graphicalResource.getContents().add((Object)BPMNProcessGenerator.this._graphicalModel);
            }
        };
        this._editingDomain.getCommandStack().execute((Command)command);
    }

    public BPMNProcessGenerator(Diagram diagram) {
        this._editingDomain = (TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)diagram);
        this._graphicalModel = diagram;
        this._semanticModel = (BpmnDiagram)diagram.getElement();
    }

    @Override
    public void addDocumentation(final Identifiable identifiable, final String documentation) {
        InternalRecordingCommand command = new InternalRecordingCommand(){

            protected void doExecute() {
                Identifiable element = identifiable;
                if (element instanceof Activity) {
                    ((Activity)element).setDocumentation(documentation);
                } else if (element instanceof MessagingEdge) {
                    ((MessagingEdge)element).setDocumentation(documentation);
                } else if (element instanceof SequenceEdge) {
                    ((SequenceEdge)element).setDocumentation(documentation);
                } else if (element instanceof Lane) {
                    ((Lane)element).setDocumentation(documentation);
                } else if (element instanceof Pool) {
                    ((Pool)element).setDocumentation(documentation);
                } else if (element instanceof BpmnDiagram) {
                    ((BpmnDiagram)element).setDocumentation(documentation);
                } else {
                    throw new IllegalArgumentException("Don't know how to add documentation to this element " + element);
                }
            }
        };
        this._editingDomain.getCommandStack().execute((Command)command);
    }

    @Override
    public Lane addLane(final Pool pool, final String name) {
        InternalRecordingCommand command = new InternalRecordingCommand(){

            protected void doExecute() {
                Lane l = BpmnFactory.eINSTANCE.createLane();
                l.setPool(pool);
                l.setName(name);
                this.setReturnedObject((EObject)l);
            }
        };
        this._editingDomain.getCommandStack().execute((Command)command);
        return (Lane)command.getReturnedObject();
    }

    @Override
    public Pool addPool(final String name) {
        InternalRecordingCommand command = new InternalRecordingCommand(){

            protected void doExecute() {
                Pool p = BpmnFactory.eINSTANCE.createPool();
                p.setBpmnDiagram(BPMNProcessGenerator.this._semanticModel);
                p.setName(name);
                this.setReturnedObject((EObject)p);
            }
        };
        this._editingDomain.getCommandStack().execute((Command)command);
        return (Pool)command.getReturnedObject();
    }

    @Override
    public SequenceEdge addSequenceEdge(final Vertex source, final Vertex target, final String name) {
        InternalRecordingCommand command = new InternalRecordingCommand(){

            protected void doExecute() {
                SequenceEdge edge = BpmnFactory.eINSTANCE.createSequenceEdge();
                edge.setGraph(target.getGraph());
                edge.setSource(source);
                edge.setTarget(target);
                edge.setName(name);
                this.setReturnedObject((EObject)edge);
            }
        };
        this._editingDomain.getCommandStack().execute((Command)command);
        return (SequenceEdge)command.getReturnedObject();
    }

    public Association addAssociation(final Artifact source, final IdentifiableNode target) {
        InternalRecordingCommand command = new InternalRecordingCommand(){

            protected void doExecute() {
                Association edge = BpmnFactory.eINSTANCE.createAssociation();
                edge.setSource(source);
                edge.setTarget(target);
                this.setReturnedObject((EObject)edge);
            }
        };
        this._editingDomain.getCommandStack().execute((Command)command);
        return (Association)command.getReturnedObject();
    }

    @Override
    public Activity addActivity(final Graph poolOrSubProcess, final String name, final int activityType) {
        assert (poolOrSubProcess != null);
        InternalRecordingCommand command = new InternalRecordingCommand(){

            protected void doExecute() {
                if (activityType != 1) {
                    Activity activity = BpmnFactory.eINSTANCE.createActivity();
                    activity.setGraph(poolOrSubProcess);
                    activity.setActivityType(ActivityType.get((int)activityType));
                    activity.setName(name);
                    this.setReturnedObject((EObject)activity);
                } else {
                    SubProcess sp = BpmnFactory.eINSTANCE.createSubProcess();
                    sp.setActivityType(ActivityType.get((int)activityType));
                    sp.setGraph(poolOrSubProcess);
                    sp.setName(name);
                    this.setReturnedObject((EObject)sp);
                }
            }
        };
        this._editingDomain.getCommandStack().execute((Command)command);
        return (Activity)command.getReturnedObject();
    }

    public TextAnnotation addTextAnnotation(final ArtifactsContainer artifactContainer, final String name) {
        InternalRecordingCommand command = new InternalRecordingCommand(){

            protected void doExecute() {
                TextAnnotation text = BpmnFactory.eINSTANCE.createTextAnnotation();
                text.setArtifactsContainer(artifactContainer);
                text.setName(name);
                this.setReturnedObject((EObject)text);
            }
        };
        this._editingDomain.getCommandStack().execute((Command)command);
        return (TextAnnotation)command.getReturnedObject();
    }

    public DataObject addDataObject(final ArtifactsContainer artifactContainer, final String name) {
        InternalRecordingCommand command = new InternalRecordingCommand(){

            protected void doExecute() {
                DataObject dataObject = BpmnFactory.eINSTANCE.createDataObject();
                dataObject.setArtifactsContainer(artifactContainer);
                dataObject.setName(name);
                this.setReturnedObject((EObject)dataObject);
            }
        };
        this._editingDomain.getCommandStack().execute((Command)command);
        return (DataObject)command.getReturnedObject();
    }

    public Group addGroup(final ArtifactsContainer artifactContainer, final String name) {
        InternalRecordingCommand command = new InternalRecordingCommand(){

            protected void doExecute() {
                Group group = BpmnFactory.eINSTANCE.createGroup();
                group.setArtifactsContainer(artifactContainer);
                group.setName(name);
                this.setReturnedObject((EObject)group);
            }
        };
        this._editingDomain.getCommandStack().execute((Command)command);
        return (Group)command.getReturnedObject();
    }

    public Activity addBorderEvent(final SubProcess parent, final String name, final int activityType) {
        InternalRecordingCommand command = new InternalRecordingCommand(){

            protected void doExecute() {
                Activity activity = BpmnFactory.eINSTANCE.createActivity();
                activity.setEventHandlerFor(parent);
                activity.setActivityType(ActivityType.get((int)activityType));
                activity.setName(name);
                this.setReturnedObject((EObject)activity);
            }
        };
        this._editingDomain.getCommandStack().execute((Command)command);
        return (Activity)command.getReturnedObject();
    }

    @Override
    public MessagingEdge messageConnect(final Activity source, final Activity target, final String name) {
        InternalRecordingCommand command = new InternalRecordingCommand(){

            protected void doExecute() {
                MessagingEdge edge = BpmnFactory.eINSTANCE.createMessagingEdge();
                edge.setBpmnDiagram(BPMNProcessGenerator.this._semanticModel);
                edge.setSource(source);
                edge.setTarget(target);
                edge.setName(name);
                this.setReturnedObject((EObject)edge);
            }
        };
        this._editingDomain.getCommandStack().execute((Command)command);
        return (MessagingEdge)command.getReturnedObject();
    }

    @Override
    public EAnnotation addAnnotation(final EModelElement modelElement, final String source, final Map<String, String> details) {
        InternalRecordingCommand command = new InternalRecordingCommand(){

            protected void doExecute() {
                EAnnotation ann = modelElement.getEAnnotation(source);
                if (ann == null) {
                    ann = EcoreFactory.eINSTANCE.createEAnnotation();
                    ann.setSource(source);
                }
                ann.getDetails().putAll(details);
                ann.setEModelElement(modelElement);
                this.setReturnedObject((EObject)ann);
            }
        };
        this._editingDomain.getCommandStack().execute((Command)command);
        return (EAnnotation)command.getReturnedObject();
    }

    public void save() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        try {
            this._semanticModel.eResource().save(options);
            this._graphicalModel.eResource().save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            BpmnDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.stp.bpmn.diagram", 4, "Cannot save resource", (Throwable)e));
        }
    }

    protected final Diagram getGraphicalModel() {
        return this._graphicalModel;
    }

    protected final BpmnDiagram getSemanticModel() {
        return this._semanticModel;
    }

    protected abstract class InternalRecordingCommand
    extends RecordingCommand {
        private EObject _returnedObject;

        public InternalRecordingCommand() {
            super(BPMNProcessGenerator.this._editingDomain);
        }

        public EObject getReturnedObject() {
            return this._returnedObject;
        }

        protected void setReturnedObject(EObject object) {
            this._returnedObject = object;
        }
    }
}

