/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.providers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DecorationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.CreateDecoratorsOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.ImageFigureEx;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stp.bpmn.diagram.edit.parts.BpmnDiagramEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramPreferenceInitializer;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.stp.bpmn.diagram.providers.BpmnDecorationFilterService;
import org.eclipse.stp.bpmn.dnd.IEAnnotationDecorator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class BpmnEAnnotationDecoratorProvider
extends AbstractProvider
implements IDecoratorProvider {
    private static final int DECORATION_SIZE = 17;
    private static final String KEY = "eannotationdecoration";

    public void createDecorators(IDecoratorTarget decoratorTarget) {
        EditPart editPart = (EditPart)decoratorTarget.getAdapter(EditPart.class);
        if (editPart instanceof GraphicalEditPart || editPart instanceof AbstractConnectionEditPart) {
            View view;
            Object model = editPart.getModel();
            if (model instanceof View && !((view = (View)model) instanceof Edge) && !view.isSetElement()) {
                return;
            }
            EditDomain ed = editPart.getViewer().getEditDomain();
            if (!(ed instanceof DiagramEditDomain)) {
                return;
            }
            decoratorTarget.installDecorator((Object)KEY, (IDecorator)new EAnnotationDecorator(decoratorTarget));
        }
    }

    public boolean provides(IOperation operation) {
        if (!(operation instanceof CreateDecoratorsOperation)) {
            return false;
        }
        IDecoratorTarget decoratorTarget = ((CreateDecoratorsOperation)operation).getDecoratorTarget();
        View view = (View)decoratorTarget.getAdapter(View.class);
        return view != null && BpmnDiagramEditPart.MODEL_ID.equals(BpmnVisualIDRegistry.getModelID(view));
    }

    static class DecoratorListener
    extends EContentAdapter {
        private EAnnotationDecorator decorator;

        public DecoratorListener(EAnnotationDecorator dec) {
            this.decorator = dec;
        }

        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof EAnnotation) {
                super.notifyChanged(notification);
            }
            if (notification.getNotifier() instanceof EModelElement) {
                if (notification.getFeatureID(EModelElement.class) == 0) {
                    super.notifyChanged(notification);
                    this.refresh();
                } else if (notification.getEventType() == -1) {
                    this.refresh();
                }
            } else if (notification.getNotifier() instanceof EAnnotation) {
                this.refresh();
            } else if (notification.getNotifier() instanceof BasicEMap.Entry) {
                this.refresh();
            }
        }

        private void refresh() {
            if (this.decorator.getView().eResource() == null) {
                return;
            }
            final TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.decorator.getView().getDiagram());
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        if (domain != null) {
                            domain.runExclusive(new Runnable(){

                                public void run() {
                                    DecoratorListener.this.decorator.refresh();
                                }
                            });
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
            });
        }
    }

    public class EAnnotationDecorator
    implements IDecorator {
        private HashMap<ImageDescriptor, Image> images = new HashMap();
        private DecoratorListener decoratorListener;
        private DecorationEditPolicy.DecoratorTarget decoratorTarget;
        private IFigure currentDecoration;
        private Map<IDecoration, IDecoratorTarget.Direction> decorations = new HashMap<IDecoration, IDecoratorTarget.Direction>();

        public EAnnotationDecorator(IDecoratorTarget decoratorTarget) {
            this.decoratorTarget = (DecorationEditPolicy.DecoratorTarget)decoratorTarget;
        }

        public void activate() {
            View view = (View)this.decoratorTarget.getAdapter(View.class);
            if (view == null || view.eResource() == null) {
                return;
            }
            if (view.getElement() instanceof EModelElement) {
                this.decoratorListener = new DecoratorListener(this);
                ((EModelElement)view.getElement()).eAdapters().add((Object)this.decoratorListener);
                for (Object ea : ((EModelElement)view.getElement()).getEAnnotations()) {
                    ((EAnnotation)ea).eAdapters().add((Object)this.decoratorListener);
                }
            }
        }

        public void refresh() {
            this.removeDecorations();
            if (BpmnDiagramEditorPlugin.getInstance().getPreferenceStore().getBoolean(BpmnDiagramPreferenceInitializer.FILTER_DECORATIONS)) {
                return;
            }
            View view = (View)this.decoratorTarget.getAdapter(View.class);
            EditPart editPart = (EditPart)this.decoratorTarget.getAdapter(EditPart.class);
            if (view == null || view.eResource() == null) {
                return;
            }
            if (view.getElement() == null || view.getElement().eResource() == null) {
                return;
            }
            if (editPart.getParent() == null) {
                return;
            }
            if (view.getElement() instanceof EModelElement) {
                EModelElement elt = (EModelElement)view.getElement();
                this.decorations = new HashMap<IDecoration, IDecoratorTarget.Direction>();
                for (Object objAnn : elt.getEAnnotations()) {
                    ImageFigureEx figure;
                    IFigure parentFigure;
                    ImageDescriptor descriptor;
                    IEAnnotationDecorator decorator;
                    EAnnotation ann = (EAnnotation)objAnn;
                    if (BpmnDecorationFilterService.getInstance().isSourceFiltered(ann.getSource()) || (decorator = BpmnDiagramEditorPlugin.getInstance().getEAnnotationDecorator(ann.getSource())) == null || !(editPart instanceof GraphicalEditPart) || (descriptor = decorator.getImageDescriptor(editPart, elt, ann)) == null) continue;
                    Image image = this.images.get(descriptor);
                    if (image == null) {
                        image = descriptor.createImage();
                        this.images.put(descriptor, image);
                    }
                    if ((parentFigure = ((GraphicalEditPart)this.decoratorTarget.getAdapter(GraphicalEditPart.class)).getFigure()) == null) {
                        parentFigure = ((GraphicalEditPart)((GraphicalEditPart)this.decoratorTarget.getAdapter(GraphicalEditPart.class)).getRoot()).getFigure();
                    }
                    if (view instanceof Edge) {
                        figure = new ImageFigureEx();
                        figure.setImage(image);
                        parentFigure.add((IFigure)figure);
                        figure.setSize(image.getBounds().width, image.getBounds().height);
                        this.currentDecoration = (IFigure)this.decoratorTarget.addConnectionDecoration((IFigure)figure, 55 + 7 * elt.getEAnnotations().indexOf((Object)ann), false);
                        this.decorations.put((IDecoration)this.currentDecoration, IDecoratorTarget.Direction.CENTER);
                    } else {
                        figure = new ImageFigureEx(image);
                        parentFigure.add((IFigure)figure);
                        figure.setSize(image.getBounds().width, image.getBounds().height);
                        IDecoratorTarget.Direction direction = decorator.getDirection(editPart, elt, ann);
                        IDecoration deco = this.decoratorTarget.addDecoration((IFigure)figure, (Locator)new StickyToBorderLocator(parentFigure, this.getPositionConstant(direction), this.getOffset(direction)), false);
                        this.currentDecoration = (IFigure)(deco instanceof IFigure ? deco : null);
                        this.decorations.put((IDecoration)this.currentDecoration, IDecoratorTarget.Direction.NORTH_EAST);
                    }
                    if (this.currentDecoration == null) continue;
                    this.currentDecoration.setToolTip(decorator.getToolTip(editPart, elt, ann));
                }
            }
        }

        private int getOffset(IDecoratorTarget.Direction dir) {
            int i = 0;
            for (IDecoration deco : this.decorations.keySet()) {
                if (!this.decorations.get(deco).equals(dir)) continue;
                ++i;
            }
            return i * 17;
        }

        private int getPositionConstant(IDecoratorTarget.Direction direction) {
            if (direction == IDecoratorTarget.Direction.CENTER) {
                return 2;
            }
            if (direction == IDecoratorTarget.Direction.NORTH) {
                return 1;
            }
            if (direction == IDecoratorTarget.Direction.SOUTH) {
                return 4;
            }
            if (direction == IDecoratorTarget.Direction.WEST) {
                return 8;
            }
            if (direction == IDecoratorTarget.Direction.EAST) {
                return 16;
            }
            if (direction == IDecoratorTarget.Direction.NORTH_EAST) {
                return 17;
            }
            if (direction == IDecoratorTarget.Direction.NORTH_WEST) {
                return 9;
            }
            if (direction == IDecoratorTarget.Direction.SOUTH_EAST) {
                return 20;
            }
            if (direction == IDecoratorTarget.Direction.SOUTH_WEST) {
                return 12;
            }
            return 2;
        }

        private void removeDecorations() {
            for (IDecoration deco : this.decorations.keySet()) {
                if (deco == null) continue;
                this.decoratorTarget.removeDecoration(deco);
            }
            this.decorations.clear();
        }

        public void deactivate() {
            this.removeDecorations();
            for (Image image : this.images.values()) {
                image.dispose();
            }
            this.images.clear();
            View view = (View)this.decoratorTarget.getAdapter(View.class);
            if (view == null || view.eResource() == null) {
                return;
            }
            if (view.getElement() instanceof EModelElement) {
                view.getElement().eAdapters().remove((Object)this.decoratorListener);
            }
        }

        public View getView() {
            View view = (View)this.decoratorTarget.getAdapter(View.class);
            return view;
        }
    }

    private class StickyToBorderLocator
    implements Locator {
        private int offset;
        protected int direction;
        protected IFigure reference;

        public StickyToBorderLocator(IFigure reference, int direction, int offset) {
            this.reference = reference;
            this.direction = direction;
            this.offset = offset;
        }

        public void relocate(IFigure target) {
            Rectangle bounds = this.reference instanceof HandleBounds ? ((HandleBounds)this.reference).getHandleBounds().getCopy() : this.reference.getBounds().getCopy();
            this.reference.translateToAbsolute((Translatable)bounds);
            target.translateToRelative((Translatable)bounds);
            int width = target.getBounds().width;
            int halfWidth = width / 2;
            int height = target.getBounds().height;
            int halfHeight = height / 2;
            if (this.direction == 2) {
                Dimension shift = new Dimension(-halfWidth, -halfHeight);
                target.setLocation(bounds.getCenter().getTranslated(shift));
            } else if (this.offset < 0) {
                if (this.direction == 9) {
                    Dimension shift = new Dimension(2 - this.offset, 2);
                    target.setLocation(bounds.getTopLeft().getTranslated(shift));
                } else if (this.direction == 1) {
                    Dimension shift = new Dimension(-this.offset, -halfWidth);
                    target.setLocation(bounds.getTop().getTranslated(shift));
                } else if (this.direction == 17) {
                    Dimension shift = new Dimension(this.offset, 0);
                    target.setLocation(bounds.getTopRight().getTranslated(shift));
                } else if (this.direction == 12) {
                    Dimension shift = new Dimension(0, this.offset);
                    target.setLocation(bounds.getBottomLeft().getTranslated(shift));
                } else if (this.direction == 4) {
                    Dimension shift = new Dimension(-halfWidth, -(height + -this.offset));
                    target.setLocation(bounds.getBottom().getTranslated(shift));
                } else if (this.direction == 20) {
                    Dimension shift = new Dimension(-(width + -this.offset), -height);
                    target.setLocation(bounds.getBottomRight().getTranslated(shift));
                } else if (this.direction == 8) {
                    Dimension shift = new Dimension(-this.offset, -halfHeight);
                    target.setLocation(bounds.getLeft().getTranslated(shift));
                } else if (this.direction == 16) {
                    Dimension shift = new Dimension(-(width + -this.offset), -halfHeight);
                    target.setLocation(bounds.getRight().getTranslated(shift));
                }
            } else if (this.direction == 9) {
                Dimension shift = new Dimension(2 + this.offset, 2);
                target.setLocation(bounds.getTopLeft().getTranslated(shift));
            } else if (this.direction == 1) {
                Dimension shift = new Dimension(-halfWidth, -(height + this.offset));
                target.setLocation(bounds.getTop().getTranslated(shift));
            } else if (this.direction == 17) {
                Dimension shift = new Dimension(2, this.offset + 2);
                target.setLocation(bounds.getTopRight().getTranslated(shift));
            } else if (this.direction == 12) {
                Dimension shift = new Dimension(this.offset + 2, -19);
                target.setLocation(bounds.getBottomLeft().getTranslated(shift));
            } else if (this.direction == 4) {
                Dimension shift = new Dimension(-halfWidth, 0);
                target.setLocation(bounds.getBottom().getTranslated(shift));
            } else if (this.direction == 20) {
                Dimension shift = new Dimension(this.offset + 2, 2);
                target.setLocation(bounds.getBottomRight().getTranslated(shift));
            } else if (this.direction == 8) {
                Dimension shift = new Dimension(this.offset + 2, -halfHeight);
                target.setLocation(bounds.getLeft().getTranslated(shift));
            } else if (this.direction == 16) {
                Dimension shift = new Dimension(this.offset, -halfHeight);
                target.setLocation(bounds.getRight().getTranslated(shift));
            }
        }
    }
}

