/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.ui;

import org.eclipse.gef.DragTracker;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.NullElementType;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class PopupBarDescriptor {
    private String tooltip = new String();
    private Image icon = null;
    private IElementType elementType;
    private DragTracker dragTracker = null;
    private int severity = 0;
    private boolean _shouldBeDisposed = true;

    public PopupBarDescriptor(String message, int severity) {
        this(message, PopupBarDescriptor.getImage(severity));
        this.severity = severity;
    }

    public PopupBarDescriptor(String s, Image i) {
        this(s, i, null);
    }

    public PopupBarDescriptor(String s, Image i, DragTracker theTracker) {
        this(s, i, (IElementType)NullElementType.getInstance(), theTracker);
    }

    public PopupBarDescriptor(String s, Image i, IElementType elementType, DragTracker theTracker) {
        this.tooltip = s;
        this.icon = i;
        this.dragTracker = theTracker;
        this.elementType = elementType;
    }

    public final IElementType getElementtype() {
        return this.elementType;
    }

    public final Image getIcon() {
        return this.icon;
    }

    public final DragTracker getDragTracker() {
        return this.dragTracker;
    }

    public final String getToolTip() {
        return this.tooltip;
    }

    boolean shouldBeDisposed() {
        return this._shouldBeDisposed;
    }

    void setShouldBeDisposed(boolean beDisposed) {
        this._shouldBeDisposed = beDisposed;
    }

    private static Image getImage(int severity) {
        String imageName = "IMG_OBJS_ERROR_TSK";
        switch (severity) {
            case 4: {
                imageName = "IMG_OBJS_ERROR_TSK";
                break;
            }
            case 2: {
                imageName = "IMG_OBJS_WARN_TSK";
                break;
            }
            default: {
                imageName = "IMG_OBJS_INFO_TSK";
            }
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage(imageName);
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }
}

