/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.tools;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.Pool;
import org.eclipse.stp.bpmn.diagram.edit.parts.ActivityEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolEditPart;
import org.eclipse.stp.bpmn.tools.ConnectionValidator;

public class MessageConnectionValidator
implements ConnectionValidator {
    public static MessageConnectionValidator INSTANCE = new MessageConnectionValidator();

    protected MessageConnectionValidator() {
    }

    public boolean canStart(EObject element) {
        if (!(element instanceof Activity)) {
            return false;
        }
        int activityType = ((Activity)element).getActivityType().getValue();
        switch (activityType) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                return false;
            }
        }
        return true;
    }

    public boolean canStart(EditPart sourceEditPart) {
        if (sourceEditPart instanceof ActivityEditPart) {
            EObject element = ((Node)sourceEditPart.getModel()).getElement();
            return this.canStart(element);
        }
        return false;
    }

    public boolean canEnd(EObject element) {
        if (!(element instanceof Activity)) {
            return false;
        }
        int activityType = ((Activity)element).getActivityType().getValue();
        switch (activityType) {
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                return false;
            }
        }
        return true;
    }

    public boolean canEnd(EditPart targetEditPart) {
        if (targetEditPart instanceof ActivityEditPart) {
            EObject element = ((Node)targetEditPart.getModel()).getElement();
            return this.canEnd(element);
        }
        return false;
    }

    public boolean canConnect(EObject source, EObject target) {
        if (source == null) {
            return false;
        }
        if (target == null) {
            return false;
        }
        if (source.equals(target)) {
            return false;
        }
        if (!this.canEnd(target)) {
            return false;
        }
        if (!this.canStart(source)) {
            return false;
        }
        return this.getPool(source) != null && this.getPool(target) != null && !this.getPool(source).equals(this.getPool(target));
    }

    public boolean canConnect(EditPart source, EditPart target) {
        if (source == null) {
            return false;
        }
        if (target == null) {
            return false;
        }
        if (source.equals(target)) {
            return false;
        }
        if (!this.canEnd(target)) {
            return false;
        }
        if (!this.canStart(source)) {
            return false;
        }
        return this.getPool(source) != null && this.getPool(target) != null && !this.getPool(source).equals(this.getPool(target));
    }

    protected EditPart getPool(EditPart activity) {
        if (activity instanceof PoolEditPart) {
            return activity;
        }
        EditPart parent = activity.getParent();
        while (!(parent instanceof PoolEditPart) && parent != null) {
            parent = parent.getParent();
        }
        return parent;
    }

    protected Pool getPool(EObject activity) {
        if (activity instanceof Pool) {
            return (Pool)activity;
        }
        EObject parent = activity.eContainer();
        if (parent != null) {
            return this.getPool(parent);
        }
        return null;
    }
}

