/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.infrastructure.assertion;

import org.eclipse.stp.core.infrastructure.assertion.AssertionFailedException;

public final class Assert {
    private Assert() {
    }

    public static boolean isLegal(boolean expression) {
        return Assert.isLegal(expression, "");
    }

    public static boolean isLegal(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
        return expression;
    }

    public static void isNotNull(Object object) {
        Assert.isNotNull(object, "");
    }

    public static void isNotNull(Object object, String message) {
        if (object == null) {
            throw new AssertionFailedException("null argument:" + message);
        }
    }

    public static boolean isTrue(boolean expression) {
        return Assert.isTrue(expression, "");
    }

    public static boolean isTrue(boolean expression, String message) {
        if (!expression) {
            throw new AssertionFailedException("assertion failed: " + message);
        }
        return expression;
    }

    public static void isNotNullOrEmtpy(String string, String message) {
        Assert.isNotNull(string);
        if (string.length() == 0) {
            String msg = "zero length string not allowed:";
            if (message != null) {
                msg = String.valueOf(msg) + message;
            }
            throw new AssertionFailedException(msg);
        }
    }

    public static void isNotSupported(String message) {
        String msg = "This operation is not supported:";
        if (message != null) {
            msg = String.valueOf(msg) + message;
        }
        throw new AssertionFailedException(msg);
    }

    public static void isNotImplementedYet(String message) {
        String msg = "This operation is not implemented yet but will be in the future:";
        if (message != null) {
            msg = String.valueOf(msg) + message;
        }
        throw new AssertionFailedException(msg);
    }
}

