/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.tests.infrastructure.emf;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.stp.core.infrastructure.emf.DefaultScribblerDomain;
import org.eclipse.stp.core.infrastructure.emf.EclipseResourceDescriptor;
import org.eclipse.stp.core.infrastructure.emf.EditModelException;
import org.eclipse.stp.core.infrastructure.emf.IEditModel;
import org.eclipse.stp.core.infrastructure.emf.IEditModelFactory;
import org.eclipse.stp.core.infrastructure.emf.IEditModelListener;
import org.eclipse.stp.core.infrastructure.emf.IEditModelScribbler;
import org.eclipse.stp.core.infrastructure.emf.IHumanInteractionController;
import org.eclipse.stp.core.infrastructure.emf.IResourceDescriptor;
import org.eclipse.stp.core.infrastructure.emf.IScribblerDomain;
import org.eclipse.stp.core.internal.infrastructure.emf.DynamicAdapterFactory;
import org.eclipse.stp.core.internal.infrastructure.emf.EditModel;
import org.eclipse.stp.core.internal.infrastructure.emf.ScribblerAdapter;
import org.eclipse.stp.core.internal.infrastructure.emfworkbench.EMFWorkbenchContext;
import org.eclipse.stp.core.tests.infrastructure.util.TestDomain;
import org.eclipse.stp.core.tests.infrastructure.util.TestEditModelListener;
import org.eclipse.stp.core.tests.infrastructure.util.TestHumanInteractionController;
import org.eclipse.stp.core.tests.infrastructure.util.TestOperation;
import org.eclipse.stp.core.tests.infrastructure.util.TestOperationArgs;
import org.eclipse.stp.core.tests.infrastructure.util.TestProgressMonitor;
import org.eclipse.stp.core.tests.infrastructure.util.TestWorkspace;

public class IEditModelScribblerTest
extends TestCase {
    private static final String TEST_EDITMODEL_ID = "test.ejb.editmodel";

    private TestDomain createTestDomain() {
        return TestDomain.createTestDomain(TestWorkspace.getTestProject());
    }

    protected void setUp() throws Exception {
        super.setUp();
        TestWorkspace.init();
        EMFWorkbenchContext context = EMFWorkbenchContext.getInstance((IProject)TestWorkspace.getTestProject());
        ProjectResourceSet resourceSet = context.getResourceSet();
        IEditModelScribblerTest.assertTrue((String)"Ensure there are zero resources loaded.", (resourceSet.getResources().size() == 0 ? 1 : 0) != 0);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        System.gc();
        EMFWorkbenchContext context = EMFWorkbenchContext.getInstance((IProject)TestWorkspace.getTestProject());
        ProjectResourceSet resourceSet = context.getResourceSet();
        IEditModelScribblerTest.assertTrue((String)"Ensure there are zero resources loaded.", (resourceSet.getResources().size() == 0 ? 1 : 0) != 0);
        IEditModel editModel = IEditModelFactory.eINSTANCE.getEditModel(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID);
        IEditModelScribblerTest.assertTrue((String)"Ensure there are zero EditModelListeners.", (((EditModel)editModel).getListeners().size() == 0 ? 1 : 0) != 0);
    }

    public IEditModelScribblerTest(String name) {
        super(name);
    }

    public static TestSuite suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(IEditModelScribblerTest.class);
        return suite;
    }

    public void testGetResourceURI() throws Exception {
        TestDomain testDomain = this.createTestDomain();
        IEditModelScribbler scribbler = IEditModelFactory.eINSTANCE.createScribblerForRead(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID, new IScribblerDomain[]{testDomain});
        Resource resource = scribbler.getResource(testDomain.getTestURI());
        IEditModelScribblerTest.assertNotNull((String)"A resource should NOT be null", (Object)resource);
        EJBJar jar = (EJBJar)resource.getContents().get(0);
        IEditModelScribblerTest.assertNotNull((String)"A model object should have been retrived.", (Object)jar);
        IEditModelScribblerTest.assertEquals((String)"The displayname should be T.", (String)"T", (String)jar.getDisplayName());
        IEditModelScribblerTest.assertTrue((String)"The resource should NOT have a modified flag set to true.", (!resource.isModified() ? 1 : 0) != 0);
        IEditModelScribblerTest.assertTrue((String)"The scribbler should NOT be dirty.", (!scribbler.isDirty() ? 1 : 0) != 0);
        resource = scribbler.getResource(URI.createFileURI((String)""));
        IEditModelScribblerTest.assertNull((String)"A resource should NOT be returned", (Object)resource);
        scribbler.close(null);
    }

    public void testIsReadOnly() throws Exception {
        TestDomain testDomain = this.createTestDomain();
        IEditModelScribbler scribbler = IEditModelFactory.eINSTANCE.createScribblerForRead(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID, new IScribblerDomain[]{testDomain});
        IEditModelScribblerTest.assertTrue((String)"The scribbler should be marked as read-only.", (boolean)scribbler.isReadOnly());
        scribbler.close(null);
        scribbler = IEditModelFactory.eINSTANCE.createScribblerForWrite(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID, new IScribblerDomain[]{testDomain});
        IEditModelScribblerTest.assertTrue((String)"The scribbler should NOT be marked as read-only.", (!scribbler.isReadOnly() ? 1 : 0) != 0);
        scribbler.close(null);
    }

    public void testGetResourceIPath() throws Exception {
        TestDomain testDomain = this.createTestDomain();
        IEditModelScribbler scribbler = IEditModelFactory.eINSTANCE.createScribblerForRead(TestWorkspace.getTestProject(), (IScribblerDomain)testDomain);
        Resource resource = scribbler.getResource(testDomain.getTestPath());
        EJBJar jar = (EJBJar)resource.getContents().get(0);
        IEditModelScribblerTest.assertNotNull((String)"A model object should have been retrived.", (Object)jar);
        IEditModelScribblerTest.assertEquals((String)"The displayname should be T.", (String)"T", (String)jar.getDisplayName());
        IEditModelScribblerTest.assertTrue((String)"The resource should NOT have a modified flag set to true.", (!resource.isModified() ? 1 : 0) != 0);
        IEditModelScribblerTest.assertTrue((String)"The scribbler should NOT be dirty.", (!scribbler.isDirty() ? 1 : 0) != 0);
        resource = scribbler.getResource(TestWorkspace.getTestProject().getFullPath());
        IEditModelScribblerTest.assertNull((String)"A resource should NOT be returned", (Object)resource);
        scribbler.close(null);
    }

    public void testGetResourceIPathNonExtistent() throws Exception {
        IFile ejbJarFile;
        TestDomain testDomain = this.createTestDomain();
        IEditModelScribbler scribbler = IEditModelFactory.eINSTANCE.createScribblerForRead(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID, new IScribblerDomain[]{testDomain});
        Resource resource = scribbler.getResource((ejbJarFile = TestWorkspace.getTestProject().getFile("ejb-jar.xml")).getFullPath());
        IEditModelScribblerTest.assertTrue((String)"The resource should NOT have a modified flag set to true.", (!resource.isModified() ? 1 : 0) != 0);
        IEditModelScribblerTest.assertTrue((String)"The resource should NOT have been loaded.", (!resource.isLoaded() ? 1 : 0) != 0);
        IEditModelScribblerTest.assertTrue((String)"The scribbler should NOT be dirty.", (!scribbler.isDirty() ? 1 : 0) != 0);
        scribbler.close(null);
    }

    public void testGetResourceURI_ReadOnly() {
        TestDomain testDomain = this.createTestDomain();
        IEditModelScribbler scribbler = null;
        try {
            scribbler = IEditModelFactory.eINSTANCE.createScribblerForRead(TestWorkspace.getTestProject(), (IScribblerDomain)testDomain);
        }
        catch (EditModelException e1) {
            IEditModelScribblerTest.assertNull((Object)((Object)e1));
        }
        Resource resource = scribbler.getResource(testDomain.getTestURI());
        EJBJar jar = (EJBJar)resource.getContents().get(0);
        jar.setDisplayName("Test");
        boolean exceptionThrown = false;
        try {
            scribbler.save(true, null);
        }
        catch (EditModelException editModelException) {
            exceptionThrown = true;
        }
        IEditModelScribblerTest.assertTrue((String)"An exception should be thrown from the save().", (boolean)exceptionThrown);
        try {
            scribbler.close(null);
        }
        catch (EditModelException e) {
            IEditModelScribblerTest.assertNull((Object)((Object)e));
        }
    }

    public void testNotifiactionOnLoad() throws Exception {
        TestDomain testDomain = this.createTestDomain();
        EMFWorkbenchContext context = EMFWorkbenchContext.getInstance((IProject)TestWorkspace.getTestProject());
        ProjectResourceSet resourceSet = context.getResourceSet();
        Resource resource = resourceSet.getResource(testDomain.getTestURI(), false);
        if (resource != null && resource.isLoaded()) {
            resource.unload();
        }
        resourceSet.getResources().remove((Object)resource);
        IEditModel editModel = IEditModelFactory.eINSTANCE.getEditModel(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID);
        TestEditModelListener testListener = new TestEditModelListener(6);
        editModel.addListener((IEditModelListener)testListener);
        IEditModelScribbler scribbler = editModel.createScribbler(new IScribblerDomain[]{testDomain}, false);
        IEditModelScribblerTest.assertTrue((String)"Ensure there are zero resources loaded.", (resourceSet.getResources().size() == 0 ? 1 : 0) != 0);
        resource = resourceSet.getResource(testDomain.getTestURI(), true);
        IEditModelScribblerTest.assertTrue((String)"Ensure the edit model is managing the resource.", (boolean)((EditModel)editModel).isManagingResource(resource));
        EJBJar jar = (EJBJar)resource.getContents().get(0);
        IEditModelScribblerTest.assertTrue((String)"The resource should NOT have a modified flag set to true.", (!resource.isModified() ? 1 : 0) != 0);
        IEditModelScribblerTest.assertTrue((String)"The scribbler should NOT be dirty.", (!scribbler.isDirty() ? 1 : 0) != 0);
        IEditModelScribblerTest.assertNotNull((String)"A model object should have been retrived.", (Object)jar);
        IEditModelScribblerTest.assertEquals((String)"The displayname should be T.", (String)"T", (String)jar.getDisplayName());
        IEditModelScribblerTest.assertTrue((String)"A notification of the loaded resource should have been received.", (testListener.getEvents().length == 1 ? 1 : 0) != 0);
        IEditModelScribblerTest.assertTrue((String)"A notification of the loaded resource should have been received.", (testListener.getEvents()[0].getEventCode() == 6 ? 1 : 0) != 0);
        scribbler.close(null);
        editModel.removeListener((IEditModelListener)testListener);
        resource.unload();
        resourceSet.getResources().remove((Object)resource);
    }

    public void testNotifiactionOnSave() throws Exception {
        TestDomain testDomain = this.createTestDomain();
        IEditModel editModel = IEditModelFactory.eINSTANCE.getEditModel(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID);
        IEditModelScribbler scribbler = editModel.createScribbler(new IScribblerDomain[]{testDomain}, false);
        TestEditModelListener testListener = new TestEditModelListener(2);
        editModel.addListener((IEditModelListener)testListener);
        Resource resource = scribbler.getResource(testDomain.getTestURI());
        EJBJar jar = (EJBJar)resource.getContents().get(0);
        jar.setDisplayName("NewDisplayName");
        IEditModelScribblerTest.assertTrue((String)"The resource should have a modified flag set to true.", (boolean)resource.isModified());
        IEditModelScribblerTest.assertTrue((String)"The scribbler should be dirty.", (boolean)scribbler.isDirty());
        IEditModelScribblerTest.assertTrue((String)"A notification of the loaded resource should have been received.", (testListener.getEvents().length == 1 ? 1 : 0) != 0);
        IEditModelScribblerTest.assertTrue((String)"A notification of the loaded resource should have been received.", (testListener.getEvents()[0].getEventCode() == 2 ? 1 : 0) != 0);
        TestProgressMonitor monitor = new TestProgressMonitor(3);
        scribbler.save(true, (IProgressMonitor)monitor);
        monitor.assertMessages("IEditModelScribbler.save() should provide at least 3 messsages.");
        scribbler.close(null);
        editModel.removeListener((IEditModelListener)testListener);
    }

    public void testDeleteResourceResourceIProgressMonitor() throws EditModelException {
        TestDomain testDomain = this.createTestDomain();
        IFile testFile = ResourcesPlugin.getWorkspace().getRoot().getFile(testDomain.getTestPath());
        IEditModelScribblerTest.assertTrue((String)"The IFile we are going to delete should exist.", (boolean)testFile.exists());
        IEditModelScribbler scribbler = IEditModelFactory.eINSTANCE.createScribblerForWrite(TestWorkspace.getTestProject(), (IScribblerDomain)testDomain);
        IEditModelScribblerTest.assertTrue((String)"The scribbler should NOT be dirty.", (!scribbler.isDirty() ? 1 : 0) != 0);
        Resource resource = scribbler.getResource(testDomain.getTestDescriptor());
        TestProgressMonitor monitor = new TestProgressMonitor(2);
        scribbler.deleteResource(testDomain.getTestDescriptor(), (IProgressMonitor)monitor);
        monitor.assertMessages("IEditModelScribbler.deleteResource() should provide at least 2 messsages.");
        IEditModelScribblerTest.assertTrue((String)"The IFile should be deleted immediately.", (!testFile.exists() ? 1 : 0) != 0);
        IEditModelScribblerTest.assertTrue((String)"The scribbler should be dirty after a resource is deleted.", (boolean)scribbler.isDirty());
        IEditModelScribblerTest.assertTrue((String)"Since there is only one scribbler, the write count should have dropped to 0 and unloaded the resource.", (!resource.isLoaded() ? 1 : 0) != 0);
        scribbler.save(true, null);
        IEditModelScribblerTest.assertTrue((String)"The IFile should not exist after save() is invoked.", (!testFile.exists() ? 1 : 0) != 0);
        IEditModelScribblerTest.assertTrue((String)"The scribbler should NOT be dirty after save().", (!scribbler.isDirty() ? 1 : 0) != 0);
        scribbler.close(null);
    }

    public void testDeleteResource() throws EditModelException {
        TestDomain testDomain = this.createTestDomain();
        IFile testFile = ResourcesPlugin.getWorkspace().getRoot().getFile(testDomain.getTestPath());
        IEditModelScribblerTest.assertTrue((String)"The IFile we are going to delete should exist.", (boolean)testFile.exists());
        IEditModelScribbler scribbler = IEditModelFactory.eINSTANCE.createScribblerForWrite(TestWorkspace.getTestProject(), (IScribblerDomain)testDomain);
        Resource resource = scribbler.getResource(testDomain.getTestPath());
        IEditModelScribblerTest.assertTrue((String)"The resource should NOT have a modified flag set to true.", (!resource.isModified() ? 1 : 0) != 0);
        IEditModelScribblerTest.assertTrue((String)"The scribbler should NOT be dirty.", (!scribbler.isDirty() ? 1 : 0) != 0);
        TestProgressMonitor monitor = new TestProgressMonitor(2);
        scribbler.deleteResource(resource, (IProgressMonitor)monitor);
        monitor.assertMessages("IEditModelScribbler.deleteResource() should provide at least 2 messsages.");
        IEditModelScribblerTest.assertTrue((String)"The scribbler should be dirty after a resource is deleted.", (boolean)scribbler.isDirty());
        IEditModelScribblerTest.assertTrue((String)"The IFile should be deleted immediately.", (!testFile.exists() ? 1 : 0) != 0);
        IEditModelScribblerTest.assertTrue((String)"Since there is only one scribbler, the write count should have dropped to 0 and unloaded the resource.", (!resource.isLoaded() ? 1 : 0) != 0);
        scribbler.save(true, null);
        IEditModelScribblerTest.assertTrue((String)"The IFile should not exist after save() is invoked.", (!testFile.exists() ? 1 : 0) != 0);
        IEditModelScribblerTest.assertTrue((String)"The scribbler should NOT be dirty after save().", (!scribbler.isDirty() ? 1 : 0) != 0);
        scribbler.close(null);
    }

    public void testDeleteResourceWithTwoScribblers() throws EditModelException {
        TestDomain testDomain = this.createTestDomain();
        IFile testFile = ResourcesPlugin.getWorkspace().getRoot().getFile(testDomain.getTestPath());
        IEditModelScribblerTest.assertTrue((String)"The IFile we are going to delete should exist.", (boolean)testFile.exists());
        IEditModelScribbler scribbler = IEditModelFactory.eINSTANCE.createScribblerForWrite(TestWorkspace.getTestProject(), (IScribblerDomain)testDomain);
        IEditModelScribbler theOtherScribbler = IEditModelFactory.eINSTANCE.createScribblerForWrite(TestWorkspace.getTestProject(), (IScribblerDomain)testDomain);
        Resource resource = scribbler.getResource(testDomain.getTestPath());
        ScribblerAdapter adapter = ScribblerAdapter.findAdapter((Resource)resource);
        IEditModelScribblerTest.assertTrue((String)"The resource should have a write count of 2.", (adapter.getEditReferenceCount() == 2 ? 1 : 0) != 0);
        IEditModelScribblerTest.assertTrue((String)"The resource should NOT have a modified flag set to true.", (!resource.isModified() ? 1 : 0) != 0);
        IEditModelScribblerTest.assertTrue((String)"The scribbler should NOT be dirty.", (!scribbler.isDirty() ? 1 : 0) != 0);
        TestProgressMonitor monitor = new TestProgressMonitor(2);
        scribbler.deleteResource(resource, (IProgressMonitor)monitor);
        monitor.assertMessages("IEditModelScribbler.deleteResource() should provide at least 2 messsages.");
        IEditModelScribblerTest.assertTrue((String)"The scribbler should be dirty after a resource is deleted.", (boolean)scribbler.isDirty());
        IEditModelScribblerTest.assertTrue((String)"The other scribbler should be dirty after a shared resource is deleted.", (boolean)theOtherScribbler.isDirty());
        IEditModelScribblerTest.assertTrue((String)"The IFile should be deleted immediately.", (!testFile.exists() ? 1 : 0) != 0);
        IEditModelScribblerTest.assertTrue((String)"The write count should be 1.", (adapter.getEditReferenceCount() == 1 ? 1 : 0) != 0);
        scribbler.save(false, null);
        IEditModelScribblerTest.assertTrue((String)"The IFile should not exist after save() is invoked.", (!testFile.exists() ? 1 : 0) != 0);
        IEditModelScribblerTest.assertTrue((String)"The scribbler should still be dirty after save() since there are two scribblers.", (boolean)scribbler.isDirty());
        IEditModelScribblerTest.assertTrue((String)"The other scribbler should be dirty after a save() since it has not been saved.", (boolean)theOtherScribbler.isDirty());
        scribbler.close(null);
        theOtherScribbler.close(null);
    }

    public void testDiscardAfterDeleteResource() throws EditModelException {
        TestDomain testDomain = this.createTestDomain();
        IFile testFile = ResourcesPlugin.getWorkspace().getRoot().getFile(testDomain.getTestPath());
        IEditModelScribblerTest.assertTrue((String)"The IFile we are going to delete should exist.", (boolean)testFile.exists());
        IEditModelScribbler scribbler = IEditModelFactory.eINSTANCE.createScribblerForWrite(TestWorkspace.getTestProject(), (IScribblerDomain)testDomain);
        Resource resource = scribbler.getResource(testDomain.getTestPath());
        EJBJar jar = (EJBJar)resource.getContents().get(0);
        IEditModelScribblerTest.assertNotNull((String)"A model object should have been retrived.", (Object)jar);
        IEditModelScribblerTest.assertEquals((String)"The displayname should be T.", (String)"T", (String)jar.getDisplayName());
        IEditModelScribblerTest.assertTrue((String)"The resource should NOT have a modified flag set to true.", (!resource.isModified() ? 1 : 0) != 0);
        IEditModelScribblerTest.assertTrue((String)"The scribbler should NOT be dirty.", (!scribbler.isDirty() ? 1 : 0) != 0);
        TestProgressMonitor monitor = new TestProgressMonitor(2);
        scribbler.deleteResource(resource, (IProgressMonitor)monitor);
        monitor.assertMessages("IEditModelScribbler.deleteResource() should provide at least 2 messsages.");
        IEditModelScribblerTest.assertTrue((String)"The scribbler should be dirty after a resource is deleted.", (boolean)scribbler.isDirty());
        IEditModelScribblerTest.assertTrue((String)"The IFile should be deleted immediately.", (!testFile.exists() ? 1 : 0) != 0);
        scribbler.discard(null);
        IEditModelScribblerTest.assertTrue((String)"The IFile should now exist after discard() is invoked.", (boolean)testFile.exists());
        IEditModelScribblerTest.assertTrue((String)"The scribbler should NOT be dirty after save().", (!scribbler.isDirty() ? 1 : 0) != 0);
    }

    public void testDiscardIProgressMonitor() throws EditModelException {
        TestDomain testDomain = this.createTestDomain();
        IEditModelScribbler scribbler = IEditModelFactory.eINSTANCE.createScribblerForWrite(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID, new IScribblerDomain[]{testDomain});
        Resource resource = scribbler.getResource(testDomain.getTestURI());
        EJBJar jar = (EJBJar)resource.getContents().get(0);
        IEditModelScribblerTest.assertEquals((String)"Verify the field to be changed is set to the expected value.", (String)"T", (String)jar.getDisplayName());
        jar.setDisplayName("NewDisplayName");
        IEditModelScribblerTest.assertTrue((String)"The scribbler should be dirty after setDisplayName().", (boolean)scribbler.isDirty());
        TestProgressMonitor monitor = new TestProgressMonitor(3);
        scribbler.discard((IProgressMonitor)monitor);
        IEditModelScribblerTest.assertTrue((String)"The scribbler should NOT be dirty after discard().", (!scribbler.isDirty() ? 1 : 0) != 0);
        boolean exceptionThrown = false;
        try {
            scribbler.save(true, null);
        }
        catch (EditModelException editModelException) {
            exceptionThrown = true;
        }
        IEditModelScribblerTest.assertTrue((String)"The scribbler should NOT have been allowed to save.", (boolean)exceptionThrown);
        monitor.assertMessages("IEditModelScribbler.revert() should provide at least 3 messsages.");
        exceptionThrown = false;
        try {
            resource = scribbler.getResource(testDomain.getTestURI());
        }
        catch (IllegalStateException illegalStateException) {
            exceptionThrown = true;
        }
        IEditModelScribblerTest.assertTrue((String)"The scribbler should NOT have been allowed to fetch a new resource.", (boolean)exceptionThrown);
    }

    public void testSaveBooleanIProgressMonitor_V1() throws Exception {
        TestDomain testDomain = this.createTestDomain();
        IEditModelScribbler scribbler = IEditModelFactory.eINSTANCE.createScribblerForWrite(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID, new IScribblerDomain[]{testDomain});
        Resource resource = scribbler.getResource(testDomain.getTestURI());
        EJBJar jar = (EJBJar)resource.getContents().get(0);
        jar.setDisplayName("NewDisplayName");
        IEditModelScribblerTest.assertTrue((String)"The resource should have a modified flag set to true.", (boolean)resource.isModified());
        IEditModelScribblerTest.assertTrue((String)"The scribbler should be dirty.", (boolean)scribbler.isDirty());
        TestProgressMonitor monitor = new TestProgressMonitor(3);
        scribbler.save(true, (IProgressMonitor)monitor);
        IEditModelScribblerTest.assertTrue((String)"The scribbler should NOT be dirty after save().", (!scribbler.isDirty() ? 1 : 0) != 0);
        monitor.assertMessages("IEditModelScribbler.save() should provide at least 3 messsages.");
        scribbler.close(null);
        scribbler = null;
        scribbler = IEditModelFactory.eINSTANCE.createScribblerForRead(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID, new IScribblerDomain[]{testDomain});
        resource = scribbler.getResource(testDomain.getTestURI());
        jar = (EJBJar)resource.getContents().get(0);
        IEditModelScribblerTest.assertEquals((String)"Verify the changed field was modified.", (String)"NewDisplayName", (String)jar.getDisplayName());
        scribbler.close(null);
    }

    public void testSaveReadOnlyIProgressMonitor_V1() throws Exception {
        TestDomain testDomain = this.createTestDomain();
        IEditModelScribbler scribbler = IEditModelFactory.eINSTANCE.createScribblerForWrite(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID, new IScribblerDomain[]{testDomain});
        Resource resource = scribbler.getResource(testDomain.getTestDescriptor(), 6);
        EJBJar jar = (EJBJar)resource.getContents().get(0);
        jar.setDisplayName("NewDisplayName");
        IEditModelScribblerTest.assertTrue((String)"The resource should have a modified flag set to true.", (boolean)resource.isModified());
        IEditModelScribblerTest.assertTrue((String)"The scribbler should NOT be dirty as its loaded as read only.", (!scribbler.isDirty() ? 1 : 0) != 0);
        TestProgressMonitor monitor = new TestProgressMonitor(3);
        scribbler.save(true, (IProgressMonitor)monitor);
        IEditModelScribblerTest.assertTrue((String)"The scribbler should NOT be dirty as its loaded as read only.", (!scribbler.isDirty() ? 1 : 0) != 0);
        monitor.assertMessages("IEditModelScribbler.save() should provide at least 3 messsages.");
        scribbler.close(null);
        scribbler = null;
        scribbler = IEditModelFactory.eINSTANCE.createScribblerForRead(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID, new IScribblerDomain[]{testDomain});
        resource = scribbler.getResource(testDomain.getTestURI(), 6);
        jar = (EJBJar)resource.getContents().get(0);
        IEditModelScribblerTest.assertEquals((String)"Verify the field was not modified since the resource was loaded as read only.", (String)"T", (String)jar.getDisplayName());
        scribbler.close(null);
    }

    public void testSaveReadOnlyIProgressMonitor_V2() throws Exception {
        TestDomain testDomain = this.createTestDomain();
        IEditModelScribbler scribbler = IEditModelFactory.eINSTANCE.createScribblerForWrite(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID, new IScribblerDomain[]{testDomain});
        Resource resource = scribbler.getResource(testDomain.getTestPath(), 6);
        EJBJar jar = (EJBJar)resource.getContents().get(0);
        jar.setDisplayName("NewDisplayName");
        IEditModelScribblerTest.assertTrue((String)"The resource should have a modified flag set to true.", (boolean)resource.isModified());
        IEditModelScribblerTest.assertTrue((String)"The scribbler should NOT be dirty as its loaded as read only.", (!scribbler.isDirty() ? 1 : 0) != 0);
        TestProgressMonitor monitor = new TestProgressMonitor(3);
        scribbler.save(true, (IProgressMonitor)monitor);
        IEditModelScribblerTest.assertTrue((String)"The scribbler should NOT be dirty as its loaded as read only.", (!scribbler.isDirty() ? 1 : 0) != 0);
        monitor.assertMessages("IEditModelScribbler.save() should provide at least 3 messsages.");
        scribbler.close(null);
        scribbler = null;
        scribbler = IEditModelFactory.eINSTANCE.createScribblerForRead(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID, new IScribblerDomain[]{testDomain});
        resource = scribbler.getResource(testDomain.getTestURI(), 6);
        jar = (EJBJar)resource.getContents().get(0);
        IEditModelScribblerTest.assertEquals((String)"Verify the field was not modified since the resource was loaded as read only.", (String)"T", (String)jar.getDisplayName());
        scribbler.close(null);
    }

    public void testSaveReadOnlyIProgressMonitor_V3() throws Exception {
        TestDomain testDomain = this.createTestDomain();
        IEditModelScribbler scribbler = IEditModelFactory.eINSTANCE.createScribblerForWrite(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID, new IScribblerDomain[]{testDomain});
        Resource resource = scribbler.getResource(testDomain.getTestURI(), 6);
        EJBJar jar = (EJBJar)resource.getContents().get(0);
        jar.setDisplayName("NewDisplayName");
        IEditModelScribblerTest.assertTrue((String)"The resource should have a modified flag set to true.", (boolean)resource.isModified());
        IEditModelScribblerTest.assertTrue((String)"The scribbler should NOT be dirty as its loaded as read only.", (!scribbler.isDirty() ? 1 : 0) != 0);
        TestProgressMonitor monitor = new TestProgressMonitor(3);
        scribbler.save(true, (IProgressMonitor)monitor);
        IEditModelScribblerTest.assertTrue((String)"The scribbler should NOT be dirty as its loaded as read only.", (!scribbler.isDirty() ? 1 : 0) != 0);
        monitor.assertMessages("IEditModelScribbler.save() should provide at least 3 messsages.");
        scribbler.close(null);
        scribbler = null;
        scribbler = IEditModelFactory.eINSTANCE.createScribblerForRead(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID, new IScribblerDomain[]{testDomain});
        resource = scribbler.getResource(testDomain.getTestURI(), 6);
        jar = (EJBJar)resource.getContents().get(0);
        IEditModelScribblerTest.assertEquals((String)"Verify the field was not modified since the resource was loaded as read only.", (String)"T", (String)jar.getDisplayName());
        scribbler.close(null);
    }

    public void testSaveBooleanIProgressMonitor_V2() throws Exception {
        TestDomain testDomain = this.createTestDomain();
        IEditModelScribbler editModelScribbler = IEditModelFactory.eINSTANCE.createScribblerForWrite(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID, new IScribblerDomain[]{testDomain});
        IEditModelScribbler operationScribbler = IEditModelFactory.eINSTANCE.createScribblerForWrite(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID, new IScribblerDomain[]{testDomain});
        Resource resource = operationScribbler.getResource(testDomain.getTestURI());
        EJBJar jar = (EJBJar)resource.getContents().get(0);
        jar.setDisplayName("NewDisplayName");
        IEditModelScribblerTest.assertTrue((String)"The resource should have a modified flag set to true.", (boolean)resource.isModified());
        IEditModelScribblerTest.assertTrue((String)"The Operation scribbler should be dirty.", (boolean)operationScribbler.isDirty());
        IEditModelScribblerTest.assertTrue((String)"The Editor scribbler should be dirty.", (boolean)editModelScribbler.isDirty());
        TestProgressMonitor monitor = new TestProgressMonitor(3);
        operationScribbler.save(false, (IProgressMonitor)monitor);
        IEditModelScribblerTest.assertTrue((String)"The Operation scribbler should be dirty after save(false).", (boolean)operationScribbler.isDirty());
        IEditModelScribblerTest.assertTrue((String)"The Editor scribbler should be dirty after save(false).", (boolean)editModelScribbler.isDirty());
        operationScribbler.close(null);
        resource = editModelScribbler.getResource(testDomain.getTestURI());
        jar = (EJBJar)resource.getContents().get(0);
        IEditModelScribblerTest.assertEquals((String)"Verify the changed field was modified.", (String)"NewDisplayName", (String)jar.getDisplayName());
        editModelScribbler.close(null);
        editModelScribbler = IEditModelFactory.eINSTANCE.createScribblerForWrite(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID, new IScribblerDomain[]{testDomain});
        resource = editModelScribbler.getResource(testDomain.getTestURI());
        jar = (EJBJar)resource.getContents().get(0);
        IEditModelScribblerTest.assertEquals((String)"Verify the changed field was modified.", (String)"NewDisplayName", (String)jar.getDisplayName());
        editModelScribbler.close(null);
    }

    public void testSaveBooleanIProgressMonitor_V3() throws Exception {
        TestDomain testDomain = this.createTestDomain();
        DefaultScribblerDomain testDomain2 = new DefaultScribblerDomain(){
            private IResourceDescriptor[] descs = new IResourceDescriptor[]{new EclipseResourceDescriptor(TestWorkspace.getTestProject().getFile(".project"))};

            public String getEditModelLabel() {
                return IEditModelScribblerTest.TEST_EDITMODEL_ID;
            }

            public IResourceDescriptor[] getResourceDescriptors() {
                return this.descs;
            }
        };
        IEditModelScribbler editModelScribbler = IEditModelFactory.eINSTANCE.createScribblerForWrite(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID, new IScribblerDomain[]{testDomain, testDomain2});
        IEditModelScribbler operationScribbler = IEditModelFactory.eINSTANCE.createScribblerForWrite(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID, new IScribblerDomain[]{testDomain});
        Resource resource = operationScribbler.getResource(testDomain.getTestURI());
        EJBJar jar = (EJBJar)resource.getContents().get(0);
        jar.setDisplayName("NewDisplayName");
        IEditModelScribblerTest.assertTrue((String)"The resource should have a modified flag set to true.", (boolean)resource.isModified());
        IEditModelScribblerTest.assertTrue((String)"The Operation scribbler should be dirty.", (boolean)operationScribbler.isDirty());
        IEditModelScribblerTest.assertTrue((String)"The Editor scribbler should be dirty.", (boolean)editModelScribbler.isDirty());
        TestProgressMonitor monitor = new TestProgressMonitor(3);
        operationScribbler.save(false, (IProgressMonitor)monitor);
        IEditModelScribblerTest.assertTrue((String)"The Operation scribbler should NOT be dirty after save(false).", (!operationScribbler.isDirty() ? 1 : 0) != 0);
        IEditModelScribblerTest.assertTrue((String)"The Editor scribbler should be dirty after save(false).", (!editModelScribbler.isDirty() ? 1 : 0) != 0);
        operationScribbler.close(null);
        resource = editModelScribbler.getResource(testDomain.getTestURI());
        jar = (EJBJar)resource.getContents().get(0);
        IEditModelScribblerTest.assertEquals((String)"Verify the changed field was modified.", (String)"NewDisplayName", (String)jar.getDisplayName());
        editModelScribbler.close(null);
        editModelScribbler = IEditModelFactory.eINSTANCE.createScribblerForWrite(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID, new IScribblerDomain[]{testDomain});
        resource = editModelScribbler.getResource(testDomain.getTestURI());
        jar = (EJBJar)resource.getContents().get(0);
        IEditModelScribblerTest.assertEquals((String)"Verify the changed field was modified.", (String)"NewDisplayName", (String)jar.getDisplayName());
        editModelScribbler.close(null);
    }

    public void testRevertIProgressMonitor() throws Exception {
        TestDomain testDomain = this.createTestDomain();
        IEditModelScribbler scribbler = IEditModelFactory.eINSTANCE.createScribblerForWrite(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID, new IScribblerDomain[]{testDomain});
        Resource resource = scribbler.getResource(testDomain.getTestURI());
        EJBJar jar = (EJBJar)resource.getContents().get(0);
        IEditModelScribblerTest.assertEquals((String)"Verify the field to be changed is set to the expected value.", (String)"T", (String)jar.getDisplayName());
        jar.setDisplayName("NewDisplayName");
        IEditModelScribblerTest.assertTrue((String)"The scribbler should be dirty after setDisplayName().", (boolean)scribbler.isDirty());
        TestProgressMonitor monitor = new TestProgressMonitor(3);
        scribbler.revert((IProgressMonitor)monitor);
        IEditModelScribblerTest.assertTrue((String)"The scribbler should NOT be dirty after revert().", (!scribbler.isDirty() ? 1 : 0) != 0);
        monitor.assertMessages("IEditModelScribbler.revert() should provide at least 3 messsages.");
        resource = scribbler.getResource(testDomain.getTestURI());
        jar = (EJBJar)resource.getContents().get(0);
        IEditModelScribblerTest.assertEquals((String)"Verify the changed field was reverted.", (String)"T", (String)jar.getDisplayName());
        scribbler.close(null);
    }

    public void testExecuteUndo() throws Exception {
        TestOperation setDisplayNameOp = new TestOperation();
        TestDomain testDomain = this.createTestDomain();
        IEditModelScribbler scribbler = IEditModelFactory.eINSTANCE.createScribblerForRead(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID, new IScribblerDomain[]{testDomain});
        Resource resource = scribbler.getResource(testDomain.getTestURI());
        EJBJar jar = (EJBJar)resource.getContents().get(0);
        String currentDisplayName = jar.getDisplayName();
        TestOperationArgs args = new TestOperationArgs("ATestDisplayName", jar);
        IEditModelScribblerTest.assertFalse((String)"The display name should be the new value.", (boolean)args.getNewDisplayName().equals(jar.getDisplayName()));
        scribbler.execute((IUndoableOperation)setDisplayNameOp, null, (IAdaptable)args);
        IEditModelScribblerTest.assertEquals((String)"The display name should be the new value.", (String)args.getNewDisplayName(), (String)jar.getDisplayName());
        scribbler.undo((IUndoableOperation)setDisplayNameOp, null, (IAdaptable)args);
        IEditModelScribblerTest.assertEquals((String)"The display name should be the new value.", (String)currentDisplayName, (String)jar.getDisplayName());
        scribbler.close(null);
    }

    public void testActLikeAnEMFCommandStack() throws Exception {
        TestDomain testDomain = this.createTestDomain();
        IEditModelScribbler scribbler = IEditModelFactory.eINSTANCE.createScribblerForRead(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID, new IScribblerDomain[]{testDomain});
        Resource resource = scribbler.getResource(testDomain.getTestURI());
        EJBJar jar = (EJBJar)resource.getContents().get(0);
        String oldDisplayName = jar.getDisplayName();
        String newDisplayNameValue = "NewDisplayName";
        DynamicAdapterFactory adapterFactory = new DynamicAdapterFactory(null);
        Object adaptedType = scribbler.getAdapter(CommandStack.class);
        IEditModelScribblerTest.assertTrue((String)"Verify that the returned object is of type org.eclipse.emf.common.command.CommandStack.", (boolean)(adaptedType instanceof CommandStack));
        CommandStack commandStack = (CommandStack)adaptedType;
        AdapterFactoryEditingDomain domain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, commandStack);
        Command setDisplayNameCmd = SetCommand.create((EditingDomain)domain, (Object)jar, (Object)CommonPackage.eINSTANCE.getCompatibilityDescriptionGroup_DisplayName(), (Object)newDisplayNameValue);
        domain.getCommandStack().execute(setDisplayNameCmd);
        IEditModelScribblerTest.assertEquals((String)"The display name should be the new value.", (String)newDisplayNameValue, (String)jar.getDisplayName());
        domain.getCommandStack().undo();
        IEditModelScribblerTest.assertEquals((String)"The display name should be the new value.", (String)oldDisplayName, (String)jar.getDisplayName());
        scribbler.close(null);
    }

    public void testActLikeAnEMFCommandStackAndIntegrateScribblerUndo() throws Exception {
        TestDomain testDomain = this.createTestDomain();
        IEditModelScribbler scribbler = IEditModelFactory.eINSTANCE.createScribblerForRead(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID, new IScribblerDomain[]{testDomain});
        Resource resource = scribbler.getResource(testDomain.getTestURI());
        EJBJar jar = (EJBJar)resource.getContents().get(0);
        String oldDisplayName = jar.getDisplayName();
        String newDisplayNameValue = "NewDisplayName";
        DynamicAdapterFactory adapterFactory = new DynamicAdapterFactory(null);
        Object adaptedType = scribbler.getAdapter(CommandStack.class);
        IEditModelScribblerTest.assertTrue((String)"Verify that the returned object is of type org.eclipse.emf.common.command.CommandStack.", (boolean)(adaptedType instanceof CommandStack));
        CommandStack commandStack = (CommandStack)adaptedType;
        AdapterFactoryEditingDomain domain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, commandStack);
        Command setDisplayNameCmd = SetCommand.create((EditingDomain)domain, (Object)jar, (Object)CommonPackage.eINSTANCE.getCompatibilityDescriptionGroup_DisplayName(), (Object)newDisplayNameValue);
        domain.getCommandStack().execute(setDisplayNameCmd);
        IEditModelScribblerTest.assertEquals((String)"The display name should be the new value.", (String)newDisplayNameValue, (String)jar.getDisplayName());
        scribbler.undoLast(null, null);
        IEditModelScribblerTest.assertEquals((String)"The display name should be the new value.", (String)oldDisplayName, (String)jar.getDisplayName());
        scribbler.close(null);
    }

    public void testUndoLast() throws Exception {
        TestOperation setDisplayNameOp = new TestOperation();
        TestDomain testDomain = this.createTestDomain();
        IEditModelScribbler scribbler = IEditModelFactory.eINSTANCE.createScribblerForRead(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID, new IScribblerDomain[]{testDomain});
        Resource resource = scribbler.getResource(testDomain.getTestURI());
        EJBJar jar = (EJBJar)resource.getContents().get(0);
        String currentDisplayName = jar.getDisplayName();
        TestOperationArgs args = new TestOperationArgs("ATestDisplayName", jar);
        IEditModelScribblerTest.assertFalse((String)"The display name should be the new value.", (boolean)args.getNewDisplayName().equals(jar.getDisplayName()));
        scribbler.execute((IUndoableOperation)setDisplayNameOp, null, (IAdaptable)args);
        IEditModelScribblerTest.assertEquals((String)"The display name should be the new value.", (String)args.getNewDisplayName(), (String)jar.getDisplayName());
        scribbler.undoLast(null, (IAdaptable)args);
        IEditModelScribblerTest.assertEquals((String)"The display name should be the new value.", (String)currentDisplayName, (String)jar.getDisplayName());
        scribbler.close(null);
    }

    public void testPromptOnClose() {
    }

    public void testCloseIProgressMonitor() throws EditModelException {
        TestDomain testDomain = this.createTestDomain();
        IEditModelScribbler scribbler = IEditModelFactory.eINSTANCE.createScribblerForWrite(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID, new IScribblerDomain[]{testDomain});
        Resource resource = scribbler.getResource(testDomain.getTestURI());
        EJBJar jar = (EJBJar)resource.getContents().get(0);
        jar.setDisplayName("NewDisplayName");
        IEditModelScribblerTest.assertTrue((String)"The resource should have a modified flag set to true.", (boolean)resource.isModified());
        IEditModelScribblerTest.assertTrue((String)"The scribbler should be dirty.", (boolean)scribbler.isDirty());
        TestHumanInteractionController controller = new TestHumanInteractionController(Boolean.TRUE);
        scribbler.setUserInterfaceController((IHumanInteractionController)controller);
        TestProgressMonitor monitor = new TestProgressMonitor(3);
        scribbler.close((IProgressMonitor)monitor);
        IEditModelScribblerTest.assertTrue((String)"The scribbler should NOT be dirty after close().", (!scribbler.isDirty() ? 1 : 0) != 0);
        monitor.assertMessages("IEditModelScribbler.save() should provide at least 3 messsages.");
        scribbler = IEditModelFactory.eINSTANCE.createScribblerForRead(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID, new IScribblerDomain[]{testDomain});
        resource = scribbler.getResource(testDomain.getTestURI());
        jar = (EJBJar)resource.getContents().get(0);
        IEditModelScribblerTest.assertEquals((String)"Verify the changed field was modified.", (String)"NewDisplayName", (String)jar.getDisplayName());
        scribbler.close(null);
    }
}

