/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.tests.infrastructure.util;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.stp.core.tests.infrastructure.InfrastructureTestsPlugin;
import org.eclipse.stp.core.tests.infrastructure.util.TestOperationArgs;

public class TestOperation
extends AbstractOperation
implements IUndoableOperation {
    private String lastDisplayName;
    private TestOperationArgs lastArgs;

    public TestOperation() {
        super("Set the display name");
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        TestOperationArgs args = (TestOperationArgs)info.getAdapter(TestOperationArgs.class);
        this.lastArgs = new TestOperationArgs(args);
        if (this.lastArgs != null) {
            EJBJar jar = this.lastArgs.getEjbJar();
            this.lastDisplayName = jar.getDisplayName();
            jar.setDisplayName(this.lastArgs.getNewDisplayName());
            return Status.OK_STATUS;
        }
        return new Status(4, InfrastructureTestsPlugin.PLUGIN_ID, 0, "Could not execute Test Operations, no Args available.", null);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.lastArgs != null) {
            EJBJar jar = this.lastArgs.getEjbJar();
            jar.setDisplayName(this.lastDisplayName);
            return Status.OK_STATUS;
        }
        return new Status(4, InfrastructureTestsPlugin.PLUGIN_ID, 0, "Could not execute Test Operations, no Args available.", null);
    }
}

