/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.tests.infrastructure.util;

import junit.framework.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public class TestProgressMonitor
implements IProgressMonitor {
    private static final boolean LOG_PROGRESS_MESSAGES = false;
    private int minimumDensity;
    private boolean strictEnforcement;
    private String[] requiredMessages;
    private int current = 0;
    private int taskCompletionStack;
    private String taskName;

    public TestProgressMonitor(int theMinimumDensity) {
        this.minimumDensity = theMinimumDensity;
        this.strictEnforcement = false;
    }

    public TestProgressMonitor(String[] theRequiredMessages, boolean toEnforceStrictly) {
        this.minimumDensity = theRequiredMessages.length;
        this.requiredMessages = theRequiredMessages;
        this.strictEnforcement = toEnforceStrictly;
    }

    public void assertMessages(String message) {
        Assert.assertEquals((String)"The number of begun tasks should match the number of completed tasks.", (int)0, (int)this.taskCompletionStack);
        if (this.strictEnforcement) {
            Assert.assertEquals((String)message, (int)this.minimumDensity, (int)this.current);
        } else {
            Assert.assertTrue((String)message, (this.minimumDensity <= this.current ? 1 : 0) != 0);
        }
    }

    public void beginTask(String name, int totalWork) {
        if (this.requiredMessages == null || this.requiredMessages[this.current].equals(name)) {
            ++this.current;
        }
        ++this.taskCompletionStack;
        this.taskName = name;
    }

    public void done() {
        --this.taskCompletionStack;
    }

    public void internalWorked(double work) {
    }

    public boolean isCanceled() {
        return false;
    }

    public void setCanceled(boolean value) {
    }

    public void setTaskName(String name) {
    }

    public void subTask(String name) {
        if (this.requiredMessages == null || this.requiredMessages[this.current].equals(name)) {
            ++this.current;
        }
    }

    public void worked(int work) {
    }
}

