/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.tests.introspection;

import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stp.core.internal.introspection.AttributeSet;
import org.eclipse.stp.core.internal.introspection.IntrospectionRecorder;
import org.eclipse.stp.core.internal.introspection.query.AttributesExpression;
import org.eclipse.stp.core.internal.introspection.query.CombinedQuery;
import org.eclipse.stp.core.internal.introspection.query.IModelQuery;
import org.eclipse.stp.core.internal.introspection.query.StructuralFeatureExpression;
import org.eclipse.stp.core.introspection.IDynamicModelIntrospector;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.JavaInterface;
import org.eclipse.stp.core.sca.Property;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.sca.Service;
import org.eclipse.stp.core.tests.introspection.PropertiesLightweightParser;
import org.eclipse.stp.core.tests.introspection.ShareablePropertyComponentTypeFactory;

public class LightweightParserTests
extends TestCase {
    private static final SCAPackage scaPkg = SCAPackage.eINSTANCE;
    private static final SCAFactory factory = SCAFactory.eINSTANCE;
    private static final String EXPECTED_SERVICE_NAME = "Service1";
    private static final String EXPECTED_INTERFACE = "org.acme.ITest";

    public LightweightParserTests(String name) {
        super(name);
    }

    public static TestSuite suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(LightweightParserTests.class);
        return suite;
    }

    public void testServiceAnnouncement() throws Exception {
        ShareablePropertyComponentTypeFactory.isTestingIncremental = false;
        try {
            ComponentType cType = factory.createComponentType();
            PropertiesLightweightParser propertiesParser = new PropertiesLightweightParser((IDynamicModelIntrospector)new IntrospectionRecorder(), cType);
            propertiesParser.begin();
            propertiesParser.createService(EXPECTED_SERVICE_NAME, EXPECTED_INTERFACE);
            propertiesParser.end();
            LightweightParserTests.assertEquals((String)"A service should have been created.", (int)1, (int)cType.getServices().size());
            Service s = (Service)cType.getServices().get(0);
            LightweightParserTests.assertEquals((String)"The name of the service should be 'Service1'.", (String)EXPECTED_SERVICE_NAME, (String)s.getName());
            Interface intf1 = s.getInterface();
            LightweightParserTests.assertEquals((String)"The Service should have a JavaInterface.", (Object)scaPkg.getJavaInterface(), (Object)s.getInterface().getEObject().eClass());
            String intfValue = ((JavaInterface)intf1).getInterface();
            LightweightParserTests.assertEquals((String)"The specified interface should be 'org.acme.ITest'.", (String)EXPECTED_INTERFACE, (String)intfValue);
            propertiesParser.begin();
            propertiesParser.createService("RenamedService", EXPECTED_INTERFACE);
            propertiesParser.end();
            LightweightParserTests.assertEquals((String)"A new service should NOT have been created.", (int)1, (int)cType.getServices().size());
            s = (Service)cType.getServices().get(0);
            LightweightParserTests.assertEquals((String)"The name of the service should be 'RenamedService'.", (String)"RenamedService", (String)s.getName());
            Interface intf2 = s.getInterface();
            LightweightParserTests.assertTrue((String)"The interface should be equivalent by identity.", (intf1 == intf2 ? 1 : 0) != 0);
            LightweightParserTests.assertEquals((String)"The Service should have a JavaInterface.", (Object)scaPkg.getJavaInterface(), (Object)s.getInterface().getEObject().eClass());
            intfValue = ((JavaInterface)intf2).getInterface();
            LightweightParserTests.assertEquals((String)"The specified interface should be 'org.acme.ITest'.", (String)EXPECTED_INTERFACE, (String)intfValue);
        }
        finally {
            ShareablePropertyComponentTypeFactory.isTestingIncremental = true;
        }
    }

    public void testMultipleServiceAnnouncement() throws Exception {
        ShareablePropertyComponentTypeFactory.isTestingIncremental = false;
        try {
            ComponentType cType = factory.createComponentType();
            PropertiesLightweightParser propertiesParser = new PropertiesLightweightParser((IDynamicModelIntrospector)new IntrospectionRecorder(), cType);
            propertiesParser.begin();
            propertiesParser.createService(EXPECTED_SERVICE_NAME, EXPECTED_INTERFACE);
            propertiesParser.createService("NewService", "org.acme.ITest2");
            propertiesParser.end();
            LightweightParserTests.assertEquals((String)"A service should have been created.", (int)2, (int)cType.getServices().size());
            int i = 0;
            while (i < cType.getServices().size()) {
                String intfValue;
                Service s = (Service)cType.getServices().get(i);
                if (s.getName().equals(EXPECTED_SERVICE_NAME)) {
                    LightweightParserTests.assertEquals((String)"The name of the service should be 'Service1'.", (String)EXPECTED_SERVICE_NAME, (String)s.getName());
                    Interface intf1 = s.getInterface();
                    LightweightParserTests.assertEquals((String)"The Service should have a JavaInterface.", (Object)scaPkg.getJavaInterface(), (Object)s.getInterface().getEObject().eClass());
                    intfValue = ((JavaInterface)intf1).getInterface();
                    LightweightParserTests.assertEquals((String)"The specified interface should be 'org.acme.ITest'.", (String)EXPECTED_INTERFACE, (String)intfValue);
                } else if (s.getName().equals("NewService")) {
                    LightweightParserTests.assertEquals((String)"The name of the service should be 'NewService'.", (String)"NewService", (String)s.getName());
                    Interface intf2 = s.getInterface();
                    LightweightParserTests.assertEquals((String)"The Service should have a JavaInterface.", (Object)scaPkg.getJavaInterface(), (Object)s.getInterface().getEObject().eClass());
                    intfValue = ((JavaInterface)intf2).getInterface();
                    LightweightParserTests.assertEquals((String)"The specified interface should be 'org.acme.ITest2'.", (String)"org.acme.ITest2", (String)intfValue);
                } else {
                    Assert.fail((String)"The name of the service was incorrect.");
                }
                ++i;
            }
        }
        finally {
            ShareablePropertyComponentTypeFactory.isTestingIncremental = true;
        }
    }

    public void testServiceAnnouncement_ImplicitDelete() throws Exception {
        ShareablePropertyComponentTypeFactory.isTestingIncremental = false;
        try {
            ComponentType cType = factory.createComponentType();
            PropertiesLightweightParser propertiesParser = new PropertiesLightweightParser((IDynamicModelIntrospector)new IntrospectionRecorder(), cType);
            propertiesParser.begin();
            propertiesParser.createService(EXPECTED_SERVICE_NAME, EXPECTED_INTERFACE);
            propertiesParser.end();
            LightweightParserTests.assertEquals((String)"A service should have been created.", (int)1, (int)cType.getServices().size());
            Service s = (Service)cType.getServices().get(0);
            LightweightParserTests.assertEquals((String)"The name of the service should be 'Service1'.", (String)EXPECTED_SERVICE_NAME, (String)s.getName());
            Interface intf1 = s.getInterface();
            LightweightParserTests.assertEquals((String)"The Service should have a JavaInterface.", (Object)scaPkg.getJavaInterface(), (Object)s.getInterface().getEObject().eClass());
            String intfValue = ((JavaInterface)intf1).getInterface();
            LightweightParserTests.assertEquals((String)"The specified interface should be 'org.acme.ITest'.", (String)EXPECTED_INTERFACE, (String)intfValue);
            propertiesParser.begin();
            propertiesParser.createService("RenamedService", "org.acme.ITest2");
            propertiesParser.end();
            propertiesParser.removeUntouchedServices();
            LightweightParserTests.assertEquals((String)"A new service should NOT have been created.", (int)1, (int)cType.getServices().size());
            s = (Service)cType.getServices().get(0);
            LightweightParserTests.assertEquals((String)"The name of the service should be 'RenamedService'.", (String)"RenamedService", (String)s.getName());
            Interface intf2 = s.getInterface();
            LightweightParserTests.assertEquals((String)"The Service should have a JavaInterface.", (Object)scaPkg.getJavaInterface(), (Object)s.getInterface().getEObject().eClass());
            intfValue = ((JavaInterface)intf2).getInterface();
            LightweightParserTests.assertEquals((String)"The specified interface should be 'org.acme.ITest2'.", (String)"org.acme.ITest2", (String)intfValue);
        }
        finally {
            ShareablePropertyComponentTypeFactory.isTestingIncremental = true;
        }
    }

    public void testServiceAnnouncement_IncrementalDelete() throws Exception {
        ShareablePropertyComponentTypeFactory.isTestingIncremental = false;
        try {
            ComponentType cType = factory.createComponentType();
            PropertiesLightweightParser propertiesParser = new PropertiesLightweightParser((IDynamicModelIntrospector)new IntrospectionRecorder(), cType);
            propertiesParser.begin();
            propertiesParser.createService(EXPECTED_SERVICE_NAME, EXPECTED_INTERFACE);
            propertiesParser.end();
            LightweightParserTests.assertEquals((String)"A service should have been created.", (int)1, (int)cType.getServices().size());
            Service s = (Service)cType.getServices().get(0);
            LightweightParserTests.assertEquals((String)"The name of the service should be 'Service1'.", (String)EXPECTED_SERVICE_NAME, (String)s.getName());
            Interface intf1 = s.getInterface();
            LightweightParserTests.assertEquals((String)"The Service should have a JavaInterface.", (Object)scaPkg.getJavaInterface(), (Object)s.getInterface().getEObject().eClass());
            String intfValue = ((JavaInterface)intf1).getInterface();
            LightweightParserTests.assertEquals((String)"The specified interface should be 'org.acme.ITest'.", (String)EXPECTED_INTERFACE, (String)intfValue);
            propertiesParser.begin();
            propertiesParser.deleteService("RenamedService", EXPECTED_INTERFACE);
            propertiesParser.end();
            LightweightParserTests.assertEquals((String)"There should be no services.", (int)0, (int)cType.getServices().size());
        }
        finally {
            ShareablePropertyComponentTypeFactory.isTestingIncremental = true;
        }
    }

    public void testReferenceAnnouncement() throws Exception {
        ShareablePropertyComponentTypeFactory.isTestingIncremental = false;
        try {
            ComponentType cType = factory.createComponentType();
            PropertiesLightweightParser propertiesParser = new PropertiesLightweightParser((IDynamicModelIntrospector)new IntrospectionRecorder(), cType);
            propertiesParser.begin();
            propertiesParser.createReference("Reference1", EXPECTED_INTERFACE, "1");
            propertiesParser.end();
            LightweightParserTests.assertEquals((String)"A reference should have been created.", (int)1, (int)cType.getReferences().size());
            Reference r = (Reference)cType.getReferences().get(0);
            LightweightParserTests.assertEquals((String)"The name of the reference should be 'Reference1'.", (String)"Reference1", (String)r.getName());
            Interface intf1 = r.getInterface();
            LightweightParserTests.assertEquals((String)"The Reference should have a JavaInterface.", (Object)scaPkg.getJavaInterface(), (Object)r.getInterface().getEObject().eClass());
            String intfValue = ((JavaInterface)intf1).getInterface();
            LightweightParserTests.assertEquals((String)"The specified interface should be 'org.acme.ITest'.", (String)EXPECTED_INTERFACE, (String)intfValue);
            propertiesParser.begin();
            propertiesParser.createReference("Reference2", EXPECTED_INTERFACE, "2");
            propertiesParser.end();
            propertiesParser.removeUntouchedReferences();
            LightweightParserTests.assertEquals((String)"A new reference should NOT have been created.", (int)1, (int)cType.getReferences().size());
            r = (Reference)cType.getReferences().get(0);
            LightweightParserTests.assertEquals((String)"The name of the reference should be 'Reference2'.", (String)"Reference2", (String)r.getName());
            Interface intf2 = r.getInterface();
            LightweightParserTests.assertEquals((String)"The Reference should have a JavaInterface.", (Object)scaPkg.getJavaInterface(), (Object)r.getInterface().getEObject().eClass());
            intfValue = ((JavaInterface)intf2).getInterface();
            LightweightParserTests.assertEquals((String)"The specified interface should be 'org.acme.ITest'.", (String)EXPECTED_INTERFACE, (String)intfValue);
        }
        finally {
            ShareablePropertyComponentTypeFactory.isTestingIncremental = true;
        }
    }

    public void testReferenceAnnouncement_IncrementalDelete() throws Exception {
        ShareablePropertyComponentTypeFactory.isTestingIncremental = false;
        try {
            ComponentType cType = factory.createComponentType();
            PropertiesLightweightParser propertiesParser = new PropertiesLightweightParser((IDynamicModelIntrospector)new IntrospectionRecorder(), cType);
            propertiesParser.begin();
            propertiesParser.createReference("Reference1", EXPECTED_INTERFACE, "1");
            propertiesParser.createReference("Reference2", EXPECTED_INTERFACE, "1");
            propertiesParser.end();
            LightweightParserTests.assertEquals((String)"Two reference should have been created.", (int)2, (int)cType.getReferences().size());
            int i = 0;
            while (i < cType.getReferences().size()) {
                Reference r = (Reference)cType.getReferences().get(i);
                if (r.getName().equals("Reference1") || r.getName().equals("Reference2")) {
                    Interface intf1 = r.getInterface();
                    LightweightParserTests.assertEquals((String)"The Reference should have a JavaInterface.", (Object)scaPkg.getJavaInterface(), (Object)r.getInterface().getEObject().eClass());
                    String intfValue = ((JavaInterface)intf1).getInterface();
                    LightweightParserTests.assertEquals((String)"The specified interface should be 'org.acme.ITest'.", (String)EXPECTED_INTERFACE, (String)intfValue);
                } else {
                    Assert.fail((String)"The reference name is incorrect");
                }
                ++i;
            }
            propertiesParser.begin();
            propertiesParser.deleteReference("Reference2");
            propertiesParser.end();
            LightweightParserTests.assertEquals((String)"There should be only one reference.", (int)1, (int)cType.getReferences().size());
            Reference r = (Reference)cType.getReferences().get(0);
            LightweightParserTests.assertEquals((String)"The name of the reference should be 'Reference1'.", (String)"Reference1", (String)r.getName());
            Interface intf1 = r.getInterface();
            LightweightParserTests.assertEquals((String)"The Reference should have a JavaInterface.", (Object)scaPkg.getJavaInterface(), (Object)r.getInterface().getEObject().eClass());
            String intfValue = ((JavaInterface)intf1).getInterface();
            LightweightParserTests.assertEquals((String)"The specified interface should be 'org.acme.ITest'.", (String)EXPECTED_INTERFACE, (String)intfValue);
        }
        finally {
            ShareablePropertyComponentTypeFactory.isTestingIncremental = true;
        }
    }

    public void testPropertyAnnouncement() throws Exception {
        ShareablePropertyComponentTypeFactory.isTestingIncremental = false;
        try {
            ComponentType cType = factory.createComponentType();
            PropertiesLightweightParser propertiesParser = new PropertiesLightweightParser((IDynamicModelIntrospector)new IntrospectionRecorder(), cType);
            propertiesParser.begin();
            propertiesParser.createProperty("Property1", "java.lang.String", false, true, "value1");
            propertiesParser.end();
            LightweightParserTests.assertEquals((String)"A property should have been created.", (int)1, (int)cType.getProperties().size());
            Property p = (Property)cType.getProperties().get(0);
            LightweightParserTests.assertEquals((String)"The name of the property should be 'Property1'.", (String)"Property1", (String)p.getName());
            LightweightParserTests.assertEquals((String)"The type should be 'java.lang.String'.", (String)"java.lang.String", (String)p.getType().toString());
            LightweightParserTests.assertEquals((String)"The default value should be 'value1'.", (String)"value1", (String)p.getDefault());
            LightweightParserTests.assertEquals((String)"The isMany value should be 'false'.", (boolean)false, (boolean)p.isMany());
            LightweightParserTests.assertEquals((String)"The isRequired value should be 'true'.", (boolean)true, (boolean)p.isRequired());
            propertiesParser.begin();
            propertiesParser.createProperty("Property2", "java.lang.String", true, false, "value1");
            propertiesParser.end();
            LightweightParserTests.assertEquals((String)"A new property should have been created.", (int)2, (int)cType.getProperties().size());
            p = (Property)cType.getProperties().get(1);
            LightweightParserTests.assertEquals((String)"The name of the property should be 'Property2'.", (String)"Property2", (String)p.getName());
            LightweightParserTests.assertEquals((String)"The type should be 'java.lang.String'.", (String)"java.lang.String", (String)p.getType().toString());
            LightweightParserTests.assertEquals((String)"The default value should be 'value1'.", (String)"value1", (String)p.getDefault());
            LightweightParserTests.assertEquals((String)"The isMany value should be 'false'.", (boolean)true, (boolean)p.isMany());
            LightweightParserTests.assertEquals((String)"The isRequired value should be 'true'.", (boolean)false, (boolean)p.isRequired());
            propertiesParser.begin();
            propertiesParser.createProperty("Property3", "java.lang.String", true, false, "value1");
            propertiesParser.end();
            propertiesParser.removeUntouchedProperties();
            LightweightParserTests.assertEquals((String)"There should now be one property.", (int)1, (int)cType.getProperties().size());
            p = (Property)cType.getProperties().get(0);
            LightweightParserTests.assertEquals((String)"The name of the property should be 'Property3'.", (String)"Property3", (String)p.getName());
        }
        finally {
            ShareablePropertyComponentTypeFactory.isTestingIncremental = true;
        }
    }

    public void testQuery_matchesServiceNameAndJavaInterface() throws Exception {
        ComponentType cType = factory.createComponentType();
        Service service1 = factory.createService();
        service1.setName(EXPECTED_SERVICE_NAME);
        JavaInterface jInterface = factory.createJavaInterface();
        jInterface.setInterface(EXPECTED_INTERFACE);
        service1.setInterface((Interface)jInterface);
        cType.getServices().add(service1);
        Service service2 = factory.createService();
        service2.setName("SomeName");
        JavaInterface jInterface2 = factory.createJavaInterface();
        jInterface2.setInterface(EXPECTED_INTERFACE);
        service2.setInterface((Interface)jInterface2);
        cType.getServices().add(service2);
        Service service3 = factory.createService();
        service3.setName(EXPECTED_SERVICE_NAME);
        JavaInterface jInterface3 = factory.createJavaInterface();
        jInterface3.setInterface("SomeInterface");
        service3.setInterface((Interface)jInterface3);
        cType.getServices().add(service3);
        Service service4 = factory.createService();
        service4.setName(EXPECTED_SERVICE_NAME);
        Interface interface4 = factory.createInterface();
        interface4.setName("SomeInterface");
        service4.setInterface(interface4);
        cType.getServices().add(service4);
        AttributeSet javaInterfaceAttributes = new AttributeSet();
        javaInterfaceAttributes.add(scaPkg.getJavaInterface_Interface(), (Object)EXPECTED_INTERFACE, true);
        AttributeSet serviceAttributes = new AttributeSet();
        serviceAttributes.add(scaPkg.getService_Name(), (Object)EXPECTED_SERVICE_NAME, true);
        StructuralFeatureExpression matchesJavaInterfaceOfType = new StructuralFeatureExpression((EStructuralFeature)scaPkg.getService_Interface(), scaPkg.getJavaInterface(), (EStructuralFeature)scaPkg.getSCACoreRoot_InterfaceJava(), 1);
        matchesJavaInterfaceOfType.addChildQuery((IModelQuery)new AttributesExpression(javaInterfaceAttributes));
        AttributesExpression matchesServiceOfName = new AttributesExpression(serviceAttributes);
        CombinedQuery matchesBoth = new CombinedQuery();
        matchesBoth.addChildQuery((IModelQuery)matchesJavaInterfaceOfType);
        matchesBoth.addChildQuery((IModelQuery)matchesServiceOfName);
        List found = matchesBoth.matches(cType.getServices());
        LightweightParserTests.assertEquals((String)"There should be 1 service found.", (int)1, (int)found.size());
        Object foundObject = found.get(0);
        LightweightParserTests.assertTrue((String)"The type of the object should be Service", (boolean)(foundObject instanceof Service));
        Service foundService = (Service)foundObject;
        LightweightParserTests.assertEquals((String)"The name of the service should be Service1", (String)EXPECTED_SERVICE_NAME, (String)foundService.getName());
        Interface foundInterface = foundService.getInterface();
        LightweightParserTests.assertTrue((String)"The interface should be of type JavaInterface.", (boolean)(foundInterface instanceof JavaInterface));
        JavaInterface foundJavaInterface = (JavaInterface)foundInterface;
        LightweightParserTests.assertEquals((String)"The interface should be org.acme.ITest", (String)EXPECTED_INTERFACE, (String)foundJavaInterface.getInterface());
    }

    public void testQuery_applyDeltaServiceNameAndJavaInterface() throws Exception {
        ComponentType cType = factory.createComponentType();
        Service service1 = factory.createService();
        service1.setName("RenamedService");
        JavaInterface jInterface = factory.createJavaInterface();
        jInterface.setInterface(EXPECTED_INTERFACE);
        service1.setInterface((Interface)jInterface);
        cType.getServices().add(service1);
        Service service3 = factory.createService();
        service3.setName(EXPECTED_SERVICE_NAME);
        JavaInterface jInterface3 = factory.createJavaInterface();
        jInterface3.setInterface("SomeInterface");
        service3.setInterface((Interface)jInterface3);
        cType.getServices().add(service3);
        Service service4 = factory.createService();
        service4.setName(EXPECTED_SERVICE_NAME);
        Interface interface4 = factory.createInterface();
        interface4.setName("SomeInterface");
        service4.setInterface(interface4);
        cType.getServices().add(service4);
        AttributeSet javaInterfaceAttributes = new AttributeSet();
        javaInterfaceAttributes.add(scaPkg.getJavaInterface_Interface(), (Object)EXPECTED_INTERFACE, true);
        AttributeSet serviceAttributes = new AttributeSet();
        serviceAttributes.add(scaPkg.getService_Name(), (Object)EXPECTED_SERVICE_NAME, false);
        StructuralFeatureExpression matchesJavaInterfaceOfType = new StructuralFeatureExpression((EStructuralFeature)scaPkg.getService_Interface(), scaPkg.getJavaInterface(), (EStructuralFeature)scaPkg.getSCACoreRoot_InterfaceJava(), 1);
        matchesJavaInterfaceOfType.addChildQuery((IModelQuery)new AttributesExpression(javaInterfaceAttributes));
        AttributesExpression matchesServiceOfName = new AttributesExpression(serviceAttributes);
        CombinedQuery matchesBoth = new CombinedQuery();
        matchesBoth.addChildQuery((IModelQuery)matchesJavaInterfaceOfType);
        matchesBoth.addChildQuery((IModelQuery)matchesServiceOfName);
        List found = matchesBoth.matches(cType.getServices());
        LightweightParserTests.assertEquals((String)"There should be 1 service found.", (int)1, (int)found.size());
        Object foundObject = found.get(0);
        LightweightParserTests.assertTrue((String)"The type of the object should be Service", (boolean)(foundObject instanceof Service));
        Service foundService = (Service)foundObject;
        LightweightParserTests.assertEquals((String)"The name of the service should be RenamedService", (String)"RenamedService", (String)foundService.getName());
        Interface foundInterface = foundService.getInterface();
        LightweightParserTests.assertTrue((String)"The interface should be of type JavaInterface.", (boolean)(foundInterface instanceof JavaInterface));
        JavaInterface foundJavaInterface = (JavaInterface)foundInterface;
        LightweightParserTests.assertEquals((String)"The interface should be org.acme.ITest", (String)EXPECTED_INTERFACE, (String)foundJavaInterface.getInterface());
        matchesBoth.applyDelta((EObject)found.get(0));
        LightweightParserTests.assertEquals((String)"The name of the service should be Service1", (String)EXPECTED_SERVICE_NAME, (String)foundService.getName());
        foundInterface = foundService.getInterface();
        LightweightParserTests.assertTrue((String)"The interface should be of type JavaInterface.", (boolean)(foundInterface instanceof JavaInterface));
        foundJavaInterface = (JavaInterface)foundInterface;
        LightweightParserTests.assertEquals((String)"The interface should be org.acme.ITest", (String)EXPECTED_INTERFACE, (String)foundJavaInterface.getInterface());
    }
}

