/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.tests.introspection;

import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stp.core.infrastructure.emf.IEditModelFactory;
import org.eclipse.stp.core.infrastructure.emf.IEditModelScribbler;
import org.eclipse.stp.core.infrastructure.emf.IResourceDescriptor;
import org.eclipse.stp.core.infrastructure.emf.IScribblerDomain;
import org.eclipse.stp.core.resources.ComponentTypeScribblerDomain;
import org.eclipse.stp.core.resources.CompositeScribblerDomain;
import org.eclipse.stp.core.resources.GeneralScribblerDomain;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.EntryPoint;
import org.eclipse.stp.core.sca.ExternalService;
import org.eclipse.stp.core.sca.Flags;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.JavaInterface;
import org.eclipse.stp.core.sca.Module;
import org.eclipse.stp.core.sca.ModuleReference;
import org.eclipse.stp.core.sca.ModuleService;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.stp.core.sca.SCABinding;
import org.eclipse.stp.core.sca.SCACoreRoot;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.Service;
import org.eclipse.stp.core.sca.WSDLPortType;
import org.eclipse.stp.core.sca.WebServiceBinding;

public class ModuleComponentTypeIntrospectorTests
extends TestCase {
    private static final String STOCK_QUOTE_WSDL_BINDING = "http://www.stockquote.org/StockQuoteService#wsdl.endpoint(StockQuoteService/StockQuoteServiceSOAP)";
    private static final String NEW_SERVICE4 = "NewService4";
    private static final String STOCK_QUOTE_WSDL_INTF = "http://www.stockquote.org/StockQuoteService#wsdl.interface(StockQuote)";
    private static final String NEW_SERVICE3 = "NewService3";
    private static final String ORG_ACME_NEW_SERVICE2 = "org.acme.NewService2";
    private static final String NEW_SERVICE2 = "NewService2";
    private static final String ORG_ACME_NEW_SERVICE1 = "org.acme.NewService1";
    private static final String NEW_SERVICE1 = "NewService1";
    private static final String ORG_ACME_EXTERNAL_SERVICE5 = "org.acme.ExternalService5";
    private static final String EXTERNAL_SERVICE3 = "ExternalService3";
    private static final String ORG_ACME_EXTERNAL_SERVICE4 = "org.acme.ExternalService4";
    private static final String EXTERNAL_SERVICE2 = "ExternalService2";
    private static final String ORG_ACME_EXTERNAL_SERVICE1 = "org.acme.ExternalService1";
    private static final String EXTERNAL_SERVICE1 = "ExternalService1";
    private static final String ORG_ACME_ENTRY_POINT2 = "org.acme.EntryPoint2";
    private static final String ENTRY_POINT2 = "EntryPoint2";
    private static final String ORG_ACME_ENTRY_POINT1 = "org.acme.EntryPoint1";
    private static final String ENTRY_POINT1 = "EntryPoint1";
    private IProject testProject;

    public ModuleComponentTypeIntrospectorTests(String name) {
        super(name);
    }

    public static TestSuite suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ModuleComponentTypeIntrospectorTests.class);
        return suite;
    }

    protected void setUp() throws Exception {
        this.testProject = ResourcesPlugin.getWorkspace().getRoot().getProject("ModuleComponentTests");
        if (!this.testProject.exists()) {
            this.testProject.create(null);
            this.testProject.open(null);
        }
        URI uri = URI.createPlatformResourceURI((String)(String.valueOf(this.testProject.getName()) + "/sca.module"));
        IEditModelScribbler scribbler = IEditModelFactory.eINSTANCE.createScribblerForWrite(this.testProject, (IScribblerDomain)new GeneralScribblerDomain(this.testProject));
        Resource res = scribbler.getResource(uri);
        SCAFactory factory = SCAFactory.eINSTANCE;
        EntryPoint ep1 = factory.createEntryPoint();
        ep1.setName(ENTRY_POINT1);
        JavaInterface intf1 = factory.createJavaInterface();
        intf1.setInterface(ORG_ACME_ENTRY_POINT1);
        ep1.setInterface((Interface)intf1);
        EntryPoint ep2 = factory.createEntryPoint();
        ep2.setName(ENTRY_POINT2);
        JavaInterface intf2 = factory.createJavaInterface();
        intf2.setInterface(ORG_ACME_ENTRY_POINT2);
        ep2.setInterface((Interface)intf2);
        ExternalService es1 = factory.createExternalService();
        es1.setName(EXTERNAL_SERVICE1);
        JavaInterface intf3 = factory.createJavaInterface();
        intf3.setInterface(ORG_ACME_EXTERNAL_SERVICE1);
        es1.setInterface((Interface)intf3);
        ExternalService es2 = factory.createExternalService();
        es2.setName(EXTERNAL_SERVICE2);
        JavaInterface intf4 = factory.createJavaInterface();
        intf4.setInterface(ORG_ACME_EXTERNAL_SERVICE4);
        es2.setInterface((Interface)intf4);
        ExternalService es3 = factory.createExternalService();
        es3.setName(EXTERNAL_SERVICE3);
        JavaInterface intf5 = factory.createJavaInterface();
        intf5.setInterface(ORG_ACME_EXTERNAL_SERVICE5);
        es3.setInterface((Interface)intf5);
        Module module = factory.createModule();
        module.getEntryPoints().add(ep1);
        module.getEntryPoints().add(ep2);
        module.getExternalServices().add(es1);
        module.getExternalServices().add(es2);
        module.getExternalServices().add(es3);
        SCACoreRoot root = factory.createSCACoreRoot();
        root.setModule(module);
        res.getContents().add((Object)((EObject)root));
        scribbler.save(true, null);
        scribbler.close(null);
    }

    protected void tearDown() throws Exception {
        if (this.testProject.exists()) {
            this.testProject.delete(true, null);
        }
    }

    public void testModuleComponentTypeResolution() throws Exception {
        URI uri = URI.createURI((String)("comptype:/" + this.testProject.getName() + "/sca.module"));
        IEditModelScribbler scribbler = IEditModelFactory.eINSTANCE.createScribblerForRead(this.testProject, (IScribblerDomain)new GeneralScribblerDomain(this.testProject));
        Resource res = scribbler.getResource(uri);
        if (!res.isLoaded()) {
            res.load(Collections.EMPTY_MAP);
        }
        ModuleComponentTypeIntrospectorTests.assertNotNull((Object)res);
        SCACoreRoot root = (SCACoreRoot)res.getContents().get(0);
        ComponentType type = root.getComponentType();
        ModuleComponentTypeIntrospectorTests.assertEquals((String)"There should be 2 services.", (int)2, (int)type.getServices().size());
        List services = type.getServices();
        int i = 0;
        while (i < services.size()) {
            ModuleComponentTypeIntrospectorTests.assertTrue((String)"All created services should be instances of ModuleService.", (boolean)(services.get(i) instanceof ModuleService));
            ModuleService mSvc = (ModuleService)services.get(i);
            if (ENTRY_POINT1.equals(mSvc.getName())) {
                ModuleComponentTypeIntrospectorTests.assertTrue((String)"Only Java Interfaces were created by the test.", (boolean)(mSvc.getInterface() instanceof JavaInterface));
                ModuleComponentTypeIntrospectorTests.assertEquals((String)"The interface should match org.acme.EntryPoint1", (String)ORG_ACME_ENTRY_POINT1, (String)((JavaInterface)mSvc.getInterface()).getInterface());
            } else if (ENTRY_POINT2.equals(mSvc.getName())) {
                ModuleComponentTypeIntrospectorTests.assertTrue((String)"Only Java Interfaces were created by the test.", (boolean)(mSvc.getInterface() instanceof JavaInterface));
                ModuleComponentTypeIntrospectorTests.assertEquals((String)"The interface should match org.acme.EntryPoint2", (String)ORG_ACME_ENTRY_POINT2, (String)((JavaInterface)mSvc.getInterface()).getInterface());
            } else {
                ModuleComponentTypeIntrospectorTests.assertTrue((String)"The reflected module service has an invalid name!", (boolean)false);
            }
            ++i;
        }
        ModuleComponentTypeIntrospectorTests.assertEquals((String)"There should be 3 references.", (int)3, (int)type.getReferences().size());
        List references = type.getReferences();
        int i2 = 0;
        while (i2 < references.size()) {
            ModuleComponentTypeIntrospectorTests.assertTrue((String)"All created references should be instances of ModuleReference.", (boolean)(references.get(i2) instanceof ModuleReference));
            ModuleReference mRef = (ModuleReference)references.get(i2);
            if (EXTERNAL_SERVICE1.equals(mRef.getName())) {
                ModuleComponentTypeIntrospectorTests.assertTrue((String)"Only Java Interfaces were created by the test.", (boolean)(mRef.getInterface() instanceof JavaInterface));
                ModuleComponentTypeIntrospectorTests.assertEquals((String)"The interface should match org.acme.ExternalService1", (String)ORG_ACME_EXTERNAL_SERVICE1, (String)((JavaInterface)mRef.getInterface()).getInterface());
            } else if (EXTERNAL_SERVICE2.equals(mRef.getName())) {
                ModuleComponentTypeIntrospectorTests.assertTrue((String)"Only Java Interfaces were created by the test.", (boolean)(mRef.getInterface() instanceof JavaInterface));
                ModuleComponentTypeIntrospectorTests.assertEquals((String)"The interface should match org.acme.ExternalService4", (String)ORG_ACME_EXTERNAL_SERVICE4, (String)((JavaInterface)mRef.getInterface()).getInterface());
            } else if (EXTERNAL_SERVICE3.equals(mRef.getName())) {
                ModuleComponentTypeIntrospectorTests.assertTrue((String)"Only Java Interfaces were created by the test.", (boolean)(mRef.getInterface() instanceof JavaInterface));
                ModuleComponentTypeIntrospectorTests.assertEquals((String)"The interface should match org.acme.ExternalService5", (String)ORG_ACME_EXTERNAL_SERVICE5, (String)((JavaInterface)mRef.getInterface()).getInterface());
            } else {
                ModuleComponentTypeIntrospectorTests.assertTrue((String)"The reflected module reference has an invalid name!", (boolean)false);
            }
            ++i2;
        }
        scribbler.close(null);
    }

    public void testModuleComponentTypeServiceCreationRemoval() throws Exception {
        Resource moduleResource;
        ComponentTypeScribblerDomain componentTypeScribblerDomain = new ComponentTypeScribblerDomain(this.testProject.getFile("sca.module"));
        IEditModelScribbler componentTypeScribbler = IEditModelFactory.eINSTANCE.createScribblerForWrite(this.testProject, (IScribblerDomain)componentTypeScribblerDomain);
        CompositeScribblerDomain moduleScribblerDomain = new CompositeScribblerDomain(this.testProject.getFile("sca.module"));
        IEditModelScribbler moduleScribbler = IEditModelFactory.eINSTANCE.createScribblerForWrite(this.testProject, (IScribblerDomain)moduleScribblerDomain);
        Resource compTypeResource = componentTypeScribbler.getResource((IResourceDescriptor)componentTypeScribblerDomain.getComponentTypeDescriptor());
        if (!compTypeResource.isLoaded()) {
            compTypeResource.load(Collections.EMPTY_MAP);
        }
        if (!(moduleResource = moduleScribbler.getResource(moduleScribblerDomain.getCompositeDescriptor())).isLoaded()) {
            moduleResource.load(Collections.EMPTY_MAP);
        }
        SCACoreRoot moduleCoreRoot = (SCACoreRoot)moduleResource.getContents().get(0);
        Module module = moduleCoreRoot.getModule();
        int originalSize = module.getEntryPoints().size();
        ModuleComponentTypeIntrospectorTests.assertNotNull((Object)compTypeResource);
        SCACoreRoot root = (SCACoreRoot)compTypeResource.getContents().get(0);
        ComponentType type = root.getComponentType();
        SCAFactory factory = SCAFactory.eINSTANCE;
        ModuleService newService1 = factory.createModuleService();
        newService1.setName(NEW_SERVICE1);
        JavaInterface intf1 = factory.createJavaInterface();
        intf1.setInterface(ORG_ACME_NEW_SERVICE1);
        newService1.setInterface((Interface)intf1);
        type.getServices().add(newService1);
        ModuleComponentTypeIntrospectorTests.assertEquals((String)"The module should have a new EntryPoint.", (int)(originalSize + 1), (int)module.getEntryPoints().size());
        List entryPoints = module.getEntryPoints();
        boolean found = false;
        int i = 0;
        while (i < entryPoints.size()) {
            EntryPoint entryPoint = (EntryPoint)entryPoints.get(i);
            if (NEW_SERVICE1.equals(entryPoint.getName())) {
                ModuleComponentTypeIntrospectorTests.assertTrue((String)"Only Java Interfaces were created by the test.", (boolean)(entryPoint.getInterface() instanceof JavaInterface));
                ModuleComponentTypeIntrospectorTests.assertEquals((String)"The interface should match org.acme.NewService1", (String)ORG_ACME_NEW_SERVICE1, (String)((JavaInterface)entryPoint.getInterface()).getInterface());
                found = true;
            }
            ++i;
        }
        ModuleComponentTypeIntrospectorTests.assertTrue((boolean)found);
        Service oldService1 = type.getService(ENTRY_POINT1);
        type.getServices().remove(oldService1);
        Service oldService2 = type.getService(ENTRY_POINT2);
        type.getServices().remove(oldService2);
        int i2 = 0;
        while (i2 < entryPoints.size()) {
            EntryPoint entryPoint = (EntryPoint)entryPoints.get(i2);
            if (ENTRY_POINT1.equals(entryPoint.getName())) {
                ModuleComponentTypeIntrospectorTests.assertTrue((String)"The entrypoint for EntryPoint1 should not be in the list", (boolean)false);
            } else if (ENTRY_POINT2.equals(entryPoint.getName())) {
                ModuleComponentTypeIntrospectorTests.assertTrue((String)"The entrypoint for EntryPoint2 should not be in the list", (boolean)false);
            }
            ++i2;
        }
        Service newService2 = factory.createService();
        newService2.setName(NEW_SERVICE2);
        JavaInterface intf2 = factory.createJavaInterface();
        intf2.setInterface(ORG_ACME_NEW_SERVICE2);
        newService2.setInterface((Interface)intf2);
        ModuleComponentTypeIntrospectorTests.assertTrue((String)"Plain services should not be bindable.", (!Flags.isBindableElement((int)newService2.getFlags()) ? 1 : 0) != 0);
        ModuleService newService3 = factory.createModuleService();
        newService3.setName(NEW_SERVICE3);
        WSDLPortType intf3 = factory.createWSDLPortType();
        intf3.setInterface(STOCK_QUOTE_WSDL_INTF);
        newService3.setInterface((Interface)intf3);
        ModuleComponentTypeIntrospectorTests.assertTrue((String)"ModuleServices should be bindable.", (boolean)Flags.isBindableElement((int)newService3.getFlags()));
        ModuleService newService4 = factory.createModuleService();
        EntryPoint newEntryPoint4 = factory.createEntryPoint();
        newEntryPoint4.setName(NEW_SERVICE4);
        WSDLPortType intf4 = factory.createWSDLPortType();
        intf4.setInterface(STOCK_QUOTE_WSDL_INTF);
        newEntryPoint4.setInterface((Interface)intf4);
        WebServiceBinding newBinding = factory.createWebServiceBinding();
        newBinding.setPort(STOCK_QUOTE_WSDL_BINDING);
        newEntryPoint4.getBindings().add(newBinding);
        newService4.setEntryPoint(newEntryPoint4);
        ModuleComponentTypeIntrospectorTests.assertTrue((String)"ModuleServices should be bindable.", (boolean)Flags.isBindableElement((int)newService4.getFlags()));
        type.getServices().add(newService2);
        type.getServices().add(newService3);
        type.getServices().add(newService4);
        boolean foundNewService2 = false;
        boolean foundNewService3 = false;
        boolean foundNewService4 = false;
        int i3 = 0;
        while (i3 < entryPoints.size()) {
            EntryPoint entryPoint = (EntryPoint)entryPoints.get(i3);
            if (NEW_SERVICE2.equals(entryPoint.getName())) {
                ModuleComponentTypeIntrospectorTests.assertTrue((String)"Only Java Interfaces were created by the test.", (boolean)(entryPoint.getInterface() instanceof JavaInterface));
                ModuleComponentTypeIntrospectorTests.assertEquals((String)"The interface should match org.acme.NewService2", (String)ORG_ACME_NEW_SERVICE2, (String)((JavaInterface)entryPoint.getInterface()).getInterface());
                foundNewService2 = true;
            } else if (NEW_SERVICE3.equals(entryPoint.getName())) {
                ModuleComponentTypeIntrospectorTests.assertTrue((String)"New Service 3 has a WSDLPortType.", (boolean)(entryPoint.getInterface() instanceof WSDLPortType));
                ModuleComponentTypeIntrospectorTests.assertEquals((String)"The interface should match http://www.stockquote.org/StockQuoteService#wsdl.interface(StockQuote)", (String)STOCK_QUOTE_WSDL_INTF, (String)((WSDLPortType)entryPoint.getInterface()).getInterface());
                foundNewService3 = true;
            } else if (NEW_SERVICE4.equals(entryPoint.getName())) {
                ModuleComponentTypeIntrospectorTests.assertTrue((String)"New Service 4 has a WSDLPortType.", (boolean)(entryPoint.getInterface() instanceof WSDLPortType));
                ModuleComponentTypeIntrospectorTests.assertEquals((String)"The interface should match http://www.stockquote.org/StockQuoteService#wsdl.interface(StockQuote)", (String)STOCK_QUOTE_WSDL_INTF, (String)((WSDLPortType)entryPoint.getInterface()).getInterface());
                ModuleComponentTypeIntrospectorTests.assertTrue((String)"New Service 4 has a Web Service Binding.", (entryPoint.getBindings().size() == 1 ? 1 : 0) != 0);
                ModuleComponentTypeIntrospectorTests.assertTrue((String)"New Service 4 has a Web Service Binding.", (boolean)(entryPoint.getBindings().get(0) instanceof WebServiceBinding));
                ModuleComponentTypeIntrospectorTests.assertEquals((String)"The binding should match http://www.stockquote.org/StockQuoteService#wsdl.endpoint(StockQuoteService/StockQuoteServiceSOAP)", (String)STOCK_QUOTE_WSDL_BINDING, (String)((WebServiceBinding)entryPoint.getBindings().get(0)).getPort());
                foundNewService4 = true;
            }
            ++i3;
        }
        ModuleComponentTypeIntrospectorTests.assertTrue((boolean)foundNewService2);
        ModuleComponentTypeIntrospectorTests.assertTrue((boolean)foundNewService3);
        ModuleComponentTypeIntrospectorTests.assertTrue((boolean)foundNewService4);
        ModuleComponentTypeIntrospectorTests.assertTrue((String)"The component type scribbler should be dirty.", (boolean)componentTypeScribbler.isDirty());
        ModuleComponentTypeIntrospectorTests.assertTrue((String)"The module scribbler should be dirty.", (boolean)moduleScribbler.isDirty());
        componentTypeScribbler.save(true, null);
        ModuleComponentTypeIntrospectorTests.assertTrue((String)"The component type scribbler should NOT be dirty.", (!componentTypeScribbler.isDirty() ? 1 : 0) != 0);
        ModuleComponentTypeIntrospectorTests.assertTrue((String)"The module scribbler's resource should have been saved with the update to the component type.", (!moduleScribbler.isDirty() ? 1 : 0) != 0);
        componentTypeScribbler.close(null);
        moduleScribbler.close(null);
    }

    public void testModuleComponentTypeReferenceCreationRemoval() throws Exception {
        Resource moduleResource;
        ComponentTypeScribblerDomain componentTypeScribblerDomain = new ComponentTypeScribblerDomain(this.testProject.getFile("sca.module"));
        IEditModelScribbler componentTypeScribbler = IEditModelFactory.eINSTANCE.createScribblerForWrite(this.testProject, (IScribblerDomain)componentTypeScribblerDomain);
        CompositeScribblerDomain moduleScribblerDomain = new CompositeScribblerDomain(this.testProject.getFile("sca.module"));
        IEditModelScribbler moduleScribbler = IEditModelFactory.eINSTANCE.createScribblerForWrite(this.testProject, (IScribblerDomain)moduleScribblerDomain);
        Resource compTypeResource = componentTypeScribbler.getResource((IResourceDescriptor)componentTypeScribblerDomain.getComponentTypeDescriptor());
        if (!compTypeResource.isLoaded()) {
            compTypeResource.load(Collections.EMPTY_MAP);
        }
        if (!(moduleResource = moduleScribbler.getResource(moduleScribblerDomain.getCompositeDescriptor())).isLoaded()) {
            moduleResource.load(Collections.EMPTY_MAP);
        }
        SCACoreRoot moduleCoreRoot = (SCACoreRoot)moduleResource.getContents().get(0);
        Module module = moduleCoreRoot.getModule();
        int originalSize = module.getExternalServices().size();
        ModuleComponentTypeIntrospectorTests.assertNotNull((Object)compTypeResource);
        SCACoreRoot root = (SCACoreRoot)compTypeResource.getContents().get(0);
        ComponentType type = root.getComponentType();
        SCAFactory factory = SCAFactory.eINSTANCE;
        ModuleReference newReference1 = factory.createModuleReference();
        newReference1.setName(NEW_SERVICE1);
        JavaInterface intf1 = factory.createJavaInterface();
        intf1.setInterface(ORG_ACME_NEW_SERVICE1);
        newReference1.setInterface((Interface)intf1);
        type.getReferences().add(newReference1);
        ModuleComponentTypeIntrospectorTests.assertEquals((String)"The module should have a new ExternalService.", (int)(originalSize + 1), (int)module.getExternalServices().size());
        List externalServices = module.getExternalServices();
        boolean found = false;
        int i = 0;
        while (i < externalServices.size()) {
            ExternalService externalService = (ExternalService)externalServices.get(i);
            if (NEW_SERVICE1.equals(externalService.getName())) {
                ModuleComponentTypeIntrospectorTests.assertTrue((String)"Only Java Interfaces were created by the test.", (boolean)(externalService.getInterface() instanceof JavaInterface));
                ModuleComponentTypeIntrospectorTests.assertEquals((String)"The interface should match org.acme.NewService1", (String)ORG_ACME_NEW_SERVICE1, (String)((JavaInterface)externalService.getInterface()).getInterface());
                found = true;
            }
            ++i;
        }
        ModuleComponentTypeIntrospectorTests.assertTrue((boolean)found);
        Reference oldReference1 = type.getReference(EXTERNAL_SERVICE1);
        type.getReferences().remove(oldReference1);
        Reference oldReference2 = type.getReference(EXTERNAL_SERVICE2);
        type.getReferences().remove(oldReference2);
        int i2 = 0;
        while (i2 < externalServices.size()) {
            ExternalService externalService = (ExternalService)externalServices.get(i2);
            if (EXTERNAL_SERVICE1.equals(externalService.getName())) {
                ModuleComponentTypeIntrospectorTests.assertTrue((String)"The entrypoint for ExternalService1 should not be in the list", (boolean)false);
            } else if (EXTERNAL_SERVICE2.equals(externalService.getName())) {
                ModuleComponentTypeIntrospectorTests.assertTrue((String)"The entrypoint for ExternalService2 should not be in the list", (boolean)false);
            }
            ++i2;
        }
        Reference newReference2 = factory.createReference();
        newReference2.setName(NEW_SERVICE2);
        JavaInterface intf2 = factory.createJavaInterface();
        intf2.setInterface(ORG_ACME_NEW_SERVICE2);
        newReference2.setInterface((Interface)intf2);
        ModuleReference newReference3 = factory.createModuleReference();
        newReference3.setName(NEW_SERVICE3);
        WSDLPortType intf3 = factory.createWSDLPortType();
        intf3.setInterface(STOCK_QUOTE_WSDL_INTF);
        newReference3.setInterface((Interface)intf3);
        ModuleReference newReference4 = factory.createModuleReference();
        ExternalService newExternalService4 = factory.createExternalService();
        newExternalService4.setName(NEW_SERVICE4);
        WSDLPortType intf4 = factory.createWSDLPortType();
        intf4.setInterface(STOCK_QUOTE_WSDL_INTF);
        newExternalService4.setInterface((Interface)intf4);
        SCABinding newBinding4 = factory.createSCABinding();
        newExternalService4.getBindings().add(newBinding4);
        newReference4.setExternalService(newExternalService4);
        type.getReferences().add(newReference2);
        type.getReferences().add(newReference3);
        type.getReferences().add(newReference4);
        boolean foundNewReference2 = false;
        boolean foundNewReference3 = false;
        boolean foundNewReference4 = false;
        int i3 = 0;
        while (i3 < externalServices.size()) {
            ExternalService externalService = (ExternalService)externalServices.get(i3);
            if (NEW_SERVICE2.equals(externalService.getName())) {
                ModuleComponentTypeIntrospectorTests.assertTrue((String)"Only Java Interfaces were created by the test.", (boolean)(externalService.getInterface() instanceof JavaInterface));
                ModuleComponentTypeIntrospectorTests.assertEquals((String)"The interface should match org.acme.NewService2", (String)ORG_ACME_NEW_SERVICE2, (String)((JavaInterface)externalService.getInterface()).getInterface());
                foundNewReference2 = true;
            } else if (NEW_SERVICE3.equals(externalService.getName())) {
                ModuleComponentTypeIntrospectorTests.assertTrue((String)"New Service 3 has a WSDLPortType.", (boolean)(externalService.getInterface() instanceof WSDLPortType));
                ModuleComponentTypeIntrospectorTests.assertEquals((String)"The interface should match http://www.stockquote.org/StockQuoteService#wsdl.interface(StockQuote)", (String)STOCK_QUOTE_WSDL_INTF, (String)((WSDLPortType)externalService.getInterface()).getInterface());
                foundNewReference3 = true;
            } else if (NEW_SERVICE4.equals(externalService.getName())) {
                ModuleComponentTypeIntrospectorTests.assertTrue((String)"New Service 4 has a WSDLPortType.", (boolean)(externalService.getInterface() instanceof WSDLPortType));
                ModuleComponentTypeIntrospectorTests.assertEquals((String)"The interface should match http://www.stockquote.org/StockQuoteService#wsdl.interface(StockQuote)", (String)STOCK_QUOTE_WSDL_INTF, (String)((WSDLPortType)externalService.getInterface()).getInterface());
                ModuleComponentTypeIntrospectorTests.assertTrue((String)"New Service 4 has an SCA Binding.", (externalService.getBindings().size() == 1 ? 1 : 0) != 0);
                ModuleComponentTypeIntrospectorTests.assertTrue((String)"New Service 4 has an SCA Binding.", (boolean)(externalService.getBindings().get(0) instanceof SCABinding));
                foundNewReference4 = true;
            }
            ++i3;
        }
        ModuleComponentTypeIntrospectorTests.assertTrue((boolean)foundNewReference2);
        ModuleComponentTypeIntrospectorTests.assertTrue((boolean)foundNewReference3);
        ModuleComponentTypeIntrospectorTests.assertTrue((boolean)foundNewReference4);
        ModuleComponentTypeIntrospectorTests.assertTrue((String)"The component type scribbler should be dirty.", (boolean)componentTypeScribbler.isDirty());
        ModuleComponentTypeIntrospectorTests.assertTrue((String)"The module scribbler should be dirty.", (boolean)moduleScribbler.isDirty());
        componentTypeScribbler.save(true, null);
        ModuleComponentTypeIntrospectorTests.assertTrue((String)"The component type scribbler should NOT be dirty.", (!componentTypeScribbler.isDirty() ? 1 : 0) != 0);
        ModuleComponentTypeIntrospectorTests.assertTrue((String)"The module scribbler's resource should have been saved with the update to the component type.", (!moduleScribbler.isDirty() ? 1 : 0) != 0);
        componentTypeScribbler.close(null);
        moduleScribbler.close(null);
    }
}

