/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.tests.model;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Implementation;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.JavaInterface;
import org.eclipse.stp.core.sca.Module;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.stp.core.sca.SCACoreRoot;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.sca.Service;
import org.eclipse.stp.core.sca.impl.ImplementationComponentImpl;
import org.eclipse.stp.core.tests.util.AssertionSAXHandler;
import org.eclipse.stp.core.tests.util.XMLAssertions;

public class ComponentTests
extends TestCase {
    private static final String PROJECT_NAME = "COmponentTests";
    private IProject project;

    public ComponentTests() {
    }

    public ComponentTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        this.project.create((IProgressMonitor)new NullProgressMonitor());
        this.project.open((IProgressMonitor)new NullProgressMonitor());
    }

    protected void tearDown() throws Exception {
        this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
    }

    public void testAbstractImplementation() throws Exception {
        URI uri = URI.createPlatformResourceURI((String)"COmponentTests/sca.module");
        Resource res = WorkbenchResourceHelperBase.createResource((URI)uri);
        SCAFactory fact = SCAFactory.eINSTANCE;
        SCACoreRoot root = fact.createSCACoreRoot();
        res.getContents().add((Object)((EObject)root));
        Module mod = fact.createModule();
        mod.setName("TestModule");
        root.setModule(mod);
        Component c1 = fact.createComponent();
        c1.setName("c1");
        mod.getComponents().add(c1);
        ComponentType type = fact.createComponentType();
        Service s1 = fact.createService();
        s1.setName("s1");
        type.getServices().add(s1);
        JavaInterface jInt = fact.createJavaInterface();
        jInt.setInterface("com.ibm.acme.TestMe");
        s1.setInterface((Interface)jInt);
        Reference r1 = fact.createReference();
        r1.setName("r1");
        type.getReferences().add(r1);
        jInt = fact.createJavaInterface();
        jInt.setInterface("com.ibm.acme.TestMe2");
        r1.setInterface((Interface)jInt);
        ComponentTests.assertNull((Object)c1.resolveComponentType());
        c1.setAbstractImplementation(type);
        ComponentTests.assertEquals((String)"The state should be abstract", (int)1, (int)c1.getState());
        ComponentTests.assertEquals((String)"The type should be implementation.abstract", (String)"implementation.abstract", (String)c1.getType());
        ComponentType testCompType = c1.resolveComponentType();
        ComponentTests.assertTrue((testCompType == type ? 1 : 0) != 0);
        res.save(null);
        res.unload();
        XMLAssertions xmlAssert = AssertionSAXHandler.parseFile(res, true);
        xmlAssert.assertNoXSITypeAttributes();
        mod = null;
        c1 = null;
        type = null;
        s1 = null;
        r1 = null;
        res.load(null);
        ComponentTests.assertTrue((res.getContents().size() == 1 ? 1 : 0) != 0);
        root = (SCACoreRoot)res.getContents().get(0);
        mod = root.getModule();
        ComponentTests.assertNotNull((Object)mod);
        ComponentTests.assertTrue((mod.getComponents().size() == 1 ? 1 : 0) != 0);
        c1 = mod.getComponent("c1");
        ComponentTests.assertNotNull((Object)c1);
        EStructuralFeature sf = ((ImplementationComponentImpl)c1).getImplementationGroup().getEStructuralFeature(0);
        ComponentTests.assertTrue((boolean)sf.equals(SCAPackage.eINSTANCE.getSCACoreRoot_ImplementationAbstract()));
        ComponentTests.assertEquals((String)"implementation.abstract", (String)ExtendedMetaData.INSTANCE.getName(sf));
        Implementation implementation = (Implementation)((ImplementationComponentImpl)c1).getImplementationGroup().getValue(0);
        FeatureMap map = (FeatureMap)implementation.getEObject().eContainer().eGet(implementation.getEObject().eContainingFeature());
        sf = map.getEStructuralFeature(0);
        ComponentTests.assertTrue((boolean)sf.equals(SCAPackage.eINSTANCE.getSCACoreRoot_ImplementationAbstract()));
        ComponentTests.assertEquals((String)"implementation.abstract", (String)ExtendedMetaData.INSTANCE.getName(sf));
        type = c1.resolveComponentType();
        ComponentTests.assertNotNull((Object)type);
        ComponentTests.assertTrue((type.getServices().size() == 1 ? 1 : 0) != 0);
        ComponentTests.assertTrue((type.getReferences().size() == 1 ? 1 : 0) != 0);
        s1 = type.getService("s1");
        ComponentTests.assertNotNull((Object)s1);
        Interface interfaze = s1.getInterface();
        ComponentTests.assertTrue((boolean)(interfaze instanceof JavaInterface));
        ComponentTests.assertEquals((String)"com.ibm.acme.TestMe", (String)((JavaInterface)interfaze).getInterface());
        r1 = type.getReference("r1");
        ComponentTests.assertNotNull((Object)r1);
        interfaze = r1.getInterface();
        ComponentTests.assertTrue((boolean)(interfaze instanceof JavaInterface));
        ComponentTests.assertEquals((String)"com.ibm.acme.TestMe2", (String)((JavaInterface)interfaze).getInterface());
    }
}

