/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.tests.resources;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stp.core.infrastructure.emf.EditModelException;
import org.eclipse.stp.core.infrastructure.emf.IEditModelFactory;
import org.eclipse.stp.core.infrastructure.emf.IEditModelScribbler;
import org.eclipse.stp.core.infrastructure.emf.IScribblerDomain;
import org.eclipse.stp.core.resources.GeneralScribblerDomain;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.SCACoreRoot;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.SCAObject;
import org.eclipse.stp.core.sca.util.ModelFileIndex;
import org.eclipse.stp.core.sca.util.ModelFileIndexer;

public class ModelFileIndexerTests
extends TestCase {
    private IProject indexProject = null;
    private static final String[] componentTypeNames = new String[]{"ctype1.componentType", "ctype2.componentType", "ctype3.componentType"};

    protected void setUp() throws Exception {
        super.setUp();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.indexProject = root.getProject("TestIndexProject");
        if (!this.indexProject.isAccessible()) {
            this.indexProject.create(null);
            this.indexProject.open(null);
        }
        GeneralScribblerDomain domain = new GeneralScribblerDomain(this.indexProject);
        IEditModelScribbler scribbler = IEditModelFactory.eINSTANCE.createScribblerForWrite(this.indexProject, (IScribblerDomain)domain);
        this.setupComponentTypes(this.indexProject, scribbler);
        scribbler.close(null);
    }

    protected void tearDown() throws Exception {
    }

    private void setupComponentTypes(IProject project, IEditModelScribbler scribbler) throws EditModelException {
        IFile ctypeFile = null;
        Resource ctypeResource = null;
        int i = 0;
        while (i < componentTypeNames.length) {
            ctypeFile = project.getFile(componentTypeNames[i]);
            ctypeResource = scribbler.getResource(ctypeFile.getFullPath());
            SCACoreRoot root = SCAFactory.eINSTANCE.createSCACoreRoot();
            ComponentType ctype = SCAFactory.eINSTANCE.createComponentType();
            ctype.setName(componentTypeNames[i].substring(0, componentTypeNames[i].length() - ".componentType".length()));
            root.setComponentType(ctype);
            ctypeResource.getContents().add((Object)((EObject)root));
            ++i;
        }
        scribbler.save(true, null);
    }

    public void testIndexer() {
        ModelFileIndex index = ModelFileIndexer.getInstance().getModelIndex(this.indexProject);
        SCAObject[] models = index.getModelObjects();
        ModelFileIndexerTests.assertEquals((int)3, (int)models.length);
    }
}

