/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.cxf;

import java.util.StringTokenizer;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.cxf.TestUtilities;

public abstract class CXFProjectBaseTest
extends TestCase {
    protected static final String JAVA_FILE_NAME = "GreeterRPCLit.java";
    private static final LoggingProxy LOG = LoggingProxy.getlogger(CXFProjectBaseTest.class);
    protected IProject project;
    protected IFile[] files;

    protected abstract String getProjectName();

    protected abstract String[] getProjectFiles();

    protected abstract String[] getResourceFiles();

    protected void setUp() throws Exception {
        try {
            this.project = TestUtilities.createTestCeltixProject(this.getProjectName());
            TestUtilities.setupCeltixProject(this.project);
            this.setupTestFiles();
        }
        catch (Throwable th) {
            LOG.error((Object)"", th);
        }
    }

    private void setupTestFiles() throws Exception {
        String[] projectFiles = this.getProjectFiles();
        String[] resourceFiles = this.getResourceFiles();
        this.files = new IFile[projectFiles.length];
        int i = 0;
        while (i < projectFiles.length) {
            IFile f = this.project.getFile(projectFiles[i]);
            if (!f.exists()) {
                this.checkFolder(projectFiles[i]);
                this.project.refreshLocal(0, null);
                TestUtilities.addFileResourceToTestProject(this.project, projectFiles[i], ((Object)((Object)this)).getClass(), resourceFiles[i]);
            }
            this.files[i] = f;
            ++i;
        }
    }

    private void checkFolder(String path) throws CoreException {
        StringTokenizer token = new StringTokenizer(path, "/");
        int numOfToken = token.countTokens();
        if (numOfToken <= 1) {
            return;
        }
        IFolder folder = null;
        int i = 0;
        while (i < numOfToken - 1) {
            String onePath = (String)token.nextElement();
            IFolder childFolder = folder == null ? this.project.getFolder(onePath) : folder.getFolder(onePath);
            if (!childFolder.exists()) {
                childFolder.create(true, false, null);
            }
            folder = childFolder;
            ++i;
        }
    }

    protected void tearDown() throws Exception {
        try {
            this.project.delete(true, null);
        }
        catch (Exception e) {
            LOG.error((Object)"", (Throwable)e);
        }
    }
}

