/*******************************************************************************
 * Copyright (c) 2006 IONA Technologies PLC
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies PLC - initial API and implementation
 *******************************************************************************/

package org.eclipse.stp.sc.annvalidator.builder;

import java.util.ArrayList;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.annvalidator.anntree.AnnXMLTreeBuilder;
import org.eclipse.stp.sc.annvalidator.filter.IAnnFileFilter;
import org.eclipse.stp.sc.common.utils.ExtensionRegUtils;
import org.eclipse.stp.sc.xmlvalidator.builder.XmlValidator;
import org.w3c.dom.Document;

/**
 * @author jma This class is a builder, extends from XmlValidator. It will look
 *         up all annotations in java source code, generate a dom tree from
 *         those, and pass to XmlValidator to do the rule validation
 */
public class AnnValidator extends XmlValidator {

	
	
	
	public static String BUILDER_ID = "org.eclipse.stp.sc.annvalidator";

	public static String MARKER_ID = "marker";
	
	private static final LoggingProxy LOG = LoggingProxy
	.getlogger(AnnValidator.class);
	
	private static String EXT_POINT_FILTER = "org.eclipse.stp.sc.annvalidator.validatorFilter";
	private static String EXT_CFG_FILTER = "validatorFilter";
	private static String EXT_CFG_FILTER_CLASS = "class";

	AnnXMLTreeBuilder treeBuilder = null;
	ArrayList<IAnnFileFilter> filters = null; 

	public AnnValidator() {
		super();
		treeBuilder = new AnnXMLTreeBuilder();
		loadFilters(); 
	}

	
	
	
	
	/**
	 * load all filters from extension point
	 */
	private void loadFilters() {
		filters = new ArrayList<IAnnFileFilter>();
		try {
			IExtensionPoint extPoint = ExtensionRegUtils
					.getExtensionPoint(EXT_POINT_FILTER);
			IExtension[] exts = extPoint.getExtensions();
			for (IExtension ext : exts) {
				IConfigurationElement cfg = ExtensionRegUtils.getConfigElem(
						ext, EXT_CFG_FILTER, null, null);
				LOG.debug("load ann filter class:" + cfg.getAttribute(EXT_CFG_FILTER_CLASS));
				filters.add((IAnnFileFilter) cfg
						.createExecutableExtension(EXT_CFG_FILTER_CLASS));
			}
		} catch (Exception e) {
			LOG.error("error during load ann filter", e);
		}

	}
	

	protected boolean needToValidate(IFile xmlFile) {
		for (IAnnFileFilter filter : filters) {
			if (filter.needsToValidate(xmlFile)) {
				LOG.debug("need to validate file passed filter:" + xmlFile.getName());
				return true;
			}
		}
		return false;
		
	}

	protected Document loadXMLFile(IFile xmlFile) {
		return treeBuilder.loadXMLFile(xmlFile);
	}
}
