/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.common.actions;

import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.workspace.AbstractNature;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;


public class EnableNatureAbstractAction implements IWorkbenchWindowActionDelegate {

    private static final LoggingProxy LOG = LoggingProxy.getlogger(EnableNatureAbstractAction.class);

    private ISelection selection;

    protected AbstractNature nature;
    
    protected EnableNatureAbstractAction() {
    }
    
    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }

        Iterator iter = ((IStructuredSelection)selection).iterator();

        while (iter.hasNext()) {
            Object element = iter.next();

            if (element instanceof IProject) {
                try {
                	nature.addToProject((IProject)element);
                } catch (CoreException ce) {
                    LOG.error("error while enabling the SC nature", ce);
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection sel) {
        this.selection = sel;
    }
}
