/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.utils;

import java.util.ArrayList;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.stp.sc.common.annotations.ScAnnotationSupportUtils;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.jaxws.tests.ScProjectBaseTest;

public class JaxWsAnnotationUtilsTest
extends ScProjectBaseTest {
    private static final String PROJECT_NAME = "JaxWsAnnotationUtilsTestProject";
    protected String[] projectFiles = new String[]{"/src/org/objectweb/hello_world_soap_http/Greeter.java", "/src/demo/GreeterRPCLit.java"};
    protected String[] resourceFiles = new String[]{"/resources/GreeterWrap.java_resource", "/resources/GreeterRPCLit.java_resource"};
    private CompilationUnit astRoot = null;
    private IMember jdtTypeElement;
    private IMember jdtMethodElement;

    protected String getProjectName() {
        return PROJECT_NAME;
    }

    protected String[] getProjectFiles() {
        return this.projectFiles;
    }

    protected String[] getResourceFiles() {
        return this.resourceFiles;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.jdtTypeElement = (IMember)JDTUtils.getJavaUnitFromFile((IFile)this.files[0]).getElementAt(711);
        this.jdtMethodElement = (IMember)JDTUtils.getJavaUnitFromFile((IFile)this.files[0]).getElementAt(1814);
        this.astRoot = JDTUtils.getDomRootCompilationUnit((IMember)this.jdtTypeElement);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetAnnotationImport() throws Exception {
        ArrayList<MemberValuePair> annotValues3 = new ArrayList<MemberValuePair>();
        MemberValuePair valPair3 = JDTUtils.newMemberValuePair((CompilationUnit)this.astRoot, (String)"name", (Object)"namevalue");
        annotValues3.add(valPair3);
        NormalAnnotation annotation = JDTUtils.newNormalAnnotation((CompilationUnit)this.astRoot, (String)XmlRootElement.class.getSimpleName(), annotValues3);
        JaxWsAnnotationUtilsTest.assertNull((Object)ScAnnotationSupportUtils.getAnnotationImport((Annotation)annotation));
        ArrayList<MemberValuePair> annotValues2 = new ArrayList<MemberValuePair>();
        MemberValuePair valPair2 = JDTUtils.newMemberValuePair((CompilationUnit)this.astRoot, (String)"name", (Object)"namevalue");
        annotValues2.add(valPair2);
        NormalAnnotation webMethodAnn = JDTUtils.newNormalAnnotation((CompilationUnit)this.astRoot, (String)WebMethod.class.getSimpleName(), annotValues2);
        JaxWsAnnotationUtilsTest.assertEquals((String)"javax.jws.WebMethod", (String)ScAnnotationSupportUtils.getAnnotationImport((Annotation)webMethodAnn));
    }

    public void testGetAvailableAnnotationsForMethod() throws Exception {
        JaxWsAnnotationUtilsTest.assertEquals((int)9, (int)ScAnnotationSupportUtils.getAvailableAnnotationsForMethod((IProject)this.project).size());
    }

    public void testGetAvailableAnnotationsForParam() throws Exception {
        JaxWsAnnotationUtilsTest.assertEquals((int)1, (int)ScAnnotationSupportUtils.getAvailableAnnotationsForParam((IProject)this.project).size());
    }

    public void testGetAvailableAnnotationsForType() throws Exception {
        JaxWsAnnotationUtilsTest.assertEquals((int)10, (int)ScAnnotationSupportUtils.getAvailableAnnotationsForClass((IProject)this.project).size());
    }

    public void testNewOneWayAnnotation() throws Exception {
        Annotation annotation = ScAnnotationSupportUtils.getDefaultedAnnotationNode(Oneway.class, (CompilationUnit)this.astRoot, null, null);
        JaxWsAnnotationUtilsTest.assertNull((Object)annotation);
        annotation = ScAnnotationSupportUtils.getDefaultedAnnotationNode(Oneway.class, (CompilationUnit)this.astRoot, (IMember)this.jdtTypeElement, null);
        JaxWsAnnotationUtilsTest.assertNull((Object)annotation);
        annotation = ScAnnotationSupportUtils.getDefaultedAnnotationNode(Oneway.class, (CompilationUnit)this.astRoot, (IMember)this.jdtMethodElement, null);
        JaxWsAnnotationUtilsTest.assertNotNull((Object)annotation);
        JaxWsAnnotationUtilsTest.assertEquals((String)"Oneway", (String)annotation.getTypeName().getFullyQualifiedName());
    }

    public void testNewWebMethodAnnotion() throws Exception {
        Annotation annotation = ScAnnotationSupportUtils.getDefaultedAnnotationNode(WebMethod.class, (CompilationUnit)this.astRoot, null, null);
        JaxWsAnnotationUtilsTest.assertNull((Object)annotation);
        annotation = ScAnnotationSupportUtils.getDefaultedAnnotationNode(WebMethod.class, (CompilationUnit)this.astRoot, (IMember)this.jdtTypeElement, null);
        JaxWsAnnotationUtilsTest.assertNull((Object)annotation);
        annotation = ScAnnotationSupportUtils.getDefaultedAnnotationNode(WebMethod.class, (CompilationUnit)this.astRoot, (IMember)this.jdtMethodElement, null);
        JaxWsAnnotationUtilsTest.assertNotNull((Object)annotation);
        JaxWsAnnotationUtilsTest.assertEquals((String)"WebMethod", (String)annotation.getTypeName().getFullyQualifiedName());
    }

    public void testNewWebResultAnnotation() throws Exception {
        Annotation annotation = ScAnnotationSupportUtils.getDefaultedAnnotationNode(WebResult.class, (CompilationUnit)this.astRoot, null, null);
        JaxWsAnnotationUtilsTest.assertNull((Object)annotation);
        annotation = ScAnnotationSupportUtils.getDefaultedAnnotationNode(WebResult.class, (CompilationUnit)this.astRoot, (IMember)this.jdtTypeElement, null);
        JaxWsAnnotationUtilsTest.assertNull((Object)annotation);
        annotation = ScAnnotationSupportUtils.getDefaultedAnnotationNode(WebResult.class, (CompilationUnit)this.astRoot, (IMember)this.jdtMethodElement, null);
        JaxWsAnnotationUtilsTest.assertNotNull((Object)annotation);
        JaxWsAnnotationUtilsTest.assertEquals((String)"WebResult", (String)annotation.getTypeName().getFullyQualifiedName());
    }

    public void testNewWebServiceAnnotation() throws Exception {
        Annotation annotation = ScAnnotationSupportUtils.getDefaultedAnnotationNode(WebService.class, (CompilationUnit)this.astRoot, null, null);
        JaxWsAnnotationUtilsTest.assertNull((Object)annotation);
        annotation = ScAnnotationSupportUtils.getDefaultedAnnotationNode(WebService.class, (CompilationUnit)this.astRoot, (IMember)this.jdtTypeElement, null);
        JaxWsAnnotationUtilsTest.assertNotNull((Object)annotation);
        JaxWsAnnotationUtilsTest.assertEquals((String)"WebService", (String)annotation.getTypeName().getFullyQualifiedName());
        annotation = ScAnnotationSupportUtils.getDefaultedAnnotationNode(WebService.class, (CompilationUnit)this.astRoot, (IMember)this.jdtMethodElement, null);
        JaxWsAnnotationUtilsTest.assertNull((Object)annotation);
    }
}

