/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.utils;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.stp.sc.jaxws.tests.ScProjectBaseTest;
import org.eclipse.stp.sc.jaxws.utils.ScFolderGenerationUtils;

public class ScFolderGenerationUtilsTest
extends ScProjectBaseTest {
    private static final String PROJECT_NAME = "JaxWsAnnotationUtilsTestProject";
    protected String[] projectFiles = new String[]{"/src/org/objectweb/hello_world_soap_http/Greeter.java", "/src/demo/GreeterRPCLit.java"};
    protected String[] resourceFiles = new String[]{"/resources/GreeterWrap.java_resource", "/resources/GreeterRPCLit.java_resource"};

    protected String getProjectName() {
        return PROJECT_NAME;
    }

    protected String[] getProjectFiles() {
        return this.projectFiles;
    }

    protected String[] getResourceFiles() {
        return this.resourceFiles;
    }

    public void testNewWebServiceAnnotation() throws Exception {
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        IClasspathEntry[] oldClasspathEntries = javaProject.getRawClasspath();
        IFolder secondSrcFolder = this.project.getFolder("src2");
        IFolder thirdSrcFolder = this.project.getFolder("src3");
        ScFolderGenerationUtils.makeSrcFolder((IFolder)secondSrcFolder);
        IClasspathEntry[] updatedClasspathEntries = javaProject.getRawClasspath();
        ScFolderGenerationUtilsTest.assertEquals((int)oldClasspathEntries.length, (int)(updatedClasspathEntries.length - 1));
        boolean isNewSrcFolderPresent = false;
        int i = 0;
        while (i < updatedClasspathEntries.length && !isNewSrcFolderPresent) {
            if (updatedClasspathEntries[i].getPath().equals((Object)secondSrcFolder.getFullPath())) {
                isNewSrcFolderPresent = true;
                ScFolderGenerationUtilsTest.assertEquals((int)3, (int)updatedClasspathEntries[i].getEntryKind());
            }
            ++i;
        }
        ScFolderGenerationUtilsTest.assertTrue((boolean)isNewSrcFolderPresent);
        ScFolderGenerationUtils.makeSrcFolder((IFolder)thirdSrcFolder);
        updatedClasspathEntries = javaProject.getRawClasspath();
        ScFolderGenerationUtilsTest.assertEquals((int)oldClasspathEntries.length, (int)(updatedClasspathEntries.length - 2));
        isNewSrcFolderPresent = false;
        i = 0;
        while (i < updatedClasspathEntries.length && !isNewSrcFolderPresent) {
            if (updatedClasspathEntries[i].getPath().equals((Object)thirdSrcFolder.getFullPath())) {
                isNewSrcFolderPresent = true;
                ScFolderGenerationUtilsTest.assertEquals((int)3, (int)updatedClasspathEntries[i].getEntryKind());
            }
            ++i;
        }
        ScFolderGenerationUtilsTest.assertTrue((boolean)isNewSrcFolderPresent);
        ScFolderGenerationUtils.makeSrcFolder((IFolder)thirdSrcFolder);
        updatedClasspathEntries = javaProject.getRawClasspath();
        ScFolderGenerationUtilsTest.assertEquals((int)oldClasspathEntries.length, (int)(updatedClasspathEntries.length - 2));
    }
}

