/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.validator;

import junit.framework.TestCase;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.stp.sc.common.validator.AnnotationValidator;
import org.eclipse.stp.sc.jaxws.validator.TestUtils;

public class AnnotationValidatorTest
extends TestCase {
    CompilationUnit astRoot = null;
    AnnotationValidator validator;

    protected void setUp() throws Exception {
        ASTParser parser = ASTParser.newParser((int)3);
        String content = "";
        parser.setSource(content.toCharArray());
        this.astRoot = (CompilationUnit)parser.createAST(null);
        this.validator = new AnnotationValidator();
    }

    protected void tearDown() throws Exception {
    }

    public void testValidateWS() throws Exception {
        NormalAnnotation wsAnn = TestUtils.createValidWSAnn(this.astRoot);
        boolean ret = this.validator.validateAnn(wsAnn);
        AnnotationValidatorTest.assertTrue((String)"should return true for valid ann.", (boolean)ret);
        NormalAnnotation invalidWSAnn = TestUtils.createInValidWSAnn(this.astRoot);
        ret = this.validator.validateAnn(invalidWSAnn);
        System.out.println("ret:" + ret);
        AnnotationValidatorTest.assertFalse((String)"should return false for invalid ann.", (boolean)ret);
        System.err.println("validator error msg:" + this.validator.getLastErrorMessage());
        AnnotationValidatorTest.assertTrue((String)"should return error msg.", (this.validator.getLastErrorMessage() != null ? 1 : 0) != 0);
    }

    public void testValidSoapBinding() throws Exception {
        NormalAnnotation soapAnn = TestUtils.createValidSOAPBindingAnn(this.astRoot);
        boolean ret = this.validator.validateAnn(soapAnn);
        AnnotationValidatorTest.assertTrue((String)"should return true for valid soap ann.", (boolean)ret);
    }

    public void testInvalideSoapBinding() throws Exception {
    }
}

