/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wsdl;

import javax.wsdl.Definition;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import org.eclipse.core.resources.IFile;
import org.eclipse.stp.sc.jaxws.tests.ScProjectBaseTest;
import org.eclipse.stp.sc.jaxws.wsdl.WsdlUtils;

public class WsdlUtilsTest
extends ScProjectBaseTest {
    public static final String PROJECT_NAME = "WsdlUtilsTestProject";
    protected String[] projectFiles = new String[]{"/wsdl/GreeterRPCLit.wsdl", "/wsdl/schema1.xsd", "/wsdl/schema2.xsd"};
    protected String[] resourceFiles = new String[]{"/resources/GreeterRPCLit.wsdl_resource", "/resources/schema1.xsd_resource", "/resources/schema2.xsd_resource"};

    protected String getProjectName() {
        return PROJECT_NAME;
    }

    protected String[] getProjectFiles() {
        return this.projectFiles;
    }

    protected String[] getResourceFiles() {
        return this.resourceFiles;
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testReadWSDL() throws Exception {
        Definition wsdlDef = WsdlUtils.readWSDL((IFile)this.files[0]);
        WsdlUtilsTest.assertNotNull((String)"should load wsdl model.", (Object)wsdlDef);
    }

    public void testExpendImportSchema() throws Exception {
        this.project.refreshLocal(2, null);
        String wsdlUrl = this.files[0].getLocation().toOSString();
        WsdlUtils.expendImportSchemas((String)wsdlUrl, (String)wsdlUrl);
        this.project.refreshLocal(2, null);
        WsdlUtilsTest.assertFalse((String)"schema1.xsd should be deleted.", (boolean)this.files[1].exists());
        WsdlUtilsTest.assertFalse((String)"schema2.xsd should be deleted.", (boolean)this.files[2].exists());
        Definition wsdlDef = WsdlUtils.readWSDL((String)wsdlUrl);
        for (ExtensibilityElement elem : wsdlDef.getTypes().getExtensibilityElements()) {
            if (!(elem instanceof Schema)) continue;
            Schema schema = (Schema)elem;
            WsdlUtilsTest.assertTrue((String)"shouldn't have schema import.", (schema.getImports().size() == 0 ? 1 : 0) != 0);
        }
    }
}

