/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.builders;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.builders.ScJavaBuilder;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.jaxws.builders.JavaDocumentUtils;
import org.eclipse.stp.sc.jaxws.generators.types.JaxBindTypeGenerator;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;

public class ScJaxbBuilder
extends ScJavaBuilder {
    public static final String BUILDER_ID = "org.eclipse.stp.sc.jaxws.builders.jaxbbuilder";
    private static final LoggingProxy LOG = LoggingProxy.getlogger(ScJaxbBuilder.class);

    public ScJaxbBuilder() {
        LOG.debug((Object)"JAXB builder has been created");
    }

    protected void buildOneJavaFile(IFile javaFile) throws CoreException {
        try {
            if (javaFile.getFileExtension() == null || !javaFile.getFileExtension().equals("java")) {
                return;
            }
            LOG.debug((Object)"build one file called in JaxBuilder");
            ICompilationUnit compUnit = JDTUtils.getJavaUnitFromFile((IFile)javaFile);
            if (JavaDocumentUtils.needToGenerateWrapper(compUnit)) {
                LOG.info((Object)("generate wrapper type classes for SEI:" + compUnit.findPrimaryType().getFullyQualifiedName()));
                JaxBindTypeGenerator typeGen = new JaxBindTypeGenerator();
                typeGen.createWrapperCls(compUnit);
            }
        }
        catch (Exception e) {
            LOG.debug((Object)"generation failure", (Throwable)e);
            Status status = new Status(4, "org.eclipse.core.resources", 75, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
    }

    protected boolean checkAnnotation(IFile javaFile) {
        return JavaDocumentUtils.hasWebServiceAnnotation(javaFile);
    }

    protected void removeResourceFile(IResource res) throws CoreException {
        if (!(res instanceof IFile)) {
            return;
        }
        IFile file = (IFile)res;
        if (!file.getFileExtension().equals("java")) {
            return;
        }
        if (this.checkAnnotation(file)) {
            LOG.debug((Object)("WebService java file has been removed:" + file.getFullPath()));
            String clsName = JDTUtils.getJavaClassNameFromFile((IFile)file);
            if (clsName.lastIndexOf(".") > 0) {
                clsName = clsName.substring(clsName.lastIndexOf("."));
            }
            String wsdlName = String.valueOf(clsName) + ".wsdl";
            LOG.debug((Object)("  need to remove:" + wsdlName));
            IContainer folder = JaxWsWorkspaceManager.getWSDLFolder(this.getProject());
            IResource wsdlResource = folder.findMember(wsdlName);
            if (wsdlResource.exists()) {
                LOG.debug((Object)("delete wsdl resource:" + wsdlResource.getFullPath()));
                wsdlResource.delete(1, null);
            }
        }
    }
}

