/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.project.facet.WtpUtils;
import org.eclipse.jst.j2ee.project.facet.J2EEFacetInstallDelegate;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class JaxWsFacetInstallDelegate
extends J2EEFacetInstallDelegate
implements IDelegate {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(JaxWsFacetInstallDelegate.class);
    public static final String FACET_PROJECT_NATURE = "org.eclipse.wst.common.project.facet.core.nature";
    public static String MODULE_TYPE = "stp.jaxws.component";
    public static String MODULE_VERSION = "2.0";
    public static String JAVAWEB_FACET = "jst.web";
    public static String JAVAWEB_FACET_VERSION = "2.4";
    public static String JAVA_FACET = "jst.java";
    public static String JAVA_FACET_VERSION = "5.0";

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("Installing JAX-WS facet", 1);
        }
        try {
            JavaCore.create((IProject)project);
            WtpUtils.addNatures((IProject)project);
            IVirtualComponent c = ComponentCore.createComponent((IProject)project);
            c.create(0, null);
            c.setMetaProperty("java-output-path", "/classes/");
            IVirtualFolder jaxwsRoot = c.getRootFolder();
            jaxwsRoot.createLink((IPath)new Path("/src"), 0, null);
            jaxwsRoot.createLink((IPath)new Path("/wsdl"), 0, null);
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private static void addFacetNature(IProject project) throws Exception {
        IProjectDescription projDesc = project.getDescription();
        String[] natures = projDesc.getNatureIds();
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[newNatures.length - 1] = FACET_PROJECT_NATURE;
        projDesc.setNatureIds(newNatures);
        project.setDescription(projDesc, null);
    }

    public static void addFacet(IProject project, String facet, String version) throws Exception {
        IProjectFacet pf = ProjectFacetsManager.getProjectFacet((String)facet);
        IProjectFacetVersion fv = pf.getVersion(version);
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
        if (!facetedProject.hasProjectFacet(pf)) {
            LOG.debug((Object)("install facet:" + facet));
            facetedProject.installProjectFacet(fv, null, null);
        }
    }

    public static void addJaxWsFacet(IProject project) {
        try {
            WtpUtils.addNatures((IProject)project);
            if (!project.hasNature(FACET_PROJECT_NATURE)) {
                JaxWsFacetInstallDelegate.addFacetNature(project);
            }
            JaxWsFacetInstallDelegate.addFacet(project, JAVA_FACET, JAVA_FACET_VERSION);
            JaxWsFacetInstallDelegate.addFacet(project, JAVAWEB_FACET, JAVAWEB_FACET_VERSION);
            JaxWsFacetInstallDelegate.addFacet(project, MODULE_TYPE, MODULE_VERSION);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error((Object)"error when setup jaxws facet.", (Throwable)e);
        }
    }
}

