/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.runtimeprovider;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IJavaToWsdlGenerator;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IParameterPage;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IPostProjectProcessor;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IProjectDirTemplate;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IRuntimeKitProcessor;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IWsdlToJavaGenerator;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IWsdlToJavaWizard;

public class RuntimeProviderManager {
    private static final String EXT_POINT_SC_RUNTIME_PROVIDER = "org.eclipse.stp.sc.jaxws.runtimeProvider";
    private static final String EXT_ELT_SC_KIT_PROCESSOR = "KitProcessor";
    private static final String EXT_ATT_SC_PROCESSOR_CLASS = "kit_processor_class";
    private static final String EXT_ELT_SC_W2J_GEN = "wsdltoJavaGenerator";
    private static final String EXT_ATT_SC_W2J_GEN_CLASS = "class";
    private static final String EXT_ATT_SC_W2J_PARAM_PAGE = "parameter_page";
    private static final String EXT_ELT_SC_J2W_GEN = "javaToWsdlGenerator";
    private static final String EXT_ATT_SC_J2W_GEN_CLASS = "class";
    private static final String EXT_ELT_SC_W2J_WIZ = "wsdlToJavaWizard";
    private static final String EXT_ATT_SC_W2J_WIZ_CLASS = "class";
    private static final String EXT_ELT_SC_DIR_TEMP = "projectDirTemplate";
    private static final String EXT_ATT_SC_DIR_TEMP_CLASS = "class";
    private static final String EXT_ATT_SC_POST_PROCESSOR_CLASS = "postProjectProcessor";
    private static final LoggingProxy LOG = LoggingProxy.getlogger(RuntimeProviderManager.class);
    private static RuntimeProviderManager instance;
    private static Map<String, IProjectDirTemplate> prjDirTempMap;
    private static Map<String, IPostProjectProcessor> prjPostProcessorMap;

    private RuntimeProviderManager() {
    }

    public static RuntimeProviderManager getInstance() {
        if (instance == null) {
            instance = new RuntimeProviderManager();
        }
        if (prjDirTempMap == null) {
            prjDirTempMap = new HashMap<String, IProjectDirTemplate>();
        }
        if (prjPostProcessorMap == null) {
            prjPostProcessorMap = new HashMap<String, IPostProjectProcessor>();
        }
        return instance;
    }

    public IWsdlToJavaGenerator getWsdltoJavaGenerator(String runtimeType) {
        return this.loadWsdltoJavaGenerator(RuntimeProviderManager.getRuntimeProviderUID(runtimeType));
    }

    public IWsdlToJavaWizard getWsdlToJavaWizard(String runtimeType) {
        return this.loadWsdltoJavaWizard(RuntimeProviderManager.getRuntimeProviderUID(runtimeType));
    }

    public IJavaToWsdlGenerator getJavaToWsdlGenerator(String runtimeType) {
        return this.loadJavaToWsdlGenerator(RuntimeProviderManager.getRuntimeProviderUID(runtimeType));
    }

    public IRuntimeKitProcessor getRuntimeKitProcessor(String runtimeType, String runtimeId) {
        String providerExtUID = RuntimeProviderManager.getRuntimeProviderUID(runtimeType);
        return this.loadRuntimeKitProcessor(providerExtUID);
    }

    public IProjectDirTemplate getProjectDirTemplate(String runtimeType) {
        if (prjDirTempMap.keySet().contains(runtimeType)) {
            return prjDirTempMap.get(runtimeType);
        }
        IProjectDirTemplate template = this.loadProjectDirTemplate(RuntimeProviderManager.getRuntimeProviderUID(runtimeType));
        prjDirTempMap.put(runtimeType, template);
        return template;
    }

    public IPostProjectProcessor getPostProjectProcessor(String runtimeType) {
        if (prjPostProcessorMap.keySet().contains(runtimeType)) {
            return prjPostProcessorMap.get(runtimeType);
        }
        IPostProjectProcessor processor = this.loadPostProjectProcessor(RuntimeProviderManager.getRuntimeProviderUID(runtimeType));
        prjPostProcessorMap.put(runtimeType, processor);
        return processor;
    }

    public static String getRuntimeProviderUID(String runtimeType) {
        IExtension[] providers;
        IExtension[] iExtensionArray = providers = RuntimeProviderManager.getAllRegistredProviders();
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension provider = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = provider.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement cfgElt = iConfigurationElementArray[n4];
                if (cfgElt.getName().equals("supportedRuntime") && cfgElt.getAttribute("type").equals(runtimeType)) {
                    return provider.getUniqueIdentifier();
                }
                ++n4;
            }
            ++n2;
        }
        Exception e = new Exception();
        LOG.error((Object)("no runtime provider for runtime type:" + runtimeType), (Throwable)e);
        return null;
    }

    public IExtension getExtension(String ID) {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        return reg.getExtension(EXT_POINT_SC_RUNTIME_PROVIDER, ID);
    }

    public static IExtension[] getAllRegistredProviders() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        return reg.getExtensionPoint(EXT_POINT_SC_RUNTIME_PROVIDER).getExtensions();
    }

    private IWsdlToJavaGenerator loadWsdltoJavaGenerator(String ID) {
        if (this.getExtension(ID) == null) {
            return null;
        }
        IConfigurationElement[] extElts = this.getExtension(ID).getConfigurationElements();
        int extIndex = 0;
        while (extIndex < extElts.length) {
            IConfigurationElement cfgElt = extElts[extIndex];
            if (cfgElt.getName().equals(EXT_ELT_SC_W2J_GEN)) {
                try {
                    Object kitProcessorObj = cfgElt.createExecutableExtension("class");
                    if (kitProcessorObj instanceof IWsdlToJavaGenerator) {
                        return (IWsdlToJavaGenerator)kitProcessorObj;
                    }
                    LOG.error((Object)this.getLogErrMsgWrongClassType(ID, EXT_ATT_SC_PROCESSOR_CLASS, IWsdlToJavaGenerator.class));
                }
                catch (CoreException e) {
                    LOG.error((Object)this.getLogErrMsgNotCLass(ID, EXT_ATT_SC_PROCESSOR_CLASS), (Throwable)e);
                }
                return null;
            }
            ++extIndex;
        }
        return null;
    }

    public IProjectDirTemplate loadProjectDirTemplate(String providerExtUID) {
        if (this.getExtension(providerExtUID) == null) {
            return null;
        }
        IConfigurationElement[] extElts = this.getExtension(providerExtUID).getConfigurationElements();
        int extIndex = 0;
        while (extIndex < extElts.length) {
            IConfigurationElement cfgElt = extElts[extIndex];
            if (cfgElt.getName().equals(EXT_ELT_SC_DIR_TEMP)) {
                try {
                    Object kitProcessorObj = cfgElt.createExecutableExtension("class");
                    if (kitProcessorObj instanceof IProjectDirTemplate) {
                        return (IProjectDirTemplate)kitProcessorObj;
                    }
                    LOG.error((Object)this.getLogErrMsgWrongClassType(providerExtUID, "class", IProjectDirTemplate.class));
                }
                catch (CoreException e) {
                    LOG.error((Object)this.getLogErrMsgNotCLass(providerExtUID, "class"), (Throwable)e);
                }
                return null;
            }
            ++extIndex;
        }
        return null;
    }

    public IPostProjectProcessor loadPostProjectProcessor(String providerExtUID) {
        IConfigurationElement[] extElts = this.getExtension(providerExtUID).getConfigurationElements();
        int extIndex = 0;
        while (extIndex < extElts.length) {
            IConfigurationElement cfgElt = extElts[extIndex];
            if (cfgElt.getName().equals(EXT_ELT_SC_DIR_TEMP)) {
                block6: {
                    String obj = cfgElt.getAttribute(EXT_ATT_SC_POST_PROCESSOR_CLASS);
                    if (obj != null) break block6;
                    return null;
                }
                try {
                    Object prjProcessor = cfgElt.createExecutableExtension(EXT_ATT_SC_POST_PROCESSOR_CLASS);
                    if (prjProcessor instanceof IPostProjectProcessor) {
                        return (IPostProjectProcessor)prjProcessor;
                    }
                    LOG.error((Object)this.getLogErrMsgWrongClassType(providerExtUID, EXT_ATT_SC_POST_PROCESSOR_CLASS, IPostProjectProcessor.class));
                }
                catch (CoreException e) {
                    LOG.error((Object)this.getLogErrMsgNotCLass(providerExtUID, EXT_ATT_SC_POST_PROCESSOR_CLASS), (Throwable)e);
                }
                return null;
            }
            ++extIndex;
        }
        return null;
    }

    private IWsdlToJavaWizard loadWsdltoJavaWizard(String ID) {
        if (this.getExtension(ID) == null) {
            return null;
        }
        IConfigurationElement[] extElts = this.getExtension(ID).getConfigurationElements();
        int extIndex = 0;
        while (extIndex < extElts.length) {
            IConfigurationElement cfgElt = extElts[extIndex];
            if (cfgElt.getName().equals(EXT_ELT_SC_W2J_WIZ)) {
                try {
                    Object kitProcessorObj = cfgElt.createExecutableExtension("class");
                    if (kitProcessorObj instanceof IWsdlToJavaWizard) {
                        return (IWsdlToJavaWizard)kitProcessorObj;
                    }
                    LOG.error((Object)this.getLogErrMsgWrongClassType(ID, EXT_ATT_SC_PROCESSOR_CLASS, IWsdlToJavaWizard.class));
                }
                catch (CoreException e) {
                    LOG.error((Object)this.getLogErrMsgNotCLass(ID, EXT_ATT_SC_PROCESSOR_CLASS), (Throwable)e);
                }
                return null;
            }
            ++extIndex;
        }
        return null;
    }

    private IJavaToWsdlGenerator loadJavaToWsdlGenerator(String ID) {
        if (this.getExtension(ID) == null) {
            return null;
        }
        IConfigurationElement[] extElts = this.getExtension(ID).getConfigurationElements();
        int extIndex = 0;
        while (extIndex < extElts.length) {
            IConfigurationElement cfgElt = extElts[extIndex];
            if (cfgElt.getName().equals(EXT_ELT_SC_J2W_GEN)) {
                try {
                    Object kitProcessorObj = cfgElt.createExecutableExtension("class");
                    if (kitProcessorObj instanceof IJavaToWsdlGenerator) {
                        return (IJavaToWsdlGenerator)kitProcessorObj;
                    }
                    LOG.error((Object)this.getLogErrMsgWrongClassType(ID, EXT_ATT_SC_PROCESSOR_CLASS, IJavaToWsdlGenerator.class));
                }
                catch (CoreException e) {
                    LOG.error((Object)this.getLogErrMsgNotCLass(ID, EXT_ATT_SC_PROCESSOR_CLASS), (Throwable)e);
                }
                return null;
            }
            ++extIndex;
        }
        return null;
    }

    public IRuntimeKitProcessor loadRuntimeKitProcessor(String uniqueIdentifier) {
        if (this.getExtension(uniqueIdentifier) == null) {
            return null;
        }
        IConfigurationElement[] extElts = this.getExtension(uniqueIdentifier).getConfigurationElements();
        int extIndex = 0;
        while (extIndex < extElts.length) {
            IConfigurationElement cfgElt = extElts[extIndex];
            if (cfgElt.getName().equals(EXT_ELT_SC_KIT_PROCESSOR)) {
                try {
                    Object kitProcessorObj = cfgElt.createExecutableExtension(EXT_ATT_SC_PROCESSOR_CLASS);
                    if (kitProcessorObj instanceof IRuntimeKitProcessor) {
                        return (IRuntimeKitProcessor)kitProcessorObj;
                    }
                    LOG.error((Object)this.getLogErrMsgWrongClassType(uniqueIdentifier, EXT_ATT_SC_PROCESSOR_CLASS, IRuntimeKitProcessor.class));
                }
                catch (CoreException e) {
                    LOG.error((Object)this.getLogErrMsgNotCLass(uniqueIdentifier, EXT_ATT_SC_PROCESSOR_CLASS), (Throwable)e);
                }
                return null;
            }
            ++extIndex;
        }
        return null;
    }

    private String getLogErrMsgNotCLass(String extId, String attributeName) {
        return "the 'IRuntimeKitProcessor' could not be instanciated from the extension " + extId + ". check value of the attribute '" + attributeName + "'";
    }

    private String getLogErrMsgWrongClassType(String extId, String attributeName, Class superClass) {
        return "the class specified in the attribute '" + attributeName + "' of the extension '" + extId + "' does not extend the interface '" + superClass.getCanonicalName() + "'";
    }

    private IParameterPage loadParameterPage(String id) {
        IConfigurationElement[] extElts = this.getExtension(id).getConfigurationElements();
        int extIndex = 0;
        while (extIndex < extElts.length) {
            IConfigurationElement cfgElt = extElts[extIndex];
            if (cfgElt.getName().equals(EXT_ELT_SC_W2J_GEN)) {
                try {
                    Object kitParamPageObj = cfgElt.createExecutableExtension(EXT_ATT_SC_W2J_PARAM_PAGE);
                    if (kitParamPageObj instanceof IParameterPage) {
                        return (IParameterPage)kitParamPageObj;
                    }
                    LOG.error((Object)this.getLogErrMsgWrongClassType(id, EXT_ATT_SC_W2J_PARAM_PAGE, IJavaToWsdlGenerator.class));
                }
                catch (CoreException e) {
                    LOG.error((Object)this.getLogErrMsgNotCLass(id, EXT_ATT_SC_W2J_PARAM_PAGE), (Throwable)e);
                }
                return null;
            }
            ++extIndex;
        }
        return null;
    }

    public IParameterPage getParameterPage(String runtimeType) {
        String providerExtUID = RuntimeProviderManager.getRuntimeProviderUID(runtimeType);
        return this.loadParameterPage(providerExtUID);
    }
}

