/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.utils;

import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.stp.sc.common.utils.JDTUtils;

public class JaxBindAnnotationUtils {
    public static final HashSet<String> JAXB_TABLE = new HashSet();

    static {
        JAXB_TABLE.add("XmlAccessorType");
        JAXB_TABLE.add("XmlElement");
        JAXB_TABLE.add("XmlRootElement");
        JAXB_TABLE.add("XmlType");
    }

    protected JaxBindAnnotationUtils() {
    }

    public static String getAnnotationImport(Annotation annotation) {
        if (JAXB_TABLE.contains(annotation.getTypeName().toString())) {
            return String.valueOf(XmlRootElement.class.getPackage().getName()) + "." + annotation.getTypeName().toString();
        }
        return null;
    }

    public static SingleMemberAnnotation newXmlAccessorTypeAnnotation(CompilationUnit astRoot, Expression exp) {
        return JDTUtils.newSingleMemberAnnotation((CompilationUnit)astRoot, (String)XmlAccessorType.class.getSimpleName(), (Expression)exp);
    }

    public static NormalAnnotation newXmlTypeAnnotation(CompilationUnit astRoot, String name, String[] propOrder) {
        ArrayList<MemberValuePair> annotValues = new ArrayList<MemberValuePair>();
        MemberValuePair valPair = JDTUtils.newMemberValuePair((CompilationUnit)astRoot, (String)"name", (Object)name);
        annotValues.add(valPair);
        if (propOrder != null && propOrder.length != 0) {
            valPair = JDTUtils.newMemberValuePair((CompilationUnit)astRoot, (String)"propOrder", (Object)propOrder);
            annotValues.add(valPair);
        }
        return JDTUtils.newNormalAnnotation((CompilationUnit)astRoot, (String)XmlType.class.getSimpleName(), annotValues);
    }

    public static NormalAnnotation newXmlRootElemntAnnotation(CompilationUnit astRoot, String name) {
        ArrayList<MemberValuePair> annotValues = new ArrayList<MemberValuePair>();
        MemberValuePair valPair = JDTUtils.newMemberValuePair((CompilationUnit)astRoot, (String)"name", (Object)name);
        annotValues.add(valPair);
        return JDTUtils.newNormalAnnotation((CompilationUnit)astRoot, (String)XmlRootElement.class.getSimpleName(), annotValues);
    }

    public static NormalAnnotation newXmlElementAnnotation(CompilationUnit astRoot, String name, Boolean nillable, String namespace, String defaultValue, Type typeClass) {
        MemberValuePair valPair;
        ArrayList<MemberValuePair> annotValues = new ArrayList<MemberValuePair>();
        if (name != null) {
            valPair = JDTUtils.newMemberValuePair((CompilationUnit)astRoot, (String)"name", (Object)name);
            annotValues.add(valPair);
        }
        if (nillable != null) {
            valPair = JDTUtils.newMemberValuePair((CompilationUnit)astRoot, (String)"nillable", (Object)nillable);
            annotValues.add(valPair);
        }
        if (namespace != null) {
            valPair = JDTUtils.newMemberValuePair((CompilationUnit)astRoot, (String)"namespace", (Object)namespace);
            annotValues.add(valPair);
        }
        if (defaultValue != null) {
            valPair = JDTUtils.newMemberValuePair((CompilationUnit)astRoot, (String)"defaultValue", (Object)defaultValue);
            annotValues.add(valPair);
        }
        return JDTUtils.newNormalAnnotation((CompilationUnit)astRoot, (String)XmlElement.class.getSimpleName(), annotValues);
    }
}

