/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wsdl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlUtils {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(WsdlUtils.class);

    protected WsdlUtils() {
    }

    public static boolean importWsdlToWorkspace(String path, IFile targetFile) {
        return false;
    }

    public static boolean importWsdlToWorkspace(URL url, IFile targetFile) {
        return false;
    }

    public static Definition readWSDL(IFile wsdlFile) throws WSDLException, IOException, URISyntaxException {
        String url = wsdlFile.getRawLocation().toFile().toURL().toString();
        return WsdlUtils.readWSDL(url);
    }

    public static Definition readWSDL(String wsdlURL) throws WSDLException {
        LOG.debug((Object)("try to read wsdl file:" + wsdlURL));
        WSDLFactory wsdlFactory = WSDLFactory.newInstance();
        WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
        wsdlReader.setFeature("javax.wsdl.verbose", false);
        wsdlReader.setFeature("javax.wsdl.importDocuments", true);
        Definition wsdlDef = wsdlReader.readWSDL(wsdlURL);
        LOG.debug((Object)"wsdl file loaded");
        return wsdlDef;
    }

    public static void saveWSDL(Definition wsdlDef, String wsdlURL) throws WSDLException, IOException {
        WSDLFactory wsdlFactory = WSDLFactory.newInstance();
        WSDLWriter wsdlWriter = wsdlFactory.newWSDLWriter();
        FileOutputStream fos = new FileOutputStream(wsdlURL);
        wsdlWriter.writeWSDL(wsdlDef, (OutputStream)fos);
        fos.close();
    }

    public static void expendImportSchemas(String wsdlURL, String targetURL) throws WSDLException, URISyntaxException, IOException {
        boolean overWrite = false;
        Definition wsdlDef = WsdlUtils.readWSDL(wsdlURL);
        Vector<Schema> importedSchemaList = new Vector<Schema>();
        Iterator itor = wsdlDef.getTypes().getExtensibilityElements().iterator();
        while (itor.hasNext()) {
            ExtensibilityElement elem = (ExtensibilityElement)itor.next();
            if (!(elem instanceof Schema) || !WsdlUtils.processOneSchema((Schema)elem, importedSchemaList, wsdlURL)) continue;
            itor.remove();
            overWrite = true;
        }
        for (Schema schema : importedSchemaList) {
            WsdlUtils.removeImports(schema);
            WsdlUtils.printSchema(schema);
            wsdlDef.getTypes().getExtensibilityElements().add(schema);
        }
        if (overWrite) {
            if (targetURL == null) {
                WsdlUtils.saveWSDL(wsdlDef, wsdlURL);
            } else {
                WsdlUtils.saveWSDL(wsdlDef, targetURL);
            }
        }
    }

    private static boolean processOneSchema(Schema schema, Vector<Schema> importedSchemaList, String wsdlURL) throws URISyntaxException {
        Map imports = schema.getImports();
        int removedImportCount = 0;
        Iterator itor = imports.keySet().iterator();
        while (itor.hasNext()) {
            String namespaceURI = (String)itor.next();
            List namespaceImports = (List)imports.get(namespaceURI);
            Iterator importItor = namespaceImports.iterator();
            while (importItor.hasNext()) {
                SchemaImport sImport = (SchemaImport)importItor.next();
                URI uri = new URI(sImport.getSchemaLocationURI());
                LOG.debug((Object)("import schema uri:" + uri.toString()));
                if (uri.getScheme() != null && !uri.getScheme().equals("") && !uri.getScheme().startsWith("file")) continue;
                WsdlUtils.deleteImportSchemaFile(uri, wsdlURL);
                LOG.debug((Object)("expend import schema:" + sImport.getSchemaLocationURI()));
                Schema refSchema = sImport.getReferencedSchema();
                refSchema.getElement().setPrefix(schema.getElement().getPrefix());
                importedSchemaList.add(refSchema);
                LOG.debug((Object)("remove import:" + sImport.getSchemaLocationURI()));
                importItor.remove();
                ++removedImportCount;
            }
            if (namespaceImports.size() != 0) continue;
            itor.remove();
        }
        if (imports.keySet().size() == 0) {
            imports.clear();
            if (schema.getElement().getChildNodes().getLength() == removedImportCount) {
                return true;
            }
        }
        return false;
    }

    private static void removeImports(Schema schema) {
        Map imports = schema.getImports();
        imports.clear();
        Element elem = schema.getElement();
        NodeList nodes = elem.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node childNode = nodes.item(i);
            if (childNode.getLocalName() != null && childNode.getLocalName().equals("import")) {
                elem.removeChild(nodes.item(i));
            }
            ++i;
        }
    }

    private static void deleteImportSchemaFile(URI uri, String wsdlURL) {
        String path = String.valueOf(wsdlURL.substring(0, wsdlURL.lastIndexOf(File.separator) + 1)) + uri.getPath();
        File schemaFile = new File(path);
        LOG.debug((Object)("delete import schema file:" + schemaFile.getAbsolutePath()));
        schemaFile.delete();
    }

    private static void printSchema(Schema schema) {
        LOG.debug((Object)"************** schema start ******************");
        LOG.debug((Object)(" base url:" + schema.getDocumentBaseURI()));
        LOG.debug((Object)(" imports size:" + schema.getImports().size()));
        LOG.debug((Object)(" include size:" + schema.getIncludes().size()));
        LOG.debug((Object)(" redefines size:" + schema.getRedefines().size()));
        LOG.debug((Object)(" element:" + schema.getElement()));
        LOG.debug((Object)(" element type:" + schema.getElementType()));
        LOG.debug((Object)(" node prefix:" + schema.getElement().getPrefix()));
        Element elem = schema.getElement();
        NodeList nodeList = elem.getChildNodes();
        LOG.debug((Object)("  child nodes list:" + nodeList.getLength()));
        if (schema instanceof SchemaImport) {
            SchemaImport sImport = (SchemaImport)schema;
            LOG.debug((Object)("   import ns uri:" + sImport.getNamespaceURI()));
            LOG.debug((Object)("   import schema location:" + sImport.getSchemaLocationURI()));
            LOG.debug((Object)("   import referenedSchema:" + sImport.getReferencedSchema()));
            LOG.debug((Object)"    ***********************referenced schema start***********************");
            WsdlUtils.printSchema(sImport.getReferencedSchema());
            LOG.debug((Object)"    ***********************referenced schema end***********************");
        }
        LOG.debug((Object)"************** schema end ******************");
    }
}

