/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.xmlvalidator.rule.engine;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.stp.sc.common.utils.WorkbenchUtils;
import org.eclipse.stp.sc.xmlvalidator.rule.engine.VRuleEngine;
import org.eclipse.stp.sc.xmlvalidator.rule.engine.VRuleEngineTestBase;
import org.eclipse.stp.sc.xmlvalidator.rule.model.VRuleError;
import org.eclipse.stp.sc.xmlvalidator.utils.XMLUtils;
import org.w3c.dom.Document;

public class VRuleEngineTest
extends VRuleEngineTestBase {
    private static String PROJECT_NAME = "VRuleEngineTest";
    private static String VALIDATE_XML_NAME = "/JAXWS_Ann_HelloWorld.xml";
    private static String WRONG_XML_NAME = "/JAXWS_Ann_HelloWorld_Errors.xml";
    private static String VALIDATE_XML_PATH = "/resources/" + VALIDATE_XML_NAME;
    private static String WRONG_XML_PATH = "/resources/" + WRONG_XML_NAME;
    VRuleEngine engine = null;
    IFile helloRuleFile;
    IFile wrongRuleFile;

    protected void setUp() throws Exception {
        super.setUp();
        this.helloRuleFile = WorkbenchUtils.addFileResourceToTestProject((IProject)this.project, (String)VALIDATE_XML_NAME, ((Object)((Object)this)).getClass(), (String)VALIDATE_XML_PATH);
        this.wrongRuleFile = WorkbenchUtils.addFileResourceToTestProject((IProject)this.project, (String)WRONG_XML_NAME, ((Object)((Object)this)).getClass(), (String)WRONG_XML_PATH);
        this.engine = new VRuleEngine();
        this.engine.init();
    }

    protected void tearDown() throws Exception {
    }

    protected String getProjectName() {
        return PROJECT_NAME;
    }

    public void testValidXMLFile() throws Exception {
        VRuleError[] errors = this.engine.validate(this.helloRuleFile.getLocation().toOSString());
        VRuleEngineTest.assertTrue((String)"it is valid xml, shouldn't return errors", (errors == null || errors.length == 0 ? 1 : 0) != 0);
    }

    public void testValidXMLStream() throws Exception {
        Document dom = XMLUtils.loadXmlDocument((String)this.helloRuleFile.getLocation().toOSString());
        VRuleError[] errors = this.engine.validate(dom);
        VRuleEngineTest.assertTrue((String)"it is valid xml, shouldn't return errors", (errors == null || errors.length == 0 ? 1 : 0) != 0);
    }

    public void testInvalidXMLFile() throws Exception {
        VRuleError[] errors = this.engine.validate(this.wrongRuleFile.getLocation().toOSString());
        VRuleEngineTest.assertEquals((String)"it is invalid xml, should return errors", (int)errors.length, (int)4);
        System.out.println(errors[0].getErrorMsg());
        System.out.println(errors[1].getErrorMsg());
        System.out.println(errors[2].getErrorMsg());
        System.out.println(errors[3].getErrorMsg());
    }

    public void testRemoveRuleByID() throws Exception {
        VRuleEngineTest.assertEquals((int)this.engine.ruleMgr.ruleTable.size(), (int)5);
        this.engine.removeRule("jaxws_rule_soapbind");
        VRuleEngineTest.assertEquals((int)this.engine.ruleMgr.ruleTable.size(), (int)4);
    }
}

