/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.xmlvalidator.rule.parser;

import java.net.URL;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stp.sc.xmlvalidator.rule.parser.DomLocationParser;
import org.eclipse.stp.sc.xmlvalidator.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DomLocationParserTest
extends TestCase {
    static final String TEST_XML_WITH_NS_FILE = "/src/resources/test_with_ns.xml";
    static final String TEST_XML_WITHOUT_NS_FILE = "/src/resources/test_without_ns.xml";
    DocumentBuilder builder;
    DomLocationParser parser;

    protected void setUp() throws Exception {
        super.setUp();
        this.parser = new DomLocationParser();
        this.builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testParseWithNS() throws Exception {
        URL baseURL = Platform.getBundle((String)"org.eclipse.stp.sc.xmlvalidator.test").getEntry("/");
        URL fileURL = new URL(baseURL, TEST_XML_WITH_NS_FILE);
        Document doc1 = this.parser.parse(fileURL.openStream());
        Document doc2 = this.builder.parse(fileURL.openStream());
        DomLocationParserTest.assertTrue((boolean)XMLUtils.compareTrees((Document)doc1, (Document)doc2));
    }

    public void testParseWithoutNS() throws Exception {
        URL baseURL = Platform.getBundle((String)"org.eclipse.stp.sc.xmlvalidator.test").getEntry("/");
        URL fileURL = new URL(baseURL, TEST_XML_WITHOUT_NS_FILE);
        Document doc1 = this.parser.parse(fileURL.openStream());
        Document doc2 = this.builder.parse(fileURL.openStream());
        DomLocationParserTest.assertTrue((boolean)XMLUtils.compareTrees((Document)doc1, (Document)doc2));
    }

    public void testLocationWithNS() throws Exception {
        URL baseURL = Platform.getBundle((String)"org.eclipse.stp.sc.xmlvalidator.test").getEntry("/");
        URL fileURL = new URL(baseURL, TEST_XML_WITH_NS_FILE);
        Document doc = this.parser.parse(fileURL.openStream());
        List elementList = XMLUtils.getElementList((Document)doc);
        DomLocationParserTest.assertTrue((elementList.size() == 52 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(0))) == 2 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(0))) == 1 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(1))) == 9 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(1))) == 5 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(2))) == 10 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(2))) == 9 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(3))) == 12 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(3))) == 13 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(4))) == 13 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(4))) == 13 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(5))) == 14 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(5))) == 17 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(6))) == 15 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(6))) == 17 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(7))) == 16 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(7))) == 17 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(8))) == 22 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(8))) == 5 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(9))) == 24 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(9))) == 5 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(10))) == 25 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(10))) == 9 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(11))) == 28 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(11))) == 5 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(12))) == 29 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(12))) == 9 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(13))) == 32 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(13))) == 5 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(14))) == 33 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(14))) == 9 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(15))) == 36 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(15))) == 5 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(16))) == 37 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(16))) == 9 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(17))) == 40 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(17))) == 5 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(18))) == 41 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(18))) == 9 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(19))) == 44 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(19))) == 5 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(20))) == 45 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(20))) == 9 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(21))) == 46 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(21))) == 13 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(22))) == 47 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(22))) == 13 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(23))) == 49 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(23))) == 9 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(24))) == 50 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(24))) == 13 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(25))) == 51 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(25))) == 13 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(26))) == 53 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(26))) == 9 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(27))) == 54 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(27))) == 13 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(28))) == 55 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(28))) == 9 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(29))) == 59 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(29))) == 5 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(30))) == 61 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(30))) == 9 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(31))) == 63 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(31))) == 9 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(32))) == 64 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(32))) == 13 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(33))) == 65 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(33))) == 13 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(34))) == 66 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(34))) == 17 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(35))) == 68 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(35))) == 13 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(36))) == 69 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(36))) == 17 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(37))) == 73 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(37))) == 9 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(38))) == 74 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(38))) == 13 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(39))) == 75 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(39))) == 13 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(40))) == 76 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(40))) == 17 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(41))) == 78 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(41))) == 13 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(42))) == 79 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(42))) == 17 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(43))) == 83 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(43))) == 9 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(44))) == 84 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(44))) == 13 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(45))) == 85 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(45))) == 16 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(46))) == 86 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(46))) == 20 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(47))) == 88 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(47))) == 16 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(48))) == 89 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(48))) == 20 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(49))) == 95 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(49))) == 5 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(50))) == 96 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(50))) == 9 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(51))) == 97 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(51))) == 13 ? 1 : 0) != 0);
    }

    public void testLocationWithoutNS() throws Exception {
        URL baseURL = Platform.getBundle((String)"org.eclipse.stp.sc.xmlvalidator.test").getEntry("/");
        URL fileURL = new URL(baseURL, TEST_XML_WITHOUT_NS_FILE);
        Document doc = this.parser.parse(fileURL.openStream());
        List elementList = XMLUtils.getElementList((Document)doc);
        DomLocationParserTest.assertTrue((elementList.size() == 4 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(0))) == 3 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(1))) == 4 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(2))) == 6 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getLineNumber((Element)((Element)elementList.get(3))) == 10 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(0))) == 1 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(1))) == 5 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(2))) == 7 ? 1 : 0) != 0);
        DomLocationParserTest.assertTrue((DomLocationParser.getColumnNumber((Element)((Element)elementList.get(3))) == 7 ? 1 : 0) != 0);
    }
}

