/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.xmlvalidator.rule.parser;

import java.net.URL;
import java.util.Hashtable;
import junit.framework.TestCase;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stp.sc.xmlvalidator.rule.model.VRuleDef;
import org.eclipse.stp.sc.xmlvalidator.rule.parser.RuleXmlParser;

public class RuleXmlParserTest
extends TestCase {
    RuleXmlParser parser = new RuleXmlParser();
    private static final String TEST_RULE_FILE = "/src/resources/JAX_WS_VRules.xml";
    private static final String WRONG_RULE_FILE = "/src/resources/Wrong_VRules.xml";
    private static final String INVALIDATE_RULE_FILE = "/src/resources/Invalid_VRules.xml";
    Hashtable<String, VRuleDef> ruleSet;

    protected void setUp() throws Exception {
        super.setUp();
        this.ruleSet = new Hashtable();
        URL baseURL = Platform.getBundle((String)"org.eclipse.stp.sc.xmlvalidator.test").getEntry("/");
        URL fileURL = new URL(baseURL, TEST_RULE_FILE);
        this.parser.loadRuleFile(fileURL.openStream(), this.ruleSet);
        URL wrongFileURL = new URL(baseURL, WRONG_RULE_FILE);
        this.parser.loadRuleFile(wrongFileURL.openStream(), this.ruleSet);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testLoadRuleTest() throws Exception {
        RuleXmlParserTest.assertEquals((String)"should load rules in desc", (int)this.ruleSet.size(), (int)4);
        String ruleID = "jaxws_rule_soapbind";
        VRuleDef def = this.ruleSet.get(ruleID);
        RuleXmlParserTest.assertTrue((String)"check rule id", (boolean)def.getId().equals(ruleID));
        RuleXmlParserTest.assertTrue((String)"check rule context", (boolean)def.getContextNode().equals("/Class/SOAPBinding"));
    }

    public void testWrongRuleFile() throws Exception {
        Hashtable ruleSet = new Hashtable();
        URL baseURL = Platform.getBundle((String)"org.eclipse.stp.sc.xmlvalidator.test").getEntry("/");
        URL fileURL = new URL(baseURL, INVALIDATE_RULE_FILE);
        this.parser.loadRuleFile(fileURL.openStream(), ruleSet);
        RuleXmlParserTest.assertEquals((int)ruleSet.size(), (int)0);
    }

    public void testWrongRuleXPathExp() throws Exception {
        VRuleDef def = this.ruleSet.get("wrong_xpath_exp");
        RuleXmlParserTest.assertNull((String)"check rule id", (Object)def);
    }

    public void testNullContextNode() throws Exception {
        VRuleDef def = this.ruleSet.get("wrong_rule_without_context");
        RuleXmlParserTest.assertNull((String)"check rule id", (Object)def);
    }
}

