/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.core;

import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.util.Assert;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.IRuntimeDefinition;
import org.eclipse.stp.soas.deploy.core.ISupportedTechnologyType;
import org.eclipse.stp.soas.deploy.core.ITechnologyDefinition;
import org.eclipse.stp.soas.deploy.core.ITechnologyMap;
import org.eclipse.stp.soas.deploy.core.IVersion;
import org.eclipse.stp.soas.internal.deploy.core.PackageExtensionException;

public class RuntimeDefinition
implements IRuntimeDefinition,
Comparable {
    public static final String ATTR_ID = "id";
    private IConfigurationElement mElement;
    private String mID;
    private SortedMap mSupportingRuntimeVersionssByTechnologyDef;
    private SortedMap mTechnologyMapsByRuntimeVersion;

    public RuntimeDefinition(IConfigurationElement element) throws PackageExtensionException {
        this.init(element);
        this.mSupportingRuntimeVersionssByTechnologyDef = new TreeMap();
        this.mTechnologyMapsByRuntimeVersion = new TreeMap(new DecendingVersionOrder());
    }

    public String getID() {
        return this.mID;
    }

    public ITechnologyMap[] getTechnologyMaps() {
        return this.mTechnologyMapsByRuntimeVersion.values().toArray(new ITechnologyMap[0]);
    }

    public ITechnologyMap getTechnologyMap(IVersion runtimeVersion) {
        ITechnologyMap techMap;
        Iterator it = this.mTechnologyMapsByRuntimeVersion.tailMap(runtimeVersion).values().iterator();
        if (it.hasNext()) {
            techMap = (ITechnologyMap)it.next();
            if (!techMap.getRuntimeVersion().isCompatibleWithVersion(runtimeVersion, techMap.getVersionMatchRule())) {
                techMap = null;
            }
        } else {
            techMap = null;
        }
        return techMap;
    }

    public IVersion[] getSupportingRuntimeVersions(ITechnologyDefinition techDef) {
        return this.getSupportingRuntimeVersionsSet(techDef).toArray(new IVersion[0]);
    }

    void addTechnologyMap(ITechnologyMap itm) throws PackageExtensionException {
        Assert.isTrue((boolean)itm.getRuntimeDefinition().equals(this));
        if (this.mTechnologyMapsByRuntimeVersion.containsKey(itm.getRuntimeVersion())) {
            if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
                System.err.println(DeployCorePlugin.getDefault().getResourceString("RuntimeDefinition.trace.error.duplicateTechnologyMap", new Object[]{this.mID, itm.getRuntimeVersion()}));
                System.err.flush();
            }
            throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("RuntimeDefinition.exception.duplicateTechnologyMap"));
        }
        this.mTechnologyMapsByRuntimeVersion.put(itm.getRuntimeVersion(), itm);
        this.addTechnologiesToList(itm);
    }

    private void addTechnologiesToList(ITechnologyMap itm) {
        ISupportedTechnologyType[] techTypes = itm.getSupportedTechnologyTypes();
        int index = 0;
        int count = techTypes.length;
        while (index < count) {
            ITechnologyDefinition techDef = techTypes[index].getTechnologyDefinition();
            SortedSet runtimeVersions = this.getSupportingRuntimeVersionsSet(techDef);
            runtimeVersions.add(itm.getRuntimeVersion());
            ++index;
        }
    }

    private SortedSet getSupportingRuntimeVersionsSet(ITechnologyDefinition techDef) {
        TreeSet runtimeVersions = (TreeSet)this.mSupportingRuntimeVersionssByTechnologyDef.get(techDef);
        if (runtimeVersions == null) {
            runtimeVersions = new TreeSet(new DecendingVersionOrder());
            this.mSupportingRuntimeVersionssByTechnologyDef.put(techDef, runtimeVersions);
        }
        return runtimeVersions;
    }

    private void init(IConfigurationElement element) throws PackageExtensionException {
        this.mElement = element;
        this.mID = element.getAttribute(ATTR_ID);
        if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
            System.out.println(DeployCorePlugin.getDefault().getResourceString("ServerDefinition.trace.error.serverDefinitionParseError", new Object[]{this.getID()}));
            System.out.flush();
        }
        if (this.mID == null) {
            throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("ServerDefinition.exception.idNotSpecified"));
        }
    }

    public int compareTo(Object o) {
        return this.getID().compareTo(((RuntimeDefinition)o).getID());
    }

    public boolean equals(Object obj) {
        boolean retVal = this == obj ? true : (obj instanceof RuntimeDefinition ? this.getID().equals(((RuntimeDefinition)obj).getID()) : false);
        return retVal;
    }

    public int hashCode() {
        return this.mID.hashCode();
    }

    private static class DecendingVersionOrder
    implements Comparator {
        private DecendingVersionOrder() {
        }

        public int compare(Object o1, Object o2) {
            return -((Comparable)o1).compareTo(o2);
        }
    }
}

