/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.editor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.stp.ui.xef.editor.XMLProviderEditorInput;
import org.eclipse.stp.xef.IXMLProvider;
import org.eclipse.stp.xef.XPathXMLProvider;
import org.eclipse.stp.xef.util.InputStreamHelper;
import org.eclipse.stp.xef.util.TestProject;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class XMLProviderEditorInputTest
extends TestCase {
    private TestProject testProject;

    protected void setUp() throws Exception {
        this.testProject = new TestProject();
    }

    protected void tearDown() throws Exception {
        this.testProject.dispose();
    }

    public void testEquals() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><policies>  <example:audit xmlns:example=\"http://www.example.com/xsd/2006/02/audit\" />  <example:logging xmlns:example=\"http://www.example.com/xsd/2006/02/logging\" level=\"Warning\">    <example:FileLogger>      <Header />      <LinePrefix />      <Footer />    </example:FileLogger>  </example:logging>  <example:max_invocation_time xmlns:example=\"http://www.example.com/xsd/2006/02/monitoring\" /> </policies>";
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test.file"));
        file.create((InputStream)new ByteArrayInputStream(xml.getBytes()), true, null);
        XMLProviderEditorInput inputOne = new XMLProviderEditorInput("Some title one", file.getProject(), (IXMLProvider)new XPathXMLProvider(file, "//*[local-name()='logging' and namespace-uri()='http://www.example.com/xsd/2006/02/logging']", "policies"), null, null);
        XMLProviderEditorInput inputTwo = new XMLProviderEditorInput("Some title two", file.getProject(), (IXMLProvider)new XPathXMLProvider(file, "//*[local-name()='logging' and namespace-uri()='http://www.example.com/xsd/2006/02/logging']", "policies"), null, null);
        XMLProviderEditorInputTest.assertFalse((boolean)inputOne.equals((Object)inputTwo));
    }

    public void testEditorInput() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><policies>  <example:audit xmlns:example=\"http://www.example.com/xsd/2006/02/audit\" />  <example:logging xmlns:example=\"http://www.example.com/xsd/2006/02/logging\" level=\"Warning\">    <example:FileLogger>      <Header />      <LinePrefix />      <Footer />    </example:FileLogger>  </example:logging>  <example:max_invocation_time xmlns:example=\"http://www.example.com/xsd/2006/02/monitoring\" /> </policies>";
        IFile file = this.testProject.getProject().getFile((IPath)new Path("test.file"));
        file.create((InputStream)new ByteArrayInputStream(xml.getBytes()), true, null);
        XMLProviderEditorInput input = new XMLProviderEditorInput("Some title", file.getProject(), (IXMLProvider)new XPathXMLProvider(file, "//*[local-name()='logging' and namespace-uri()='http://www.example.com/xsd/2006/02/logging']", "policies"), null, null);
        IFile tempFile = input.getFile();
        XMLProviderEditorInputTest.assertFalse((String)"Temp file should be different", (boolean)file.getLocation().toOSString().equals(input.getFile().getLocation().toOSString()));
        String tempXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><policies>  <example:logging xmlns:example=\"http://www.example.com/xsd/2006/02/logging\" level=\"Warning\">    <example:FileLogger>      <Header />      <LinePrefix />      <Footer />    </example:FileLogger>  </example:logging></policies>";
        XMLProviderEditorInputTest.assertEquals((String)XMLProviderEditorInputTest.normXML(tempXML), (String)XMLProviderEditorInputTest.normXML(this.getIFileContents(tempFile)));
        String modXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><policies>  <example:logging xmlns:example=\"http://www.example.com/xsd/2006/02/logging\" level=\"Error\"/>  <example:logging xmlns:example=\"http://www.example.com/xsd/2006/02/logging\" level=\"Warning\">    <example:ConsoleLogger/>  </example:logging></policies>";
        tempFile.setContents((InputStream)new ByteArrayInputStream(modXML.getBytes()), true, false, (IProgressMonitor)new NullProgressMonitor());
        tempFile.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        input.propagate();
        String targetXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><policies>  <example:audit xmlns:example=\"http://www.example.com/xsd/2006/02/audit\" />  <example:logging xmlns:example=\"http://www.example.com/xsd/2006/02/logging\" level=\"Error\"/>  <example:logging xmlns:example=\"http://www.example.com/xsd/2006/02/logging\" level=\"Warning\">    <example:ConsoleLogger/>  </example:logging>  <example:max_invocation_time xmlns:example=\"http://www.example.com/xsd/2006/02/monitoring\" /> </policies>";
        XMLProviderEditorInputTest.assertEquals((String)XMLProviderEditorInputTest.normXML(targetXML), (String)XMLProviderEditorInputTest.normXML(this.getIFileContents(file)));
    }

    private String getIFileContents(IFile tempFile) throws IOException, CoreException {
        InputStream is = tempFile.getContents();
        try {
            String string = new String(InputStreamHelper.drain((InputStream)is));
            return string;
        }
        finally {
            is.close();
        }
    }

    private static String normXML(String s) throws JDOMException, IOException {
        String s2 = XMLProviderEditorInputTest.stripComment(s);
        String s3 = XMLProviderEditorInputTest.stripProlog(s2);
        Document d = new SAXBuilder().build((InputStream)new ByteArrayInputStream(s3.getBytes()));
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        return outputter.outputString(d);
    }

    private static String stripComment(String s) {
        return s.replaceAll("<!--(.*?)-->", "");
    }

    private static String stripProlog(String s) {
        return s.replaceAll("<\\?(.*?)\\?>", "");
    }
}

