/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.editor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.net.URL;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.ui.xef.editor.XMLProviderEditorInput;
import org.eclipse.stp.xef.DocumentNamespaceContext;
import org.eclipse.stp.xef.ISchemaProvider;
import org.eclipse.stp.xef.IXMLProvider;
import org.eclipse.stp.xef.URLSchemaProvider;
import org.eclipse.stp.xef.XMLSnippet;
import org.eclipse.stp.xef.XPathXMLProvider;
import org.eclipse.stp.xef.util.InputStreamHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSSerializer;

public class XMLXPathView
extends ViewPart
implements ISelectionListener {
    private Label fileLabel;
    private Label schemasLabel;
    private Text xpath;
    private IFile selectedFile;

    static {
        System.setProperty("org.w3c.dom.DOMImplementationSourceList", "org.apache.xerces.dom.DOMXSImplementationSourceImpl");
    }

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        ScrolledForm form = toolkit.createScrolledForm(parent);
        form.setText("Select portion of file to edit");
        GridLayout layout = new GridLayout(2, false);
        form.getBody().setLayout((Layout)layout);
        toolkit.createLabel(form.getBody(), "File:");
        this.fileLabel = toolkit.createLabel(form.getBody(), "");
        this.fileLabel.setLayoutData((Object)new GridData(768));
        toolkit.createLabel(form.getBody(), "Schema Location:");
        this.schemasLabel = toolkit.createLabel(form.getBody(), "");
        this.schemasLabel.setLayoutData((Object)new GridData(768));
        toolkit.createLabel(form.getBody(), "XPath:");
        this.xpath = toolkit.createText(form.getBody(), "//wsp:All");
        this.xpath.setLayoutData((Object)new GridData(768));
        Button edit = toolkit.createButton(form.getBody(), "Edit", 8);
        edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ISchemaProvider sp = XMLXPathView.this.getSchemaProvider();
                    IDE.openEditor((IWorkbenchPage)XMLXPathView.this.getSite().getWorkbenchWindow().getActivePage(), (IEditorInput)new XMLProviderEditorInput("Elements of " + XMLXPathView.this.selectedFile.getName(), XMLXPathView.this.selectedFile.getProject(), (IXMLProvider)new XPathXMLProvider(XMLXPathView.this.selectedFile, XMLXPathView.this.xpath.getText(), XMLXPathView.this.testXPath(false)), sp, null), (String)"org.eclipse.stp.ui.xef.editor.XefEditor");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        Button test = toolkit.createButton(form.getBody(), "Test", 8);
        test.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLXPathView.this.testXPath(true);
            }
        });
        toolkit.paintBordersFor(form.getBody());
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        ISelection selection = this.getSite().getPage().getSelection();
        if (selection != null) {
            this.selectionChanged(null, selection);
        }
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
    }

    protected ISchemaProvider getSchemaProvider() throws Exception {
        File[] files = this.selectedFile.getRawLocation().toFile().getParentFile().listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".xsd");
            }
        });
        URL[] urls = new URL[files.length];
        int i = 0;
        while (i < urls.length) {
            urls[i] = files[i].toURI().toURL();
            ++i;
        }
        File[] snippetFiles = this.selectedFile.getRawLocation().toFile().getParentFile().listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".sxml");
            }
        });
        XMLSnippet[] snippets = new XMLSnippet[snippetFiles.length];
        int i2 = 0;
        while (i2 < snippets.length) {
            FileInputStream fs = new FileInputStream(snippetFiles[i2]);
            try {
                snippets[i2] = new XMLSnippet(snippetFiles[i2].getName(), new String(InputStreamHelper.drain((InputStream)fs)));
            }
            finally {
                InputStreamHelper.close((InputStream)fs);
            }
            ++i2;
        }
        return new URLSchemaProvider(urls, snippets);
    }

    public void setFocus() {
        this.xpath.setFocus();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object o;
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            this.selectedFile = (IFile)o;
            this.fileLabel.setText(this.selectedFile.getRawLocation().toFile().toString());
            this.schemasLabel.setText(String.valueOf(this.selectedFile.getRawLocation().toFile().getParent()) + File.separator + "*.xsd");
        }
    }

    private String testXPath(boolean show) {
        String qname = null;
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS domLS = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSParser lsParser = domLS.createLSParser((short)1, null);
            LSSerializer lsSerializer = domLS.createLSSerializer();
            DOMConfiguration config = lsSerializer.getDomConfig();
            config.setParameter("format-pretty-print", true);
            Document doc = lsParser.parseURI(new File(this.fileLabel.getText()).toURI().toString());
            XPath xp = XPathFactory.newInstance().newXPath();
            xp.setNamespaceContext((NamespaceContext)new DocumentNamespaceContext(doc));
            NodeList nodes = (NodeList)xp.evaluate(this.xpath.getText(), doc, XPathConstants.NODESET);
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                if (qname == null) {
                    qname = new QName(node.getNamespaceURI(), node.getLocalName()).toString();
                }
                sb.append(lsSerializer.writeToString(node));
                ++i;
            }
            if (show) {
                MessageBox mbx = new MessageBox(this.getSite().getShell());
                mbx.setMessage(sb.toString());
                mbx.setText(qname);
                mbx.open();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return qname;
    }
}

