/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.schema;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.stp.ui.xef.schema.SchemaElement;
import org.eclipse.stp.ui.xef.schema.SchemaRegistry;
import org.eclipse.stp.xef.ISchemaProvider;
import org.eclipse.stp.xef.URLSchemaProvider;

public class SchemaElementTest
extends TestCase {
    public void testQualifiers() throws Exception {
        URL u1 = ((Object)((Object)this)).getClass().getResource("/example_test_corba.xsd");
        URL u2 = ((Object)((Object)this)).getClass().getResource("/example_test_soap.xsd");
        URL u3 = ((Object)((Object)this)).getClass().getResource("/example_test_http.xsd");
        URL u4 = ((Object)((Object)this)).getClass().getResource("/example_test_secure.xsd");
        URL u5 = ((Object)((Object)this)).getClass().getResource("/example_test_compression.xsd");
        URLSchemaProvider provider = new URLSchemaProvider(new URL[]{u1, u2, u3, u4, u5});
        SchemaElement corba = SchemaRegistry.getDefault().getSchemaElement("http://www.example.com/xsd/2007/05/test_corba", "corba", false, new ISchemaProvider[]{provider});
        SchemaElement soap = SchemaRegistry.getDefault().getSchemaElement("http://www.example.com/xsd/2007/02/test_soap", "soap", false, new ISchemaProvider[]{provider});
        SchemaElement http = SchemaRegistry.getDefault().getSchemaElement("http://www.example.com/xsd/2007/02/test_http", "http", false, new ISchemaProvider[]{provider});
        SchemaElement secure = SchemaRegistry.getDefault().getSchemaElement("http://www.example.com/xsd/2006/02/test_secure", "secure", false, new ISchemaProvider[]{provider});
        SchemaElement comp = SchemaRegistry.getDefault().getSchemaElement("http://www.example.com/xsd/2007/02/test_compression", "compression", false, new ISchemaProvider[]{provider});
        Set<String> transport = Collections.singleton("transport");
        Set<String> binding = Collections.singleton("binding");
        HashSet<String> bindingTransport = new HashSet<String>(transport);
        bindingTransport.addAll(binding);
        SchemaElementTest.assertEquals(bindingTransport, corba.getQualifiers().keySet());
        SchemaElementTest.assertFalse((boolean)((Boolean)corba.getQualifiers().get("transport")));
        SchemaElementTest.assertFalse((boolean)((Boolean)corba.getQualifiers().get("binding")));
        SchemaElementTest.assertEquals(binding, soap.getQualifiers().keySet());
        SchemaElementTest.assertFalse((boolean)((Boolean)soap.getQualifiers().get("binding")));
        SchemaElementTest.assertNull(soap.getQualifiers().get("transport"));
        SchemaElementTest.assertEquals(transport, http.getQualifiers().keySet());
        SchemaElementTest.assertNull(http.getQualifiers().get("binding"));
        SchemaElementTest.assertFalse((boolean)((Boolean)http.getQualifiers().get("transport")));
        SchemaElementTest.assertEquals(Collections.emptySet(), secure.getQualifiers().keySet());
        SchemaElementTest.assertEquals(Collections.singleton("qos"), comp.getQualifiers().keySet());
        SchemaElementTest.assertTrue((boolean)((Boolean)comp.getQualifiers().get("qos")));
    }

    public void testRequires() throws Exception {
        URL u1 = ((Object)((Object)this)).getClass().getResource("/example_test_http.xsd");
        URL u2 = ((Object)((Object)this)).getClass().getResource("/example_test_https.xsd");
        URLSchemaProvider provider = new URLSchemaProvider(new URL[]{u1, u2});
        SchemaElement https = SchemaRegistry.getDefault().getSchemaElement("http://www.example.com/xsd/2007/02/test_https", "https", false, new ISchemaProvider[]{provider});
        SchemaElement http = SchemaRegistry.getDefault().getSchemaElement("http://www.example.com/xsd/2007/02/test_http", "http", false, new ISchemaProvider[]{provider});
        ArrayList<List<String>> expected = new ArrayList<List<String>>();
        expected.add(Arrays.asList("{http://www.example.com/xsd/2007/02/test_http}http", "{http://www.example.com/xsd/2007/02/test_soap}soap"));
        expected.add(Arrays.asList("{http://www.example.com/xsd/2007/05/test_corba}corba"));
        SchemaElementTest.assertEquals(expected, (Object)https.getRequires());
        SchemaElementTest.assertEquals((int)0, (int)http.getRequires().size());
    }
}

