/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.xef;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.stp.xef.FilterSchemaProvider;
import org.eclipse.stp.xef.ISchemaProvider;

public class FilterSchemaProviderTest
extends TestCase {
    public void testFilterSchemaProvider() {
        TestSchemaProvider tsp = new TestSchemaProvider();
        this.addContent(tsp);
        FilterSchemaProvider filter = FilterSchemaProvider.createSchemaFilter((ISchemaProvider)tsp, (String[])new String[]{"http://www.acme.com/456"});
        Collection namespaces = filter.listSchemaNamespaces(null);
        FilterSchemaProviderTest.assertEquals((int)1, (int)namespaces.size());
        FilterSchemaProviderTest.assertEquals((String)"http://www.acme.com/123", (String)((String)namespaces.iterator().next()));
        FilterSchemaProviderTest.assertEquals((String)"<acme1/>", (String)filter.getSchema("http://www.acme.com/123"));
        FilterSchemaProviderTest.assertNull((Object)filter.getSchema("http://www.acme.com/456"));
        Collection snippets = filter.listSnippets(null);
        FilterSchemaProviderTest.assertEquals((int)2, (int)snippets.size());
        FilterSchemaProviderTest.assertTrue((boolean)snippets.contains("Snip1"));
        FilterSchemaProviderTest.assertTrue((boolean)snippets.contains("Snip 2"));
    }

    public void testFilterSnippetProvider() {
        TestSchemaProvider tsp = new TestSchemaProvider();
        this.addContent(tsp);
        FilterSchemaProvider filter = FilterSchemaProvider.createSnippetFilter((ISchemaProvider)tsp, (String[])new String[]{"Snip1"});
        Collection namespaces = filter.listSchemaNamespaces(null);
        FilterSchemaProviderTest.assertEquals((int)2, (int)namespaces.size());
        FilterSchemaProviderTest.assertTrue((boolean)namespaces.contains("http://www.acme.com/123"));
        FilterSchemaProviderTest.assertTrue((boolean)namespaces.contains("http://www.acme.com/456"));
        Collection snippets = filter.listSnippets(null);
        FilterSchemaProviderTest.assertEquals((int)1, (int)snippets.size());
        FilterSchemaProviderTest.assertTrue((boolean)snippets.contains("Snip 2"));
        FilterSchemaProviderTest.assertNull((Object)filter.getSnippet("Snip1"));
        FilterSchemaProviderTest.assertEquals((String)"bcbc", (String)filter.getSnippet("Snip 2"));
    }

    public void testRefresh() {
        TestSchemaProvider tsp = new TestSchemaProvider();
        FilterSchemaProviderTest.assertFalse((String)"Precondition failed", (boolean)tsp.refreshCalled);
        FilterSchemaProvider filter = FilterSchemaProvider.createSnippetFilter((ISchemaProvider)tsp, (String[])new String[]{"Snip1"});
        filter.refresh();
        FilterSchemaProviderTest.assertTrue((boolean)tsp.refreshCalled);
    }

    private void addContent(TestSchemaProvider tsp) {
        tsp.schemas.put("http://www.acme.com/123", "<acme1/>");
        tsp.schemas.put("http://www.acme.com/456", "<acme2/>");
        tsp.snippets.put("Snip1", "aba");
        tsp.snippets.put("Snip 2", "bcbc");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestSchemaProvider
    implements ISchemaProvider {
        private Map<String, String> schemas = new LinkedHashMap<String, String>();
        private Map<String, String> snippets = new LinkedHashMap<String, String>();
        private boolean refreshCalled = false;

        private TestSchemaProvider() {
        }

        public String getSchema(String qname) {
            return this.schemas.get(qname);
        }

        public String getSnippet(String name) {
            return this.snippets.get(name);
        }

        public Collection<String> listSchemaNamespaces(String filter) {
            return this.schemas.keySet();
        }

        public Collection<String> listSnippets(String filter) {
            return this.snippets.keySet();
        }

        public void refresh() {
            this.refreshCalled = true;
        }
    }
}

