/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.editor;

import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.stp.ui.xef.PluginResources;
import org.eclipse.stp.ui.xef.editor.AbstractFieldEditor;
import org.eclipse.stp.xef.util.QNameHelper;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class QNameFieldEditor
extends AbstractFieldEditor {
    public static final QNameFieldEditor SINGLETON = new QNameFieldEditor();
    protected Combo cboPrefix;
    protected Text txtNamespace;
    protected Text txtLocal;
    protected Button btnOk;
    private Map<String, String> nsMap;
    private String strQName;

    public QNameFieldEditor() {
        this(null);
    }

    public QNameFieldEditor(Shell parent) {
        super(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        area.setLayout((Layout)gridLayout);
        Label lblInstructions = new Label(area, 0);
        lblInstructions.setText(PluginResources.getString("qname.info"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        lblInstructions.setLayoutData((Object)gridData);
        Label lblPrefix = new Label(area, 16384);
        lblPrefix.setText(PluginResources.getString("qname.prefix"));
        this.cboPrefix = new Combo(area, 2048);
        this.cboPrefix.setItems(this.nsMap.keySet().toArray(new String[this.nsMap.keySet().size()]));
        this.cboPrefix.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Combo combo = (Combo)event.widget;
                String selItem = combo.getText();
                if (QNameFieldEditor.this.nsMap.containsKey(selItem)) {
                    QNameFieldEditor.this.txtNamespace.setEditable(false);
                    QNameFieldEditor.this.txtNamespace.setText((String)QNameFieldEditor.this.nsMap.get(selItem));
                } else if (!QNameFieldEditor.this.txtNamespace.getEditable()) {
                    QNameFieldEditor.this.txtNamespace.setText("");
                    QNameFieldEditor.this.txtNamespace.setEditable(true);
                }
                QNameFieldEditor.this.updateDialogState();
            }
        });
        Label lblNamespaceName = new Label(area, 16384);
        lblNamespaceName.setText(PluginResources.getString("qname.namespace"));
        this.txtNamespace = new Text(area, 2048);
        this.txtNamespace.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                QNameFieldEditor.this.txtNamespace.setToolTipText(QNameFieldEditor.this.txtNamespace.getText());
                QNameFieldEditor.this.updateDialogState();
            }
        });
        gridData = new GridData();
        gridData.widthHint = 200;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.txtNamespace.setLayoutData((Object)gridData);
        Label lblLocalName = new Label(area, 16384);
        lblLocalName.setText(PluginResources.getString("qname.local"));
        this.txtLocal = new Text(area, 2048);
        this.txtLocal.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                QNameFieldEditor.this.updateDialogState();
            }
        });
        gridData = new GridData();
        gridData.widthHint = 200;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.txtLocal.setLayoutData((Object)gridData);
        return area;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(PluginResources.getString("qname.label"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btnOk = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.btnOk.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void updateDialogState() {
        if (this.btnOk != null) {
            this.btnOk.setEnabled(this.isDialogComplete());
        }
    }

    private boolean isDialogComplete() {
        if (this.cboPrefix.getText().length() == 0) {
            return false;
        }
        if (this.txtNamespace.getText().length() == 0) {
            return false;
        }
        return this.txtLocal.getText().length() != 0;
    }

    protected void okPressed() {
        if (this.createQName()) {
            super.okPressed();
        }
    }

    protected boolean createQName() {
        if (this.txtNamespace.getEditable()) {
            this.nsMap.put(this.cboPrefix.getText(), this.txtNamespace.getText());
        }
        this.strQName = QNameHelper.convertToQName(this.cboPrefix.getText(), this.txtLocal.getText());
        return true;
    }

    public void setFieldData(Object data) {
        if (data instanceof Map) {
            this.nsMap = (Map)data;
        }
    }

    public void setFieldText(String text) {
        if (this.cboPrefix != null) {
            this.cboPrefix.setText(QNameHelper.getPrefixFromQName(text));
        }
        if (this.txtLocal != null) {
            this.txtLocal.setText(QNameHelper.getLocalFromQName(text));
        }
    }

    public String getFieldText() {
        return this.strQName;
    }
}

