/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.editor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class TextFieldVerifyListener
implements VerifyListener {
    private static final Logger LOG = Logger.getLogger(TextFieldVerifyListener.class.getName());
    private String pattern;

    public TextFieldVerifyListener(String p) {
        this.pattern = p;
    }

    public void verifyText(VerifyEvent event) {
        LOG.log(Level.FINE, "TEST - verifyText");
        LOG.log(Level.FINE, "   event.text: " + event.text);
        LOG.log(Level.FINE, "   event.text.length: " + event.text.length());
        LOG.log(Level.FINE, "   event.character: " + event.character);
        LOG.log(Level.FINE, "   event.keyCode: " + event.keyCode);
        if (event.keyCode == 0) {
            return;
        }
        if (!(event.widget instanceof Combo) && !(event.widget instanceof Text)) {
            return;
        }
        Combo combo = null;
        String curText = "";
        if (event.widget instanceof Combo) {
            combo = (Combo)event.widget;
            curText = combo.getText();
        } else {
            Text text = (Text)event.widget;
            curText = text.getText();
        }
        String newText = String.valueOf(curText.substring(0, event.start)) + event.text + curText.substring(event.end, curText.length());
        if (newText.length() == 0 && !Character.isISOControl(event.character)) {
            newText = String.valueOf(newText) + event.character;
        }
        if (combo != null) {
            String[] presetItems = combo.getItems();
            int i = 0;
            while (i < presetItems.length) {
                if (presetItems[i].equals(newText)) {
                    return;
                }
                ++i;
            }
        }
        if (this.pattern != null && newText.length() != 0 && !newText.matches(this.pattern)) {
            event.doit = false;
            return;
        }
    }
}

