/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.compiler;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Switches;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceException;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceTranslator;
import org.eclipse.stp.b2j.core.jengine.internal.utils.TranslatorUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class Util {
    private HashMap ncmappings = null;
    private HashMap qmappings = null;
    private String program_prefix;
    private Switches switches;
    private HashMap nicepkgs = new HashMap();
    private HashMap nicenames = new HashMap();
    private HashMap line_hashmap = new HashMap();
    private HashMap path_hashmap = new HashMap();
    private String bpel_source;
    public static final String plugin_package = "org.eclipse.stp.b2j.core";
    public static final String jengine_package = "org.eclipse.stp.b2j.core.jengine.internal";
    public static final String jenginec_package = "org.eclipse.stp.b2j.core.jengine.internal.compiler";
    private static String[][] xsd_mappings;
    private static String[][] java_mappings;

    static {
        String[][] stringArrayArray = new String[46][];
        String[] stringArray = new String[2];
        stringArray[0] = "xsd:string";
        stringArrayArray[0] = stringArray;
        stringArrayArray[1] = new String[]{"xsd:normalizedString", "string"};
        stringArrayArray[2] = new String[]{"xsd:token", "string"};
        stringArrayArray[3] = new String[]{"xsd:byte", "int"};
        stringArrayArray[4] = new String[]{"xsd:unsignedByte", "int"};
        stringArrayArray[5] = new String[]{"xsd:base64Binary", "string"};
        stringArrayArray[6] = new String[]{"xsd:hexBinary", "string"};
        stringArrayArray[7] = new String[]{"xsd:integer", "int"};
        stringArrayArray[8] = new String[]{"xsd:positiveInteger", "int"};
        stringArrayArray[9] = new String[]{"xsd:negativeInteger", "int"};
        stringArrayArray[10] = new String[]{"xsd:nonPositiveInteger", "int"};
        stringArrayArray[11] = new String[]{"xsd:nonNegativeInteger", "int"};
        String[] stringArray2 = new String[2];
        stringArray2[0] = "xsd:int";
        stringArrayArray[12] = stringArray2;
        stringArrayArray[13] = new String[]{"xsd:unsignedInt", "long"};
        String[] stringArray3 = new String[2];
        stringArray3[0] = "xsd:long";
        stringArrayArray[14] = stringArray3;
        stringArrayArray[15] = new String[]{"xsd:unsignedLong", "long"};
        stringArrayArray[16] = new String[]{"xsd:short", "int"};
        stringArrayArray[17] = new String[]{"xsd:unsignedShort", "int"};
        stringArrayArray[18] = new String[]{"xsd:decimal", "double"};
        stringArrayArray[19] = new String[]{"xsd:float", "double"};
        String[] stringArray4 = new String[2];
        stringArray4[0] = "xsd:double";
        stringArrayArray[20] = stringArray4;
        String[] stringArray5 = new String[2];
        stringArray5[0] = "xsd:boolean";
        stringArrayArray[21] = stringArray5;
        stringArrayArray[22] = new String[]{"xsd:time", "date"};
        stringArrayArray[23] = new String[]{"xsd:dateTime", "date"};
        stringArrayArray[24] = new String[]{"xsd:duration", "long"};
        String[] stringArray6 = new String[2];
        stringArray6[0] = "xsd:date";
        stringArrayArray[25] = stringArray6;
        stringArrayArray[26] = new String[]{"xsd:gMonth", "date"};
        stringArrayArray[27] = new String[]{"xsd:gYear", "date"};
        stringArrayArray[28] = new String[]{"xsd:gYearMonth", "date"};
        stringArrayArray[29] = new String[]{"xsd:gDay", "date"};
        stringArrayArray[30] = new String[]{"xsd:gMonthDay", "date"};
        stringArrayArray[31] = new String[]{"xsd:Name", "string"};
        stringArrayArray[32] = new String[]{"xsd:QName", "string"};
        stringArrayArray[33] = new String[]{"xsd:NCName", "string"};
        stringArrayArray[34] = new String[]{"xsd:anyURI", "string"};
        stringArrayArray[35] = new String[]{"xsd:language", "string"};
        stringArrayArray[36] = new String[]{"xsd:ID", "string"};
        stringArrayArray[37] = new String[]{"xsd:IDREF", "string"};
        stringArrayArray[38] = new String[]{"xsd:IDREFS", "string"};
        stringArrayArray[39] = new String[]{"xsd:ENTITY", "string"};
        stringArrayArray[40] = new String[]{"xsd:ENTITIES", "string"};
        stringArrayArray[41] = new String[]{"xsd:NOTATION", "string"};
        stringArrayArray[42] = new String[]{"xsd:NMTOKEN", "string"};
        stringArrayArray[43] = new String[]{"xsd:NMTOKENS", "string"};
        String[] stringArray7 = new String[2];
        stringArray7[0] = "xsd:list";
        stringArrayArray[44] = stringArray7;
        String[] stringArray8 = new String[2];
        stringArray8[0] = "xsd:anyType";
        stringArrayArray[45] = stringArray8;
        xsd_mappings = stringArrayArray;
        java_mappings = new String[][]{{"string", "java.lang.String"}, {"int", "java.lang.Integer"}, {"long", "java.lang.Long"}, {"double", "java.lang.Double"}, {"boolean", "java.lang.Boolean"}, {"date", "java.util.GregorianCalendar"}, {"list", "java.util.List"}};
    }

    public Util(String program_prefix, Switches switches) {
        this.program_prefix = program_prefix;
        this.switches = switches;
    }

    public void setBpelSource(String source, Document doc) {
        this.bpel_source = source;
        this.buildPathMap(doc);
        try {
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.setOutputProperty("indent", "no");
            LineTracker linetracker = new LineTracker(this.line_hashmap, this.path_hashmap);
            SAXSource ssource = new SAXSource(new InputSource(new StringReader(source)));
            SAXResult result = new SAXResult(linetracker);
            tf.transform(ssource, result);
        }
        catch (TransformerException e) {
            e.getException().printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void buildPathMap(Node node) {
        try {
            int[] stack = Util.getStackTrace(node);
            this.path_hashmap.put(node, stack);
            this.path_hashmap.put(Util.stackTraceToString(stack), node);
        }
        catch (Exception exception) {}
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            this.buildPathMap(list.item(i));
            ++i;
        }
    }

    public String getProgramPrefix() {
        return this.program_prefix;
    }

    public NamespaceTranslator createNamespaceTranslator() {
        return new NamespaceTranslator(this.program_prefix, this);
    }

    public void addJavaQNameMapping(String java_qname, String namespace, String name) {
        this.nicepkgs.put(java_qname, namespace);
        this.nicenames.put(java_qname, name);
    }

    public String getQNameFromQName(String java_qname) {
        String tmp = (String)this.nicepkgs.get(java_qname);
        System.out.println("MAPPING FOUND " + java_qname + " " + tmp);
        if (tmp != null) {
            return String.valueOf(tmp) + ":" + this.nicenames.get(java_qname);
        }
        return java_qname;
    }

    public Switches getSwitches() {
        return this.switches;
    }

    public static String reformat(String str, int depth) {
        StringBuffer sb = new StringBuffer();
        str = str.trim();
        boolean afterNL = false;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '\n') {
                afterNL = true;
                sb.append(c);
                int k = 0;
                while (k < depth) {
                    sb.append(' ');
                    ++k;
                }
            } else if (c == ' ' || c == '\t') {
                if (!afterNL) {
                    sb.append(c);
                }
            } else {
                afterNL = false;
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String replace(String str, String match, String replace) {
        StringBuffer buf = new StringBuffer();
        int pos = 0;
        int index = 0;
        while (index != -1) {
            index = str.indexOf(match, pos);
            if (index != -1) {
                buf.append(str.substring(pos, index)).append(replace);
                pos = index + match.length();
                continue;
            }
            if (pos >= str.length()) continue;
            buf.append(str.substring(pos));
        }
        return buf.toString();
    }

    public static String[] getXSDBaseTypes() {
        String[] tmp = new String[xsd_mappings.length];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = xsd_mappings[i][0];
            ++i;
        }
        return tmp;
    }

    public String getInternalJavaType(String base_ncname) {
        String xsdmapped = this.getInternalBaseMapping(base_ncname);
        if (xsdmapped != null) {
            base_ncname = xsdmapped;
        }
        int i = 0;
        while (i < java_mappings.length) {
            if (java_mappings[i][0].equals(base_ncname)) {
                return java_mappings[i][1];
            }
            ++i;
        }
        return null;
    }

    public String getInternalBaseMapping(String base_ncname) {
        String mapping;
        if (this.ncmappings == null) {
            this.ncmappings = new HashMap();
            int i = 0;
            while (i < xsd_mappings.length) {
                if (xsd_mappings[i][1] != null) {
                    this.ncmappings.put(NamespaceTranslator.getName(xsd_mappings[i][0]), NamespaceTranslator.getName(xsd_mappings[i][1]));
                }
                ++i;
            }
        }
        if ((mapping = (String)this.ncmappings.get(base_ncname)) == null) {
            return base_ncname;
        }
        return mapping;
    }

    public String getInternalBaseMapping(NamespaceTranslator nt, String qbase) throws NamespaceException {
        String mapping;
        if (this.qmappings == null) {
            this.qmappings = new HashMap();
            int i = 0;
            while (i < xsd_mappings.length) {
                if (xsd_mappings[i][1] != null) {
                    this.qmappings.put(nt.qualify(xsd_mappings[i][0], false), nt.qualify("xsd:" + xsd_mappings[i][1], false));
                }
                ++i;
            }
        }
        if ((mapping = (String)this.qmappings.get(qbase)) == null) {
            return qbase;
        }
        return mapping;
    }

    public static String getSimpleTypeBase(NamespaceTranslator nt, Element simple) throws NamespaceException {
        String base = null;
        String namespace = null;
        String tag = null;
        ArrayList children = Util.getAllElements(simple);
        int i = 0;
        while (i < children.size()) {
            Element child = (Element)children.get(i);
            namespace = nt.getPackage(child, false);
            tag = NamespaceTranslator.getName(child);
            if (namespace.equals(NamespaceTranslator.PACKAGE_XSD)) {
                if (tag.equals("restriction")) {
                    base = child.getAttribute("base");
                } else if (tag.equals("list")) {
                    base = child.getTagName();
                } else if (tag.equals("union")) {
                    base = "xsd:anyType";
                }
            }
            ++i;
        }
        if (base == null) {
            throw new NamespaceException("simpleType base not found for " + TranslatorUtils.toJavaString(simple) + " (resolved namespace into package " + namespace + ")");
        }
        return base;
    }

    public static String getSimpleTypeListType(NamespaceTranslator nt, Element simple) throws NamespaceException {
        String listType = "xsd:anyType";
        ArrayList elems = Util.getAllElements(simple);
        int i = 0;
        while (i < elems.size()) {
            Element elem = (Element)elems.get(i);
            String namespace = nt.getNamespace(elem, false);
            String tag = NamespaceTranslator.getName(elem);
            if (namespace.equals("http://www.w3.org/2001/XMLSchema") && tag.equals("list")) {
                listType = elem.getAttribute("itemType");
            }
            ++i;
        }
        return listType;
    }

    public static ArrayList getAllElements(Element elem, String name) {
        NodeList list = elem.getChildNodes();
        ArrayList<Node> elems = new ArrayList<Node>();
        int i = 0;
        while (i < list.getLength()) {
            Element tmp;
            Node node = list.item(i);
            if (node instanceof Element && NamespaceTranslator.getName((tmp = (Element)node).getTagName()).equals(name)) {
                elems.add(node);
            }
            ++i;
        }
        return elems;
    }

    public static Element getFirstElement(Element elem, String name) {
        NodeList list = elem.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Element tmp;
            Node node = list.item(i);
            if (node instanceof Element && NamespaceTranslator.getName((tmp = (Element)node).getTagName()).equals(name)) {
                return tmp;
            }
            ++i;
        }
        return null;
    }

    public static ArrayList getAllElements(Element elem) {
        NodeList list = elem.getChildNodes();
        ArrayList<Node> elems = new ArrayList<Node>();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node instanceof Element) {
                elems.add(node);
            }
            ++i;
        }
        return elems;
    }

    private static int getPosition(Node elem) {
        int pos = 0;
        Node prev = elem.getPreviousSibling();
        while (prev != null) {
            if (prev.getNodeType() == 1) {
                ++pos;
            }
            prev = prev.getPreviousSibling();
        }
        return pos;
    }

    public String getBpelLineNumberString(Node n) {
        return "(line " + Util.getLineNumber(n, this.bpel_source, this.line_hashmap, this.path_hashmap) + ")";
    }

    public int getBpelLineNumber(Node n) {
        return Util.getLineNumber(n, this.bpel_source, this.line_hashmap, this.path_hashmap);
    }

    public static String getLineNumberString(Node n, String sourceXml) {
        return "(line " + Util.getLineNumber(n, sourceXml) + ")";
    }

    public static int getLineNumber(Node n, String sourceXml) {
        return Util.getLineNumber(n, sourceXml, null, null);
    }

    private static int getLineNumber(Node n, String sourceXml, HashMap line_hashmap, HashMap path_hashmap) {
        try {
            if (line_hashmap != null) {
                return (Integer)line_hashmap.get(n);
            }
            Node origNode = n;
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.setOutputProperty("indent", "no");
            if (sourceXml == null) {
                System.out.println("Source not available for XML node line detection - generating instead");
                while (n.getParentNode() != null) {
                    if (!((n = n.getParentNode()) instanceof Document)) continue;
                    Document cfr_ignored_0 = (Document)n;
                    break;
                }
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                DOMSource ds = new DOMSource(n);
                StreamResult res = new StreamResult(bout);
                tf.transform(ds, res);
                sourceXml = new String(bout.toByteArray());
            }
            System.out.println(sourceXml);
            LineTracker linetracker = new LineTracker(origNode, path_hashmap);
            SAXSource source = new SAXSource(new InputSource(new StringReader(sourceXml)));
            SAXResult result = new SAXResult(linetracker);
            tf.transform(source, result);
            return linetracker.getLine();
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Could not find entry for (" + n.getClass().getName() + ") " + n);
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int[] getBpelStackTrace(Node elem) {
        int[] stack = (int[])this.path_hashmap.get(elem);
        if (stack == null) {
            stack = Util.getStackTrace(elem);
        }
        return stack;
    }

    public String getBpelStackTraceString(Node elem) {
        return Util.stackTraceToString(this.getBpelStackTrace(elem));
    }

    public static int[] getStackTrace(Node elem) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Node parent = elem;
        while (parent != null) {
            list.add(new Integer(Util.getPosition(parent)));
            parent = parent.getParentNode();
            if (parent == null || parent.getNodeType() != 9) continue;
            parent = null;
        }
        Collections.reverse(list);
        int[] ret = new int[list.size()];
        int i = 0;
        while (i < ret.length) {
            ret[i] = (Integer)list.get(i);
            ++i;
        }
        return ret;
    }

    public static String getStackTraceString(Node elem) {
        if (elem == null) {
            return "(n/a)";
        }
        int[] trace = Util.getStackTrace(elem);
        return Util.stackTraceToString(trace);
    }

    public static int[] getStackTraceFromString(String tracestr) throws NoSuchElementException, NumberFormatException {
        StringTokenizer tok = new StringTokenizer(tracestr, "(, \t\n)");
        int[] trace = new int[tok.countTokens()];
        int i = 0;
        while (i < trace.length) {
            String token = tok.nextToken();
            trace[i] = Integer.parseInt(token.trim());
            ++i;
        }
        return trace;
    }

    public static String stackTraceToString(int[] trace) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        int i = 0;
        while (i < trace.length) {
            sb.append(trace[i]);
            if (i < trace.length - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public static String getTextDirectlyUnder(Element elem) {
        StringBuffer sb = new StringBuffer();
        NodeList list = elem.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node n = list.item(i);
            if (n.getNodeType() == 3) {
                sb.append(n.getNodeValue());
            }
            ++i;
        }
        return sb.toString();
    }

    public static String[] split(String str) {
        ArrayList<String> strings = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == ' ' || c == '\t') {
                if (sb.length() > 0) {
                    strings.add(sb.toString());
                    sb.setLength(0);
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        if (sb.length() > 0) {
            strings.add(sb.toString());
            sb.setLength(0);
        }
        String[] ret = new String[strings.size()];
        int i2 = 0;
        while (i2 < ret.length) {
            ret[i2] = (String)strings.get(i2);
            ++i2;
        }
        return ret;
    }

    private static class LineTracker
    implements ContentHandler {
        int line = -1;
        int col = -1;
        Locator loc;
        Node n;
        HashMap line_hashmap;
        HashMap path_hashmap;
        int[] path;
        int[] curr;
        int depth = 0;

        public int getLine() {
            return this.line;
        }

        public LineTracker(Node n, HashMap path_hashmap) {
            this.n = n;
            this.path = path_hashmap != null ? (int[])path_hashmap.get(n) : Util.getStackTrace(n);
            this.curr = new int[this.path.length];
            Arrays.fill(this.curr, -1);
        }

        public LineTracker(HashMap line_hashmap, HashMap path_hashmap) {
            this.line_hashmap = line_hashmap;
            this.path_hashmap = path_hashmap;
            this.curr = new int[10000];
            Arrays.fill(this.curr, -1);
        }

        public void endDocument() throws SAXException {
        }

        public void startDocument() throws SAXException {
        }

        public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        public void endPrefixMapping(String arg0) throws SAXException {
        }

        public void skippedEntity(String arg0) throws SAXException {
        }

        public void setDocumentLocator(Locator arg0) {
            this.loc = arg0;
        }

        public void processingInstruction(String arg0, String arg1) throws SAXException {
        }

        public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        }

        public void endElement(String arg0, String arg1, String arg2) throws SAXException {
            if (this.depth < this.curr.length) {
                this.curr[this.depth] = -1;
            }
            --this.depth;
        }

        public void startElement(String arg0, String arg1, String arg2, Attributes arg3) throws SAXException {
            try {
                if (this.depth < this.curr.length) {
                    int n = this.depth;
                    this.curr[n] = this.curr[n] + 1;
                }
                if (this.line_hashmap != null) {
                    int[] tmp = new int[this.depth];
                    System.arraycopy(this.curr, 0, tmp, 0, this.depth);
                    Object key = this.path_hashmap.get(Util.stackTraceToString(tmp));
                    if (key != null) {
                        System.out.println("ENTERING LINE NUMBER " + this.loc.getLineNumber() + " - " + arg1);
                        this.line_hashmap.put(key, new Integer(this.loc.getLineNumber()));
                    }
                } else if (Arrays.equals(this.path, this.curr) && this.line == -1) {
                    this.line = this.loc.getLineNumber();
                    this.col = this.loc.getColumnNumber();
                }
                ++this.depth;
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.exit(0);
            }
        }
    }
}

