/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.compiler.xpath;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Stack;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.ScopeStack;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceException;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceTranslator;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xpath.XPATHTranslatorException;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xpath.XPATHTreePrecomputer;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xpath.XPathNode;
import org.eclipse.stp.b2j.core.xpath.internal.XPathParser;
import org.eclipse.stp.b2j.core.xpath.internal.XPathVisitor;
import org.w3c.dom.Node;

public class XPATHTreeBuilder
extends XPathVisitor {
    NamespaceTranslator nt;
    XPathNode roots = new XPathNode(-1);
    Stack nodestack = new Stack();
    ArrayList exceptions = new ArrayList();

    public XPATHTreeBuilder(NamespaceTranslator nt) {
        this.nt = nt;
    }

    public static void main(String[] args) {
        ScopeStack sstack = new ScopeStack(null);
        String[] expressions = new String[]{"1 + 4 + 5 + (14 div 7)", "5 + (14 div 7)", "14 div 7", "1 + 4", "-1000", "(100 + 7) > (100 + 5)", "momally($myvar)", "$myvar/one/two[777]", "bpws:getVariableData(\"myvar\",\"one\",\"two[777]\")", "bpws:getVariableData(\"myvar\",\"one\")", "bpws:getVariableData(\"myvar\")"};
        try {
            sstack.pushScope("SCOPE", false, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sstack.addVariable("myvar", "VARTYPE");
        try {
            XPATHTreeBuilder res = new XPATHTreeBuilder(new NamespaceTranslator(""));
            int i = 0;
            while (i < expressions.length) {
                res.resolveToTree(expressions[i], sstack, null);
                ++i;
            }
            XPathNode roots = res.roots;
            System.out.println("Original Expressions:");
            XPATHTreeBuilder.printRoots(roots);
            XPATHTreePrecomputer precomp = new XPATHTreePrecomputer();
            precomp.precompute(roots);
            System.out.println("Precomputed Expressions:");
            XPATHTreeBuilder.printRoots(roots);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public XPathNode getRootExpressionsContainer() {
        return this.roots;
    }

    private static void printRoots(XPathNode roots) {
        int i = 0;
        while (i < roots.getChildCount()) {
            System.out.println(roots.getChild(i));
            ++i;
        }
    }

    private void checkForExceptions(String expression, Node source) throws Exception {
        int i = 0;
        if (i < this.exceptions.size()) {
            ((Exception)this.exceptions.get(i)).printStackTrace();
            throw XPATHTranslatorException.parserError((Exception)this.exceptions.get(i), expression, source);
        }
    }

    private void error(String s) {
        this.exceptions.add(new Exception(s));
    }

    public void resolveToTree(String expression, ScopeStack scopes, Node source) throws Exception {
        try {
            XPathParser parser = new XPathParser(new StringReader(expression));
            parser.XPath(this);
            this.checkForExceptions(expression, source);
            XPathNode root = new XPathNode(-3);
            while (!this.nodestack.isEmpty()) {
                root.insertChild((XPathNode)this.nodestack.pop());
            }
            this.roots.addChild(root);
        }
        catch (Exception e) {
            this.checkForExceptions(expression, source);
            throw XPATHTranslatorException.parserError(e, expression, source);
        }
    }

    public void prePredicateEval() {
        XPathNode node = new XPathNode(0);
        this.nodestack.push(node);
    }

    public void postPredicateEval() {
        XPathNode node = new XPathNode(1);
        XPathNode arg = (XPathNode)this.nodestack.pop();
        while (arg.getType() != 0) {
            node.insertChild(arg);
            arg = (XPathNode)this.nodestack.pop();
        }
        this.nodestack.push(node);
    }

    public void processNumber() {
        String number = String.valueOf(this.pop());
        XPathNode node = new XPathNode(2);
        node.addArg(number);
        this.nodestack.push(node);
    }

    public void processLiteral() {
        String literal = String.valueOf(this.pop());
        XPathNode node = new XPathNode(3);
        node.addArg(literal);
        this.nodestack.push(node);
    }

    public void processSlash() {
    }

    public void processAbsoluteSlash() {
    }

    public void processAbbreviatedAbsoluteSlash() {
    }

    public void processAbbreviatedRelativeSlash() {
    }

    public void setContextNode() {
    }

    public void evaluateAdditiveExpr() {
        String operator = String.valueOf(this.pop());
        XPathNode node = new XPathNode(4);
        node.addArg(operator);
        node.insertChild((XPathNode)this.nodestack.pop());
        node.insertChild((XPathNode)this.nodestack.pop());
        this.nodestack.push(node);
    }

    public void evaluateMultiplicativeExpr() {
        String operator = String.valueOf(this.pop());
        XPathNode node = new XPathNode(5);
        node.addArg(operator);
        node.insertChild((XPathNode)this.nodestack.pop());
        node.insertChild((XPathNode)this.nodestack.pop());
        this.nodestack.push(node);
    }

    public void evaluateUnaryExpr() {
        String operator = String.valueOf(this.pop());
        XPathNode node = new XPathNode(6);
        node.addArg(operator);
        node.insertChild((XPathNode)this.nodestack.pop());
        this.nodestack.push(node);
    }

    public void evaluateRelationalExpr() {
        String operator = String.valueOf(this.pop());
        XPathNode node = new XPathNode(7);
        node.addArg(operator);
        node.insertChild((XPathNode)this.nodestack.pop());
        node.insertChild((XPathNode)this.nodestack.pop());
        this.nodestack.push(node);
    }

    public void evaluateEqualityExpr() {
        String operator = String.valueOf(this.pop());
        XPathNode node = new XPathNode(8);
        node.addArg(operator);
        node.insertChild((XPathNode)this.nodestack.pop());
        node.insertChild((XPathNode)this.nodestack.pop());
        this.nodestack.push(node);
    }

    public void evaluateAndExpr() {
        String operator = String.valueOf(this.pop());
        XPathNode node = new XPathNode(9);
        node.addArg(operator);
        node.insertChild((XPathNode)this.nodestack.pop());
        node.insertChild((XPathNode)this.nodestack.pop());
        this.nodestack.push(node);
    }

    public void evaluateOrExpr() {
        String operator = String.valueOf(this.pop());
        XPathNode node = new XPathNode(10);
        node.addArg(operator);
        node.insertChild((XPathNode)this.nodestack.pop());
        node.insertChild((XPathNode)this.nodestack.pop());
        this.nodestack.push(node);
    }

    public void evaluateRelativePathPattern() {
    }

    public void evaluateRelativeLocationPath() {
    }

    public void evaluateStepPredicate() {
    }

    public void evaluateQName() {
    }

    public void evaluateQNameWONodeType() {
    }

    public void evaluatePattern() {
    }

    public void evaluateSingleIDKeyPattern() {
    }

    public void evaluateDoubleIDKeyPattern() {
    }

    public void evaluateVariableReference() {
        String tovariable = "" + this.pop();
        String cfr_ignored_0 = "" + this.pop();
        XPathNode node = new XPathNode(12);
        node.addArg(tovariable);
        this.nodestack.push(node);
    }

    public void evaluateWildCardQName() {
    }

    public void evaluateWildCardStar() {
    }

    public void evaluateWildCardNCName() {
    }

    public void evaluatePrimaryFilterExpr() {
    }

    public void evaluatePathExpr() {
    }

    public void evaluateUnionExpr() {
    }

    public void evaluateAbsoluteLocationPath() {
    }

    public void evaluateProcessingInstruction() {
    }

    public void evaluateAbbreviatedAbsoluteLocationPath() {
    }

    public void evaluateAbbreviatedRelativeLocationPath() {
    }

    public void evaluateLocationIDPathPattern() {
    }

    public void evaluateLocationRelPathPattern() {
    }

    public void evaluateLocationPathPattern() {
    }

    public void evaluateFunctionCall() {
        String.valueOf(this.pop());
        int args = Integer.parseInt("" + this.pop());
        String openB = String.valueOf(this.pop());
        String function = openB.equals("(") ? String.valueOf(this.pop()) : openB;
        XPathNode node = new XPathNode(13);
        node.addArg(function);
        int i = 0;
        while (i < args) {
            node.insertChild((XPathNode)this.nodestack.pop());
            ++i;
        }
        if (function.equals("getVariableData")) {
            this.error("function getVariableData(...) has been removed from the BPEL specification, instead use $variablename");
        } else if (function.equals("getVariableProperty")) {
            if (node.getChildCount() < 2) {
                this.error("getVariableProperty function must have exactly 2 arguments");
            }
            int k = 0;
            while (k < node.getChildCount()) {
                if (node.getChild(k).getType() != 3) {
                    this.error("all arguments to bpel getVariableProperty function must be string literals");
                }
                ++k;
            }
            String varname = String.valueOf(node.getChild(0).getArg(0));
            String propname = String.valueOf(node.getChild(1).getArg(0));
            varname = this.removeQuotes(varname);
            propname = this.removeQuotes(propname);
            try {
                propname = this.nt.qualify(propname, false);
            }
            catch (NamespaceException namespaceException) {
                this.error("Failed to translate namespace of property " + propname);
            }
            XPathParser parser = new XPathParser(new StringReader("$" + varname));
            try {
                parser.XPath(this);
            }
            catch (Exception e) {
                this.error(this.getStackTrace(e));
            }
            node.removeChild(node.getChild(0));
            node.removeChild(node.getChild(0));
            node.addArg(varname);
            node.addArg(propname);
            this.nodestack.push(node);
        } else if (function.equals("getLinkStatus")) {
            this.error("function getLinkStatus(...) has been removed from the BPEL specification, instead use $linkname");
        } else {
            this.nodestack.push(node);
        }
    }

    public void evaluateNodeTypeTest() {
        String.valueOf(this.pop());
        String arg = String.valueOf(this.pop());
        if (arg.equals("(")) {
            arg = "";
        } else {
            this.pop();
        }
        String function = String.valueOf(this.pop());
        XPathNode node = new XPathNode(16);
        node.addArg(function);
        this.nodestack.push(node);
    }

    public void evaluateNameTest() {
        String name = String.valueOf(this.pop());
        XPathNode node = new XPathNode(14);
        node.addArg(name);
        this.nodestack.push(node);
    }

    public void evaluateAxisSpecifier() {
        String axis = String.valueOf(this.peek());
        if (axis.equals("/")) {
            axis = "child::";
        }
        if (!axis.equals("null") && axis.endsWith("::")) {
            this.pop();
            this.pop();
            axis = axis.substring(0, axis.length() - 2);
            XPathNode node = new XPathNode(15);
            node.addArg(axis);
            this.nodestack.push(node);
        }
    }

    private String removeQuotes(String s) {
        if (s.length() > 1 && (s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'"))) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public String getStackTrace(Throwable t) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        t.printStackTrace(ps);
        return os.toString();
    }
}

