/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.wsif;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.TranslatorLog;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Util;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.WSDLMap;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.WSDLMessage;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.WSDLOperation;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.WSDLPortType;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceException;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceTranslator;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xsdmap.XSDMap;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.wsif.WSIFFormatTypeCodec;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.WSDLBindingTranslator;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.WSDLBindingTranslatorException;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.XSDTypeTranslator;
import org.w3c.dom.Element;

public class WSIFJavaBindingTranslator
implements WSDLBindingTranslator {
    public static final String NAMESPACE_JAVABINDING = "http://schemas.xmlsoap.org/wsdl/java/";
    public static int METHOD_TYPE_INSTANCE = 0;
    public static int METHOD_TYPE_STATIC = 1;
    public static int METHOD_TYPE_CONSTRUCTOR = 2;
    private static final String LOG_SOURCE = "Java Binding: ";
    private static int XSDID = 0;
    String portHolderType;
    String portHolder;
    WSIFFormatTypeCodec codec_formatType;
    XSDTypeTranslator[] codecs;
    HashMap bindings;
    XSDMap xsdmap;
    WSDLMap wsdlmap;
    Util compiler_util;
    TranslatorLog log;
    ClassLoader dependancy_loader;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public WSIFJavaBindingTranslator() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.wsif.WSIFJavaBinding");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.portHolderType = clazz.getName();
        this.portHolder = "org_eclipse_stp_b2j_core_jengine_internal_extensions_wsif_JavaBinding";
        this.bindings = new HashMap();
    }

    private static String getNextXsdId() {
        return "wsifjava_xsdtype_" + XSDID++;
    }

    private static String getNextPortId() {
        return "wsifjava_port_" + XSDID++;
    }

    public String getID() {
        return this.getClass().getName();
    }

    public String getHumanReadableName() {
        return "Default Java Binding";
    }

    public void init(Util compiler_util, TranslatorLog log, XSDMap xsdmap, WSDLMap wsdlmap, ClassLoader dependancy_loader) {
        this.xsdmap = xsdmap;
        this.wsdlmap = wsdlmap;
        this.dependancy_loader = dependancy_loader;
        this.compiler_util = compiler_util;
        this.log = log;
        this.codec_formatType = new WSIFFormatTypeCodec();
        this.codecs = new XSDTypeTranslator[]{this.codec_formatType};
    }

    private boolean isBindingOurs(NamespaceTranslator nt, Element elem) throws NamespaceException {
        ArrayList elems = Util.getAllElements(elem);
        int i = 0;
        while (i < elems.size()) {
            Element jbinding = (Element)elems.get(i);
            nt.addNamespaces(jbinding);
            if (nt.checkQName(jbinding, NAMESPACE_JAVABINDING, "binding")) {
                return true;
            }
            nt.removeNamespaces(jbinding);
            ++i;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readOperations(NamespaceTranslator nt, Binding binding, Element elem) throws NamespaceException, WSDLBindingTranslatorException {
        ArrayList wsops = Util.getAllElements(elem);
        int i = 0;
        while (i < wsops.size()) {
            Element wsop = (Element)wsops.get(i);
            nt.addNamespaces(wsop);
            if (NamespaceTranslator.getName(wsop).equals("operation")) {
                ArrayList jops = Util.getAllElements(wsop);
                int k = 0;
                while (k < jops.size()) {
                    Element jop = (Element)jops.get(k);
                    nt.addNamespaces(jop);
                    if (nt.checkQName(jop, NAMESPACE_JAVABINDING, "operation")) {
                        WSDLMessage outputmsg;
                        boolean returnRequired;
                        Operation op = new Operation();
                        op.operationName = wsop.getAttribute("name");
                        op.methodName = jop.getAttribute("methodName");
                        WSDLPortType wsdlpt = this.wsdlmap.getPortType(binding.qportType);
                        WSDLOperation wsdlop = wsdlpt.getOperation(op.operationName);
                        if (wsdlop == null) {
                            throw new WSDLBindingTranslatorException("WSIF Java Binding specified operation " + op.operationName + " on portType " + this.compiler_util.getQNameFromQName(binding.qportType) + " not found");
                        }
                        if (op.methodName == null) {
                            throw new WSDLBindingTranslatorException("methodName attribute is required for WSIF Java binding operation");
                        }
                        if (op.methodName.length() == 0) {
                            throw new WSDLBindingTranslatorException("methodName attribute is required for WSIF Java binding operation");
                        }
                        op.parameterOrder = Util.split(jop.getAttribute("parameterOrder"));
                        op.returnPart = jop.getAttribute("returnPart");
                        WSDLMessage inputmsg = this.wsdlmap.getMessage(wsdlop.getMessageType("input"));
                        int z = 0;
                        while (z < op.parameterOrder.length) {
                            if (inputmsg.getPartType(op.parameterOrder[z]) == null) {
                                throw new WSDLBindingTranslatorException("WSIF Java Binding found no part \"" + op.parameterOrder[z] + "\" as specified in parameter list of portType " + this.compiler_util.getQNameFromQName(binding.qportType) + ", operation " + op.operationName);
                            }
                            ++z;
                        }
                        boolean bl = returnRequired = wsdlop.getType() == 1;
                        if (op.returnPart == null && returnRequired) {
                            throw new WSDLBindingTranslatorException("WSIF Java Binding specified no returnPart attribute but WSDL operation type is request-response");
                        }
                        if (op.returnPart.length() == 0 && returnRequired) {
                            this.log.logWarning(LOG_SOURCE, "WSIF Java Binding return type required but no return type specified");
                            returnRequired = false;
                        }
                        if (returnRequired && (outputmsg = this.wsdlmap.getMessage(wsdlop.getMessageType("output"))).getPartType(op.returnPart) == null) {
                            throw new WSDLBindingTranslatorException("WSIF Java Binding found no part \"" + op.returnPart + "\" in message " + this.compiler_util.getQNameFromQName(wsdlop.getMessageType("output")) + " as specified in return list of portType " + this.compiler_util.getQNameFromQName(binding.qportType) + ", operation " + op.operationName);
                        }
                        String mtype = jop.getAttribute("methodType");
                        if (mtype == null) {
                            mtype = "";
                        }
                        if (mtype.length() > 0) {
                            if (mtype.equals("instance")) {
                                op.methodType = METHOD_TYPE_INSTANCE;
                            } else if (mtype.equals("static")) {
                                op.methodType = METHOD_TYPE_STATIC;
                            } else {
                                if (!mtype.equals("constructor")) throw new WSDLBindingTranslatorException("methodType attribute must be one of 'instance', 'static' or 'constructor'");
                                op.methodType = METHOD_TYPE_CONSTRUCTOR;
                            }
                        } else {
                            op.methodType = METHOD_TYPE_INSTANCE;
                        }
                        binding.operations.put(op.operationName, op);
                    }
                    nt.removeNamespaces(jop);
                    ++k;
                }
            }
            nt.removeNamespaces(wsop);
            ++i;
        }
    }

    private void readEPR(NamespaceTranslator nt, Element port, Binding binding) throws NamespaceException, WSDLBindingTranslatorException {
        String portName = port.getAttribute("name");
        ArrayList jports = Util.getAllElements(port);
        int i = 0;
        while (i < jports.size()) {
            Element jport = (Element)jports.get(i);
            nt.addNamespaces(jport);
            if (nt.checkQName(jport, NAMESPACE_JAVABINDING, "address")) {
                binding.portName = portName;
                binding.className = jport.getAttribute("className");
                binding.classPath = jport.getAttribute("classPath");
                binding.classLoader = jport.getAttribute("classLoader");
                if (binding.className == null) {
                    throw new WSDLBindingTranslatorException("WSIF Java Binding service port binding specified but no className attribute - className attribute is required");
                }
                if (binding.className.length() == 0) {
                    throw new WSDLBindingTranslatorException("WSIF Java Binding service port binding specified but no className attribute - className attribute is required");
                }
            }
            nt.removeNamespaces(jport);
            ++i;
        }
    }

    public void readWSDL(Element wsdl_definitions) throws NamespaceException, WSDLBindingTranslatorException {
        Element elem;
        NamespaceTranslator nt = this.compiler_util.createNamespaceTranslator();
        nt.addNamespaces(wsdl_definitions);
        ArrayList elems = Util.getAllElements(wsdl_definitions);
        int i = 0;
        while (i < elems.size()) {
            elem = (Element)elems.get(i);
            nt.addNamespaces(elem);
            if (NamespaceTranslator.getName(elem).equals("binding")) {
                String name = elem.getAttribute("name");
                String ptype = elem.getAttribute("type");
                if (this.isBindingOurs(nt, elem)) {
                    Binding binding = new Binding();
                    binding.qname = nt.qualify(name, true);
                    binding.qportType = nt.qualify(ptype, false);
                    binding.bindingName = nt.qualify(name, true);
                    WSDLPortType wsdlpt = this.wsdlmap.getPortType(binding.qportType);
                    if (wsdlpt == null) {
                        throw new WSDLBindingTranslatorException("WSIF Java Binding specified portType " + this.compiler_util.getQNameFromQName(binding.qportType) + " not found");
                    }
                    this.readOperations(nt, binding, elem);
                    this.bindings.put(binding.qportType, binding);
                    this.bindings.put(binding.qname, binding);
                    this.bindings.put(binding.bindingName, binding);
                }
            }
            nt.removeNamespaces(elem);
            ++i;
        }
        i = 0;
        while (i < elems.size()) {
            elem = (Element)elems.get(i);
            nt.addNamespaces(elem);
            if (NamespaceTranslator.getName(elem).equals("service")) {
                ArrayList ports = Util.getAllElements(elem);
                int k = 0;
                while (k < ports.size()) {
                    Element port = (Element)ports.get(k);
                    nt.addNamespaces(port);
                    if (NamespaceTranslator.getName(port).equals("port")) {
                        port.getAttribute("name");
                        String qbindingType = nt.qualify(port.getAttribute("binding"), false);
                        Binding binding = (Binding)this.bindings.get(qbindingType);
                        if (binding != null) {
                            this.readEPR(nt, port, binding);
                        }
                    }
                    nt.removeNamespaces(port);
                    ++k;
                }
            }
            nt.removeNamespaces(elem);
            ++i;
        }
    }

    public XSDTypeTranslator[] getCodecs() {
        return this.codecs;
    }

    private Binding checkForBindingNamed(String name) throws WSDLBindingTranslatorException {
        if (name == null) {
            return null;
        }
        Binding binding = (Binding)this.bindings.get(name);
        if (binding == null) {
            throw new WSDLBindingTranslatorException("no WSIF Java binding found named '" + this.compiler_util.getQNameFromQName(name) + "'");
        }
        return binding;
    }

    private Binding checkForBinding(String qportType) throws WSDLBindingTranslatorException {
        Binding binding = (Binding)this.bindings.get(qportType);
        if (binding == null) {
            throw new WSDLBindingTranslatorException("no WSIF Java binding found for port type " + this.compiler_util.getQNameFromQName(qportType));
        }
        return binding;
    }

    public String translateInvocation(NamespaceTranslator nt, String qportType, String bindingName, String operation, String eprFieldName, String correlationSetFieldNameIn, String correlationSetFieldNameOut, String inputFieldName, String outputFieldName) throws NamespaceException, WSDLBindingTranslatorException {
        StringBuffer sb = new StringBuffer();
        this.checkForBindingNamed(bindingName);
        Binding binding = this.checkForBinding(qportType);
        Operation jop = (Operation)binding.operations.get(operation);
        if (jop == null) {
            throw new WSDLBindingTranslatorException("java operation mapping not found for portType " + this.compiler_util.getQNameFromQName(qportType) + ", operation " + operation);
        }
        WSDLOperation wsop = this.wsdlmap.getPortType(qportType).getOperation(operation);
        String qinputType = wsop.getMessageType("input");
        String qoutputType = wsop.getMessageType("output");
        WSDLMessage inputMessage = this.wsdlmap.getMessage(qinputType);
        WSDLMessage outputMessage = this.wsdlmap.getMessage(qoutputType);
        boolean returnRequired = false;
        if (wsop.getType() == 1) {
            returnRequired = true;
        } else if (wsop.getType() == 0) {
            returnRequired = false;
        } else {
            throw new WSDLBindingTranslatorException("WSIF Java Binding Translator - only WSDL operations of type One-way or Request-response are supported");
        }
        if (inputMessage == null) {
            throw new WSDLBindingTranslatorException("WSIF Java Binding Translator - input message required for operation " + operation + " in port type " + this.compiler_util.getQNameFromQName(qportType));
        }
        if (outputMessage == null && returnRequired) {
            throw new WSDLBindingTranslatorException("WSIF Java Binding Translator - output message required for operation " + operation + " in port type " + this.compiler_util.getQNameFromQName(qportType));
        }
        String[] paramTypes = new String[jop.parameterOrder.length];
        int i = 0;
        while (i < paramTypes.length) {
            paramTypes[i] = inputMessage.getPartType(jop.parameterOrder[i]);
            ++i;
        }
        String returnType = null;
        String returnName = null;
        if (returnRequired) {
            returnType = outputMessage.getPartType(jop.returnPart);
            returnName = WSIFJavaBindingTranslator.getNextXsdId();
        }
        if (inputFieldName == null) {
            throw new WSDLBindingTranslatorException("WSIF Java Binding Translator - input variable required for operation " + operation + " in port type " + this.compiler_util.getQNameFromQName(qportType));
        }
        if (inputFieldName.length() == 0) {
            throw new WSDLBindingTranslatorException("WSIF Java Binding Translator - input variable required for operation " + operation + " in port type " + this.compiler_util.getQNameFromQName(qportType));
        }
        if (returnRequired) {
            if (outputFieldName == null) {
                throw new WSDLBindingTranslatorException("WSIF Java Binding Translator - output variable required for operation " + operation + " in port type " + this.compiler_util.getQNameFromQName(qportType));
            }
            if (outputFieldName.length() == 0) {
                throw new WSDLBindingTranslatorException("WSIF Java Binding Translator - output variable required for operation " + operation + " in port type " + this.compiler_util.getQNameFromQName(qportType));
            }
        }
        String paramsName = WSIFJavaBindingTranslator.getNextXsdId();
        sb.append("Object[] ");
        sb.append(paramsName);
        sb.append(" = ");
        sb.append("new Object[] {\n");
        int i2 = 0;
        while (i2 < paramTypes.length) {
            String toJavaFunction = this.codec_formatType.getToJavaFunction(paramTypes[i2], qportType);
            sb.append(paramTypes[i2]);
            sb.append(".");
            sb.append(toJavaFunction);
            sb.append("(");
            sb.append(inputFieldName);
            sb.append(".");
            sb.append(NamespaceTranslator.getElement(jop.parameterOrder[i2]));
            sb.append("[0]");
            sb.append(")");
            sb.append(",\n");
            ++i2;
        }
        sb.append("};\n");
        String portName = WSIFJavaBindingTranslator.getNextPortId();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.wsif.WSIFJavaPort");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sb.append(String.valueOf(clazz.getName()) + " ");
        sb.append(portName);
        StringBuffer stringBuffer = new StringBuffer(" = (");
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.wsif.WSIFJavaPort");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sb.append(stringBuffer.append(clazz2.getName()).append(")").toString());
        sb.append(this.portHolder);
        sb.append(".getPortGroupForEndpointReference(" + eprFieldName + "," + correlationSetFieldNameOut + ")");
        sb.append(".getPort();\n");
        if (returnRequired && returnType == null) {
            this.log.logWarning(LOG_SOURCE, "WSIF Java Binding return type required but no return type specified");
            returnRequired = false;
        }
        if (returnRequired) {
            sb.append("Object " + returnName + " = " + portName + ".invoke(\"" + jop.methodName + "\"," + paramsName + ");\n");
            String fromJavaFunction = this.codec_formatType.getFromJavaFunction(returnType, qportType);
            sb.append(String.valueOf(outputFieldName) + "." + NamespaceTranslator.getElement(jop.returnPart) + " = new " + returnType + "[1];\n");
            sb.append(String.valueOf(outputFieldName) + "." + NamespaceTranslator.getElement(jop.returnPart) + "[0] = (" + returnType + ") " + returnType + "." + fromJavaFunction + "((" + this.codec_formatType.getJavaType(returnType, qportType) + ")" + returnName + ");\n");
        } else {
            sb.append(String.valueOf(portName) + ".invoke(\"" + jop.methodName + "\"," + paramsName + ");\n");
        }
        return sb.toString();
    }

    public String translateReceive(NamespaceTranslator nt, String qportType, String bindingName, String operation, String messageExchange, String eprFieldName, String correlationSetFieldName, String inputFieldName) throws NamespaceException, WSDLBindingTranslatorException {
        throw new WSDLBindingTranslatorException("WSIF Java Binding: cannot translate <receive> activity for a Java port");
    }

    public String translateReply(NamespaceTranslator nt, String qportType, String bindingName, String operation, String messageExchange, String eprFieldName, String correlationSetFieldName, String outputFieldName) throws NamespaceException, WSDLBindingTranslatorException {
        throw new WSDLBindingTranslatorException("WSIF Java Binding: cannot translate <reply> activity for a Java port");
    }

    public String translateDefaultEPR(NamespaceTranslator nt, String qportType, String bindingName) throws NamespaceException, WSDLBindingTranslatorException {
        StringBuffer sb = new StringBuffer();
        this.checkForBindingNamed(bindingName);
        Binding binding = this.checkForBinding(qportType);
        if (bindingName != null) {
            binding = (Binding)this.bindings.get(bindingName);
        }
        if (binding.className == null) {
            throw new WSDLBindingTranslatorException("no default classname found for WSIF Java Binding of portType " + this.compiler_util.getQNameFromQName(qportType));
        }
        sb.append("new WSEndpointReference(\"" + binding.className + "\")");
        return sb.toString();
    }

    public void translatePickStart(int onMessageCount, int onAlarmCount, String timeoutFieldLongMs) throws NamespaceException, WSDLBindingTranslatorException {
        throw new WSDLBindingTranslatorException("WSIF Java Binding: cannot translate <pick> activity for a Java port");
    }

    public void translatePickOnMessage(NamespaceTranslator nt, String qportType, String bindingName, String operation, String messageExchange, String eprFieldName, String correlationSetFieldName, String inputFieldName) throws NamespaceException, WSDLBindingTranslatorException {
        throw new WSDLBindingTranslatorException("WSIF Java Binding: cannot translate <pick> activity for a Java port");
    }

    public String translatePickFinish(String indexFieldName) throws NamespaceException, WSDLBindingTranslatorException {
        throw new WSDLBindingTranslatorException("WSIF Java Binding: cannot translate <pick> activity for a Java port");
    }

    public String getDeclarations() {
        StringBuffer decl = new StringBuffer();
        decl.append("static ");
        decl.append(this.portHolderType);
        decl.append(" ");
        decl.append(this.portHolder);
        decl.append(" = new ");
        decl.append(this.portHolderType);
        decl.append("();\n");
        return decl.toString();
    }

    public String[] getImports() {
        return new String[]{this.portHolderType};
    }

    class Binding {
        String qname;
        String qportType;
        HashMap operations = new HashMap();
        String bindingName;
        String portName;
        String className;
        String classPath;
        String classLoader;

        Binding() {
        }
    }

    class Operation {
        String operationName;
        String methodName;
        String[] parameterOrder;
        String returnPart;
        int methodType;

        Operation() {
        }
    }
}

